/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.register.service.impl;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.register.service.IHussarNacosService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HussarNacosServiceImpl
implements IHussarNacosService {
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private NacosDiscoveryProperties discoveryProperties;
    @Autowired
    private NacosServiceManager nacosServiceManager;
    @Resource
    private ISysDicRefService sysDicRefService;

    public ApiResponse<String> getNamespace() {
        String namespace = this.discoveryProperties.getNamespace();
        if (StringUtils.isBlank((CharSequence)namespace)) {
            namespace = "public";
        }
        return ApiResponse.success((Object)namespace, (String)"\u67e5\u8be2\u547d\u540d\u7a7a\u95f4\u6210\u529f\uff01");
    }

    public ApiResponse<Object> listDetail(boolean hasIpCount, boolean withInstances, String groupName, String serviceName, String containedInstance, int pageNo, int pageSize) {
        List services = this.discoveryClient.getServices();
        JSONObject result = new JSONObject();
        int count = 0;
        List<JSONObject> serviceList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)services)) {
            if (StringUtils.isNotBlank((CharSequence)serviceName)) {
                services = services.stream().filter(item -> item.contains(serviceName)).collect(Collectors.toList());
            }
            if ((count = services.size()) > 0) {
                for (String servcie : services) {
                    boolean groupMatch;
                    JSONObject node = new JSONObject();
                    boolean triggerFlag = false;
                    boolean formdesign = false;
                    HashSet<String> cluster = new HashSet<String>();
                    int ipCount = 0;
                    int healthyInstanceCount = 0;
                    String group = null;
                    List instances = new ArrayList();
                    try {
                        instances = this.discoveryProperties.namingServiceInstance().getAllInstances(servcie);
                        Properties properties = this.discoveryProperties.getNacosProperties();
                        com.alibaba.nacos.api.naming.pojo.Service serviceTesmp = this.nacosServiceManager.getNamingMaintainService(properties).queryService(servcie);
                        if (serviceTesmp.getProtectThreshold() > 0.0f) {
                            triggerFlag = true;
                        }
                        group = serviceTesmp.getGroupName();
                        ipCount = instances.size();
                        for (Instance instance : instances) {
                            if (instance.isHealthy()) {
                                ++healthyInstanceCount;
                            }
                            cluster.add("cluster" + StringUtils.trimToEmpty((String)instance.getClusterName()));
                        }
                        if (ipCount > 0) {
                            Map metadata = ((Instance)instances.get(0)).getMetadata();
                            Object flag = null;
                            if (!CollectionUtils.isEmpty((Map)metadata) && (flag = (Object)metadata.get("formdesign")) != null && "true".equals(flag.toString())) {
                                formdesign = true;
                            }
                        }
                    }
                    catch (Exception properties) {
                        // empty catch block
                    }
                    if (!(groupMatch = StringUtils.isBlank((CharSequence)groupName) || group.contains(groupName))) continue;
                    node.put("name", (Object)servcie);
                    node.put("groupName", (Object)group);
                    node.put("clusterCount", (Object)cluster.size());
                    node.put("ipCount", (Object)ipCount);
                    node.put("healthyInstanceCount", (Object)healthyInstanceCount);
                    node.put("triggerFlag", (Object)triggerFlag);
                    node.put("formdesign", (Object)formdesign);
                    serviceList.add(node);
                }
                count = serviceList.size();
                int fromIndex = (pageNo - 1) * pageSize;
                int toIndex = pageNo * pageSize;
                if (toIndex > count) {
                    toIndex = count;
                }
                serviceList = serviceList.subList(fromIndex, toIndex);
            }
        }
        result.put("count", (Object)count);
        result.put("serviceList", serviceList);
        return ApiResponse.success((Object)result);
    }

    public List<String> getMicroServices() {
        List services = this.discoveryClient.getServices();
        ArrayList<String> result = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)services)) {
            for (String servcie : services) {
                int ipCount = 0;
                int healthyInstanceCount = 0;
                try {
                    List instances = this.discoveryProperties.namingServiceInstance().getAllInstances(servcie);
                    ipCount = instances.size();
                    if (ipCount <= 0) continue;
                    for (Instance instance : instances) {
                        if (!instance.isHealthy()) continue;
                        ++healthyInstanceCount;
                    }
                    if (healthyInstanceCount <= 0) continue;
                    result.add(servcie);
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public boolean isHealth(String serviceName) {
        List instances = this.discoveryClient.getInstances(serviceName);
        return HussarUtils.isNotEmpty((Object)instances);
    }

    public List<String> getBizServiceName() {
        List services = ((DiscoveryClient)SpringContextHolder.getBean(DiscoveryClient.class)).getServices();
        List serviceCommonNames = this.sysDicRefService.getDicListByType("microService_common_name");
        if (HussarUtils.isEmpty((Object)serviceCommonNames)) {
            return services;
        }
        List microServiceCommonName = serviceCommonNames.stream().map(DicVo::getValue).collect(Collectors.toList());
        return services.stream().filter(item -> !microServiceCommonName.contains(item)).collect(Collectors.toList());
    }
}

