/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.register.service.impl;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.register.service.IHussarNacosService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HussarNacosServiceImpl
implements IHussarNacosService {
    Logger logger = LoggerFactory.getLogger(HussarNacosServiceImpl.class);
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private NacosDiscoveryProperties discoveryProperties;
    @Autowired
    private NacosServiceManager nacosServiceManager;

    public ApiResponse<String> getNamespace() {
        String namespace = this.discoveryProperties.getNamespace();
        if (StringUtils.isBlank((CharSequence)namespace)) {
            namespace = "public";
        }
        return ApiResponse.success((Object)namespace, (String)"\u67e5\u8be2\u547d\u540d\u7a7a\u95f4\u6210\u529f\uff01");
    }

    public ApiResponse<Object> listDetail(boolean hasIpCount, boolean withInstances, String groupName, String serviceName, String containedInstance, int pageNo, int pageSize) {
        List services = this.discoveryClient.getServices();
        JSONObject result = new JSONObject();
        int count = 0;
        ArrayList<JSONObject> serviceList = new ArrayList<JSONObject>();
        if (!CollectionUtils.isEmpty((Collection)services)) {
            if (StringUtils.isNotBlank((CharSequence)serviceName)) {
                services = services.stream().filter(item -> item.contains(serviceName)).collect(Collectors.toList());
            }
            if ((count = services.size()) > 0) {
                List subListServices;
                int fromIndex = (pageNo - 1) * pageSize;
                int toIndex = pageNo * pageSize;
                if (toIndex > count) {
                    toIndex = count;
                }
                if (!CollectionUtils.isEmpty(subListServices = services.subList(fromIndex, toIndex))) {
                    for (String servcie : subListServices) {
                        JSONObject node = new JSONObject();
                        boolean triggerFlag = false;
                        boolean formdesign = false;
                        boolean showable = true;
                        HashSet<String> cluster = new HashSet<String>();
                        int ipCount = 0;
                        int healthyInstanceCount = 0;
                        String group = null;
                        List instances = new ArrayList();
                        try {
                            instances = StringUtils.isNotBlank((CharSequence)groupName) ? this.discoveryProperties.namingServiceInstance().getAllInstances(servcie, groupName) : this.discoveryProperties.namingServiceInstance().getAllInstances(servcie);
                            Properties properties = this.discoveryProperties.getNacosProperties();
                            com.alibaba.nacos.api.naming.pojo.Service serviceTesmp = this.nacosServiceManager.getNamingMaintainService(properties).queryService(servcie);
                            if (serviceTesmp.getProtectThreshold() > 0.0f) {
                                triggerFlag = true;
                            }
                            group = serviceTesmp.getGroupName();
                            ipCount = instances.size();
                            for (Instance instance : instances) {
                                if (instance.isHealthy()) {
                                    ++healthyInstanceCount;
                                }
                                cluster.add("cluster" + StringUtils.trimToEmpty((String)instance.getClusterName()));
                            }
                            if (ipCount > 0) {
                                Map metadata = ((Instance)instances.get(0)).getMetadata();
                                Object flag = null;
                                Object serviceControl = null;
                                if (!CollectionUtils.isEmpty((Map)metadata)) {
                                    serviceControl = metadata.get("service-control");
                                    if (serviceControl != null && "true".equals(serviceControl.toString())) {
                                        String grantRoleNames = (String)metadata.get("grant-role");
                                        this.logger.info("\u6307\u5b9a\u89d2\u8272\uff1a" + grantRoleNames);
                                        String[] roles = grantRoleNames.split(",");
                                        List<String> grantRoleList = Arrays.asList(roles);
                                        SecurityUser shiroUser = BaseSecurityUtil.getUser();
                                        List currentRoleList = shiroUser.getRoleNames();
                                        this.logger.info("\u5f53\u524d\u7528\u6237\u89d2\u8272\uff1a" + currentRoleList.toString());
                                        showable = Collections.disjoint(grantRoleList, currentRoleList);
                                    }
                                    if (!showable) {
                                        this.logger.info(serviceTesmp.getAppName() + "\u670d\u52a1\u4e0d\u4e88\u5c55\u793a");
                                        continue;
                                    }
                                    flag = metadata.get("formdesign");
                                    if (flag != null && "true".equals(flag.toString())) {
                                        formdesign = true;
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        node.put("name", (Object)servcie);
                        node.put("groupName", group);
                        node.put("clusterCount", (Object)cluster.size());
                        node.put("ipCount", (Object)ipCount);
                        node.put("healthyInstanceCount", (Object)healthyInstanceCount);
                        node.put("triggerFlag", (Object)triggerFlag);
                        node.put("formdesign", (Object)formdesign);
                        serviceList.add(node);
                    }
                }
            }
        }
        result.put("count", (Object)count);
        result.put("serviceList", serviceList);
        return ApiResponse.success((Object)result);
    }
}

