/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.register.controller;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.register.service.IHussarNacosService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarNacos"})
public class HussarNacosController {
    @Autowired
    private IHussarNacosService nacosService;

    @GetMapping(value={"/namespace"})
    public ApiResponse<String> namespace() {
        return this.nacosService.getNamespace();
    }

    @ApiOperation(value="\u83b7\u53d6nacos\u670d\u52a1\u6ce8\u518c\u5217\u8868", notes="\u83b7\u53d6nacos\u670d\u52a1\u6ce8\u518c\u5217\u8868")
    @GetMapping(value={"/services"})
    public ApiResponse<Object> listDetail(@ApiParam(value="\u662f\u5426\u8fd4\u56de\u5b9e\u4f8b", required=false) @RequestParam(required=false) boolean withInstances, @ApiParam(value="\u9875\u7801", required=false) @RequestParam(required=false) int pageNo, @ApiParam(value="\u6bcf\u9875\u6761\u6570", required=false) @RequestParam(required=false) int pageSize, @ApiParam(value="service\u540d\u79f0", required=false) @RequestParam(name="serviceNameParam", defaultValue="") String serviceName, @ApiParam(value="group\u540d\u79f0", required=false) @RequestParam(name="groupNameParam", defaultValue="") String groupName, @ApiParam(value="\u5b9e\u4f8b\u540d", required=false) @RequestParam(name="instance", defaultValue="") String containedInstance, @ApiParam(value="\u662f\u5426\u8fc7\u6ee4\u7a7a\u5b9e\u4f8b", required=false) @RequestParam(required=false) boolean hasIpCount) throws Exception {
        return this.nacosService.listDetail(hasIpCount, withInstances, groupName, serviceName, containedInstance, pageNo, pageSize);
    }

    @GetMapping(value={"/getCurrentServiceName"})
    public ApiResponse<String> getCurrentServiceName() {
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        return ApiResponse.success((String)currentServiceName);
    }

    @GetMapping(value={"/listOtherMicroServices"})
    public ApiResponse<List<String>> listOtherMicroServices() {
        List services = ((DiscoveryClient)SpringContextHolder.getBean(DiscoveryClient.class)).getServices();
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        return ApiResponse.success(services.stream().filter(item -> !item.equalsIgnoreCase(currentServiceName)).collect(Collectors.toList()));
    }
}

