/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.region.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.region.dao.SysRegionMapper;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service(value="com.jxdinfo.hussar.region.service.impl.hussarBaseRegionServiceImpl")
public class HussarBaseRegionServiceImpl
extends HussarServiceImpl<SysRegionMapper, SysRegion>
implements IHussarBaseRegionService {
    @Resource
    private SysRegionMapper sysRegionMapper;

    public List<RegionVo> getRegionInfo() {
        return this.sysRegionMapper.getRegionInfo();
    }

    public List<RegionVo> getRegionInfoByLevel(String level) {
        int Level = Integer.parseInt(level);
        ArrayList<String> levels = new ArrayList<String>();
        for (int i = 1; i <= Level; ++i) {
            String I = String.valueOf(i);
            levels.add(I);
        }
        return this.sysRegionMapper.getRegionInfoByLevels(levels);
    }

    public List<RegionVo> getRegionInfoByIds(List<Long> ids) {
        List<RegionVo> regionVos = this.sysRegionMapper.getRegionInfoByIds(ids);
        if (HussarUtils.isEmpty(regionVos)) {
            return new ArrayList<RegionVo>();
        }
        return regionVos.stream().sorted((o1, o2) -> {
            int i = ids.indexOf(o1.getId());
            int j = ids.indexOf(o2.getId());
            return Integer.compare(i, j);
        }).collect(Collectors.toList());
    }

    public List<RegionVo> getChildrenRegionInfoById(Long id) {
        return this.sysRegionMapper.getChildrenRegionInfoById(id);
    }

    public List<RegionVo> getFullPathRegionInfoByIds(List<Long> ids) {
        ArrayList<Long> regionIdList = new ArrayList<Long>();
        for (Long id : ids) {
            List<Long> regionIds = new ArrayList<Long>();
            regionIds = this.subStringId(id, regionIds);
            Collections.reverse(regionIds);
            regionIdList.addAll(regionIds);
        }
        ArrayList<Long> newRegionList = new ArrayList<Long>(new LinkedHashSet(regionIdList));
        return this.getRegionInfoByIds(newRegionList);
    }

    public List<Long> subStringId(Long id, List<Long> ids) {
        ids.add(id);
        String regionId = id.toString();
        List regionIds = ids.stream().map(x -> x + "").collect(Collectors.toList());
        if (regionId.length() > 6) {
            ids = this.subStringId(Long.parseLong(regionId.substring(0, regionId.length() - 3)), regionIds.stream().map(Long::parseLong).collect(Collectors.toList()));
        } else if (regionId.length() <= 6 && regionId.length() > 2) {
            ids = this.subStringId(Long.parseLong(regionId.substring(0, regionId.length() - 2)), regionIds.stream().map(Long::parseLong).collect(Collectors.toList()));
        }
        return ids;
    }

    public List<RegionVo> getRegionsLikeName(String searchValue, Integer level) {
        List<RegionVo> regions = this.sysRegionMapper.getRegionsLikeName(searchValue, level);
        List<RegionVo> allRegionsList = this.sysRegionMapper.getRegionInfo();
        HashMap<Long, RegionVo> allRegionsMap = new HashMap<Long, RegionVo>();
        allRegionsList.forEach(region -> allRegionsMap.put(region.getId(), (RegionVo)region));
        for (RegionVo regionVo : regions) {
            List<RegionVo> parentRegions = this.getParentRegions(regionVo, new ArrayList<RegionVo>(), allRegionsMap);
            Collections.reverse(parentRegions);
            StringBuilder fullParentName = new StringBuilder();
            for (int i = 0; i < parentRegions.size(); ++i) {
                fullParentName.append("/").append(parentRegions.get(i).getName());
            }
            regionVo.setParentName(fullParentName.toString());
        }
        return regions;
    }

    public List<RegionVo> getParentRegions(RegionVo regionVo, List<RegionVo> parentRegions, Map<Long, RegionVo> allRegionsMap) {
        parentRegions.add(regionVo);
        if (0L != regionVo.getParentId()) {
            Long parentId = regionVo.getParentId();
            RegionVo parentRegion = allRegionsMap.get(parentId);
            parentRegions = this.getParentRegions(parentRegion, parentRegions, allRegionsMap);
        }
        return parentRegions;
    }
}

