/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.quartz;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.springframework.context.ApplicationContext;

public class GroupJDBCDelegate
extends StdJDBCDelegate {
    private ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
    private List<String> triggerGroup = (List)this.applicationContext.getEnvironment().getProperty("org.quartz.trigger-group", ArrayList.class);
    private static final String IN_SPLIT_SIGN = "IN_SPLIT_SIGN";
    String SELECT_HAS_MISFIRED_TRIGGERS_IN_STATE = "SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND NOT (MISFIRE_INSTR = -1) AND NEXT_FIRE_TIME < ? AND TRIGGER_STATE = ? AND TRIGGER_GROUP IN ( IN_SPLIT_SIGN ) ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC";
    String SELECT_NEXT_TRIGGER_TO_ACQUIRE = "SELECT TRIGGER_NAME, TRIGGER_GROUP, NEXT_FIRE_TIME, PRIORITY FROM {0}TRIGGERS WHERE SCHED_NAME = {1} AND TRIGGER_STATE = ? AND NEXT_FIRE_TIME <= ? AND (MISFIRE_INSTR = -1 OR (MISFIRE_INSTR != -1 AND NEXT_FIRE_TIME >= ?))  AND TRIGGER_GROUP IN ( IN_SPLIT_SIGN ) ORDER BY NEXT_FIRE_TIME ASC, PRIORITY DESC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMisfiredTriggersInState(Connection conn, String state1, long ts, int count, List<TriggerKey> resultList) throws SQLException {
        boolean bl;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = this.rtp(this.SELECT_HAS_MISFIRED_TRIGGERS_IN_STATE);
            sql = this.getReplaceSql(sql);
            ps = conn.prepareStatement(sql);
            ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
            ps.setString(2, state1);
            rs = ps.executeQuery();
            boolean hasReachedLimit = false;
            while (rs.next() && !hasReachedLimit) {
                if (resultList.size() == count) {
                    hasReachedLimit = true;
                    continue;
                }
                String triggerName = rs.getString("TRIGGER_NAME");
                String groupName = rs.getString("TRIGGER_GROUP");
                resultList.add(TriggerKey.triggerKey((String)triggerName, (String)groupName));
            }
            bl = hasReachedLimit;
        }
        catch (Throwable throwable) {
            GroupJDBCDelegate.closeResultSet(rs);
            GroupJDBCDelegate.closeStatement(ps);
            throw throwable;
        }
        GroupJDBCDelegate.closeResultSet((ResultSet)rs);
        GroupJDBCDelegate.closeStatement((Statement)ps);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TriggerKey> selectTriggerToAcquire(Connection conn, long noLaterThan, long noEarlierThan, int maxCountParam) throws SQLException {
        LinkedList<TriggerKey> linkedList;
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<TriggerKey> nextTriggers = new LinkedList<TriggerKey>();
        try {
            String sql = this.rtp(this.SELECT_NEXT_TRIGGER_TO_ACQUIRE);
            sql = this.getReplaceSql(sql);
            ps = conn.prepareStatement(sql);
            int maxCount = maxCountParam;
            if (maxCount < 1) {
                maxCount = 1;
            }
            ps.setMaxRows(maxCount);
            ps.setFetchSize(maxCount);
            ps.setString(1, "WAITING");
            ps.setBigDecimal(2, new BigDecimal(String.valueOf(noLaterThan)));
            ps.setBigDecimal(3, new BigDecimal(String.valueOf(noEarlierThan)));
            rs = ps.executeQuery();
            while (rs.next() && nextTriggers.size() < maxCount) {
                nextTriggers.add(TriggerKey.triggerKey((String)rs.getString("TRIGGER_NAME"), (String)rs.getString("TRIGGER_GROUP")));
            }
            linkedList = nextTriggers;
        }
        catch (Throwable throwable) {
            GroupJDBCDelegate.closeResultSet(rs);
            GroupJDBCDelegate.closeStatement(ps);
            throw throwable;
        }
        GroupJDBCDelegate.closeResultSet((ResultSet)rs);
        GroupJDBCDelegate.closeStatement((Statement)ps);
        return linkedList;
    }

    private String getReplaceSql(String sql) {
        if (this.triggerGroup.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String group : this.triggerGroup) {
                sb.append("'");
                sb.append(group);
                sb.append("',");
            }
            String triggerGroup = sb.toString();
            triggerGroup = triggerGroup.substring(0, triggerGroup.length() - 1);
            return sql.replace(IN_SPLIT_SIGN, triggerGroup);
        }
        return sql.replace(IN_SPLIT_SIGN, "");
    }
}

