/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.quartz.service.impl;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.quartz.dao.JobTriggerMapper;
import com.jxdinfo.hussar.quartz.model.JobExtend;
import com.jxdinfo.hussar.quartz.model.JobTrigger;
import com.jxdinfo.hussar.quartz.service.IJobExtendService;
import com.jxdinfo.hussar.quartz.service.IJobTriggerService;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
@Master
public class JobTriggerServiceImpl
extends ServiceImpl<JobTriggerMapper, JobTrigger>
implements IJobTriggerService {
    @Resource
    private JobTriggerMapper jobTriggerMapper;
    @Resource
    private IJobExtendService jobExtendService;
    private DynamicRoutingDataSource dynamicRoutingDataSource = (DynamicRoutingDataSource)SpringContextHolder.getBean(DynamicRoutingDataSource.class);
    private static Logger log = LogManager.getLogger(JobTriggerServiceImpl.class);

    @Override
    public Page<Map<String, Object>> getJobTriggerDetails(Page page, JobTrigger jobTrigger) {
        page.setRecords(this.jobTriggerMapper.getJobTriggerDetails(page, jobTrigger));
        return page;
    }

    @Override
    public void addJobExtend(Map<String, String> map) {
        String jobName = map.get("jobName");
        String jobGroup = map.get("jobGroup");
        String misfirePolicy = map.get("misfirePolicy");
        System.out.println("\u5f53\u524d\u6570\u636e\u6e90\u4e3a\uff1a" + this.dynamicRoutingDataSource.determineDataSource());
        log.info("\u5f53\u524d\u6570\u636e\u6e90\u4e3a\uff1a" + this.dynamicRoutingDataSource.determineDataSource());
        JobExtend jobExtend = this.getJobExtend(jobName, jobGroup, misfirePolicy);
        this.jobExtendService.save((Object)jobExtend);
    }

    @Override
    public void updateJobExtend(Map<String, Object> map) {
        String jobName = map.get("jobName") == null ? null : map.get("jobName").toString();
        String jobGroup = map.get("jobGroup") == null ? null : map.get("jobGroup").toString();
        String misfirePolicy = map.get("misfirePolicy") == null ? null : map.get("misfirePolicy").toString();
        JobExtend jobExtend = (JobExtend)((Object)this.jobExtendService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"job_name", (Object)jobName)).eq((Object)"job_group", (Object)jobGroup)));
        if (ToolUtil.isNotEmpty((Object)((Object)jobExtend))) {
            jobExtend.setMisfirePolicy(misfirePolicy);
            this.jobExtendService.update((Object)jobExtend, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"job_name", (Object)jobName)).eq((Object)"job_group", (Object)jobGroup));
        } else {
            jobExtend = this.getJobExtend(jobName, jobGroup, misfirePolicy);
            this.jobExtendService.save((Object)jobExtend);
        }
    }

    @Override
    public void deleteJobExtend(String jobName, String jobGroup) {
        this.jobExtendService.remove((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"job_name", (Object)jobName)).eq((Object)"job_group", (Object)jobGroup));
    }

    private JobExtend getJobExtend(String jobName, String jobGroup, String misfirePolicy) {
        JobExtend jobExtend = new JobExtend();
        jobExtend.setJobName(jobName);
        jobExtend.setJobGroup(jobGroup);
        jobExtend.setMisfirePolicy(misfirePolicy);
        return jobExtend;
    }
}

