/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.quartz;

import com.jxdinfo.hussar.quartz.JobLogListener;
import com.jxdinfo.hussar.quartz.service.IJobLogService;
import com.jxdinfo.hussar.quartz.service.impl.JobLogServiceImpl;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.ee.servlet.QuartzInitializerListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@ConfigurationProperties(prefix="org")
public class SchedulerConfig {
    public static final String QUARTZCONF_PREFIX = "org";
    private Map<String, String> quartz;
    @Autowired
    private DataSource dataSource;

    public Map<String, String> getQuartz() {
        return this.quartz;
    }

    public void setQuartz(Map<String, String> quartz) {
        this.quartz = quartz;
    }

    @Bean(name={"SchedulerFactory"})
    public SchedulerFactoryBean schedulerFactoryBean() throws IOException {
        SchedulerFactoryBean factory = new SchedulerFactoryBean();
        factory.setQuartzProperties(this.quartzProperties());
        factory.setDataSource(this.dataSource);
        return factory;
    }

    public Properties quartzProperties() throws IOException {
        Properties properties = new Properties();
        Set<Map.Entry<String, String>> entrys = this.quartz.entrySet();
        for (Map.Entry<String, String> entry : entrys) {
            properties.setProperty("org.quartz." + entry.getKey(), entry.getValue());
        }
        return properties;
    }

    @Bean
    public QuartzInitializerListener executorListener() {
        return new QuartzInitializerListener();
    }

    @Bean(name={"Scheduler"})
    public Scheduler scheduler() throws Exception {
        Scheduler scheduler = this.schedulerFactoryBean().getScheduler();
        scheduler.getListenerManager().addJobListener((JobListener)new JobLogListener());
        return scheduler;
    }

    @Bean(name={"IJobLogService"})
    public IJobLogService generateDemo() {
        return new JobLogServiceImpl();
    }
}

