/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.quartz;

import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.quartz.model.JobLog;
import com.jxdinfo.hussar.quartz.service.IJobLogService;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class JobLogListener
implements JobListener {
    private static Logger logger = LogManager.getLogger(JobLogListener.class);
    IJobLogService iJobLogService = (IJobLogService)SpringContextHolder.getBean(IJobLogService.class);
    String startTime;

    public String getName() {
        return "allJobListener";
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        this.startTime = DateUtil.getTime();
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        logger.info("\u88ab\u5426\u51b3\u6267\u884c\u4e86\uff0c\u53ef\u4ee5\u505a\u4e9b\u65e5\u5fd7\u8bb0\u5f55");
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        String info = "";
        int result = 0;
        JobLog jobLog = new JobLog();
        jobLog.setId(UUID.randomUUID().toString().replace("-", ""));
        jobLog.setJobName(context.getJobDetail().getKey().getName());
        jobLog.setJobGroup(context.getJobDetail().getKey().getGroup());
        if (jobException == null) {
            info = "\u6267\u884c\u6210\u529f\u3002";
            result = 1;
        } else {
            info = jobException.getMessage();
        }
        jobLog.setJobLogInfo(info);
        jobLog.setJobResult(result);
        jobLog.setJobStartTime(this.startTime);
        jobLog.setJob_end_time(DateUtil.getTime());
        this.iJobLogService.addJobLog(jobLog);
    }
}

