/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.quartz.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.hussar.constant.BizExceptionEnum;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.quartz.job.BaseJob;
import com.jxdinfo.hussar.quartz.model.JobTrigger;
import com.jxdinfo.hussar.quartz.service.IJobTriggerService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerUtils;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/job"})
public class JobTriggerController
extends BaseController {
    @Resource
    private IJobTriggerService iJobTriggerService;
    @Resource
    @Qualifier(value="Scheduler")
    private Scheduler scheduler;
    private static Logger log = LogManager.getLogger(JobTriggerController.class);

    @RequiresPermissions(value={"job:jobManager"})
    @RequestMapping(value={""})
    public String show() {
        return "/common/quartz/jobManager.html";
    }

    @RequiresPermissions(value={"job:addpage"})
    @RequestMapping(value={"/addhtml"})
    public String showAdd() {
        return "/common/quartz/job_add.html";
    }

    @RequiresPermissions(value={"job:cron"})
    @RequestMapping(value={"/cron"})
    public String showCron() {
        return "/common/quartz/jobCron.html";
    }

    @RequiresPermissions(value={"job:add"})
    @PostMapping(value={"/add"})
    @ResponseBody
    public Object add(@RequestParam(value="jobName") String jobName, @RequestParam(value="jobClassName") String jobClassName, @RequestParam(value="jobGroup") String jobGroup, @RequestParam(value="cronExpression") String cronExpression, @RequestParam(value="jobDescription") String jobDescription) {
        try {
            this.scheduler.start();
            JobDetail jobDetail = JobBuilder.newJob(JobTriggerController.getClass(jobClassName).getClass()).withIdentity(jobName, jobGroup).withDescription(jobDescription).build();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).withDescription(jobDescription).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            log.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            e.printStackTrace();
            return new ErrorTip(BizExceptionEnum.ADD_QUARTZ.getCode().intValue(), BizExceptionEnum.ADD_QUARTZ.getMessage() + "\uff0c" + this.schedulerExceptionMessageResolver(e));
        }
        catch (HussarException e) {
            log.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            e.printStackTrace();
            return new ErrorTip(BizExceptionEnum.ADD_QUARTZ.getCode().intValue(), BizExceptionEnum.ADD_QUARTZ.getMessage() + "\uff0c" + e.getMessage());
        }
        return SUCCESS_TIP;
    }

    private String schedulerExceptionMessageResolver(SchedulerException e) {
        if (e instanceof JobExecutionException) {
            return "\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25";
        }
        if (e instanceof JobPersistenceException) {
            if (e instanceof ObjectAlreadyExistsException) {
                return "\u5df2\u5b58\u5728\u4efb\u52a1\u7ec4\u548c\u4efb\u52a1\u540d\u76f8\u540c\u7684\u4efb\u52a1";
            }
            return "\u6570\u636e\u5e93\u5f02\u5e38";
        }
        if (e instanceof SchedulerConfigException) {
            return "\u5b9a\u65f6\u4efb\u52a1\u914d\u7f6e\u5f02\u5e38";
        }
        if (e instanceof UnableToInterruptJobException) {
            return "\u8be5\u5b9a\u65f6\u4efb\u52a1\u4e0d\u53ef\u88ab\u6253\u65ad";
        }
        return "\u672a\u77e5\u9519\u8bef";
    }

    @RequiresPermissions(value={"job:pause"})
    @PostMapping(value={"/pause"})
    @ResponseBody
    public Object pause(@RequestParam(value="jobName") String jobName, @RequestParam(value="jobGroup") String jobGroup) throws HussarException {
        try {
            this.scheduler.pauseJob(JobKey.jobKey((String)jobName, (String)jobGroup));
        }
        catch (SchedulerException e) {
            log.error("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            return new ErrorTip(BizExceptionEnum.PAUSE_QUARTZ.getCode().intValue(), BizExceptionEnum.PAUSE_QUARTZ.getMessage() + "\uff0c" + this.schedulerExceptionMessageResolver(e));
        }
        return SUCCESS_TIP;
    }

    @RequiresPermissions(value={"job:resume"})
    @PostMapping(value={"/resume"})
    @ResponseBody
    public Object resume(@RequestParam(value="jobName") String jobName, @RequestParam(value="jobGroup") String jobGroup) throws HussarException {
        try {
            this.scheduler.resumeJob(JobKey.jobKey((String)jobName, (String)jobGroup));
        }
        catch (SchedulerException e) {
            log.error("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            return new ErrorTip(BizExceptionEnum.RESUME_QUARTZ.getCode().intValue(), BizExceptionEnum.RESUME_QUARTZ.getMessage() + "\uff0c" + this.schedulerExceptionMessageResolver(e));
        }
        return SUCCESS_TIP;
    }

    @RequiresPermissions(value={"job:reschedule"})
    @PostMapping(value={"/reschedule"})
    @ResponseBody
    public Object reschedule(@RequestParam(value="jobName") String jobName, @RequestParam(value="jobGroup") String jobGroup, @RequestParam(value="cronExpression") String cronExpression) throws HussarException {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionDoNothing();
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            this.scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            log.error("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            e.printStackTrace();
            return new ErrorTip(BizExceptionEnum.READD_QUARTZ.getCode().intValue(), BizExceptionEnum.READD_QUARTZ.getMessage() + "\uff0c" + this.schedulerExceptionMessageResolver(e));
        }
        return SUCCESS_TIP;
    }

    @RequiresPermissions(value={"job:delete"})
    @PostMapping(value={"/delete"})
    @ResponseBody
    public Object delete(@RequestParam(value="jobName") String jobName, @RequestParam(value="jobGroup") String jobGroup) throws HussarException {
        try {
            this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)jobName, (String)jobGroup));
            this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)jobName, (String)jobGroup));
            this.scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)jobGroup));
        }
        catch (SchedulerException e) {
            log.error("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            return new ErrorTip(BizExceptionEnum.DELETE_QUARTZ.getCode().intValue(), BizExceptionEnum.DELETE_QUARTZ.getMessage() + "\uff0c" + this.schedulerExceptionMessageResolver(e));
        }
        return SUCCESS_TIP;
    }

    @RequiresPermissions(value={"job:query"})
    @GetMapping(value={"/query"})
    @ResponseBody
    public Map<String, Object> query(HttpServletRequest request, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="limit", defaultValue="20") int limit) {
        JobTrigger jobTrigger = new JobTrigger();
        jobTrigger.setJob_name(request.getParameter("job_name") == null ? "" : request.getParameter("job_name"));
        jobTrigger.setJob_group(request.getParameter("job_group") == null ? "" : request.getParameter("job_group"));
        Page<Map<String, Object>> jobTriggerPage = new Page<Map<String, Object>>(page, limit);
        jobTriggerPage = this.iJobTriggerService.getJobTriggerDetails((Page)jobTriggerPage, jobTrigger);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("data", jobTriggerPage.getRecords());
        map.put("count", jobTriggerPage.getTotal());
        map.put("code", 0);
        map.put("message", "");
        return map;
    }

    public static BaseJob getClass(String classname) throws HussarException {
        try {
            Class<?> class1 = Class.forName(classname);
            return (BaseJob)class1.newInstance();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u53cd\u5c04\u7c7b\u5931\u8d25");
            HussarException he = new HussarException((ServiceExceptionEnum)BizExceptionEnum.GETCLASS_QUARTZ);
            he.setMessage("\u5b9a\u65f6\u4efb\u52a1\u7c7b\u672a\u627e\u5230\uff01");
            throw he;
        }
    }

    @RequestMapping(value={"/checkCron"}, method={RequestMethod.POST})
    @ResponseBody
    public Object fileCheck(@RequestParam(value="cron") String cron) throws HussarException {
        CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
        ArrayList<String> result = new ArrayList<String>();
        try {
            String decodeCron = URLDecoder.decode(cron, "UTF-8");
            cronTriggerImpl.setCronExpression(decodeCron);
        }
        catch (ParseException e) {
            log.error("\u5b9a\u65f6\u5668\u8868\u8fbe\u5f0f\u6709\u8bef");
            return "\u5b9a\u65f6\u5668\u8868\u8fbe\u5f0f\u6709\u8bef";
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            log.error("\u5b9a\u65f6\u5668URL\u89e3\u7801\u9519\u8bef");
            return "\u5b9a\u65f6\u5668URL\u89e3\u7801\u9519\u8bef";
        }
        List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)3);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < dates.size() && i <= 2; ++i) {
            result.add(dateFormat.format((Date)dates.get(i)));
        }
        return result;
    }
}

