/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.post.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authentication.dto.LoginUserExtendInfoDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginUserExtendInfoService;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationPostService;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.dto.SysPostOut;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.model.SysRolePost;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostConcurrently;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostMain;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.authorization.post.service.ISysRolePostService;
import com.jxdinfo.hussar.authorization.post.service.UserPostConcurrentlyService;
import com.jxdinfo.hussar.authorization.post.service.UserPostMainService;
import com.jxdinfo.hussar.authorization.post.vo.SysUserPostInfoVo;
import com.jxdinfo.hussar.authorization.post.vo.SysUserPostMainVo;
import com.jxdinfo.hussar.authorization.post.vo.SysUserPostVo;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.base.config.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.Convert;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.general.theme.service.IThemeService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.post.post.dao.SysPostMapper;
import com.jxdinfo.hussar.post.post.dao.UserPostMainMapper;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ISysPostServiceImpl
extends HussarServiceImpl<SysPostMapper, SysPost>
implements ISysPostService {
    @Resource
    private ISysRolePostService sysRolePostService;
    @Resource
    private ISysStruService sysStruService;
    private SysOrganVo organ;
    private String organName;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private UserPostConcurrentlyService userPostConcurrentlyService;
    @Resource
    private UserPostMainService userPostMainService;
    @Autowired
    private ISysApplicationPostService sysApplicationPostService;
    @Resource
    private ISysStruService iSysStruService;
    @Autowired
    private ISysPostService sysPostService;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private UserPostMainMapper userPostMainMapper;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private HussarLoginUserExtendInfoService hussarLoginUserExtendInfoService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysStruRoleService iSysStruRoleService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysWelcomeService sysWelcomeService;
    private static final Logger logger = LoggerFactory.getLogger(ISysPostServiceImpl.class);

    public IPage<SysPost> getPostList(SysPost sysPost, Page<SysPost> page) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(HussarUtils.isNotBlank((CharSequence)sysPost.getDisplayFlag()), SysPost::getDisplayFlag, (Object)sysPost.getDisplayFlag())).eq(HussarUtils.isNotBlank((CharSequence)sysPost.getPostStatus()), SysPost::getPostStatus, (Object)sysPost.getPostStatus());
        if (HussarUtils.isNotBlank((CharSequence)sysPost.getPostNo())) {
            qw.like(SysPost::getPostNo, (Object)sysPost.getPostNo());
        }
        if (HussarUtils.isNotBlank((CharSequence)sysPost.getPostName())) {
            qw.like(SysPost::getPostName, (Object)sysPost.getPostName());
        }
        if (HussarUtils.isNotBlank((CharSequence)sysPost.getPostType())) {
            qw.eq(SysPost::getPostType, (Object)sysPost.getPostType());
        }
        if (sysPost.getPostParentNo() != null) {
            qw.eq(SysPost::getPostParentNo, (Object)sysPost.getPostParentNo());
        }
        return this.page((IPage)page, (Wrapper)qw);
    }

    public String addPost(SysPost sysPost) {
        if (sysPost == null) {
            return "\u4fdd\u5b58\u5931\u8d25";
        }
        boolean bl = this.save((BaseEntity)sysPost);
        if (bl) {
            return "\u4fdd\u5b58\u6210\u529f";
        }
        return "\u4fdd\u5b58\u5931\u8d25";
    }

    public String editPost(SysPost sysPost) {
        if (sysPost == null || sysPost.getPostId() == null) {
            return "\u4fee\u6539\u5931\u8d25";
        }
        boolean bl = this.updateById((BaseEntity)sysPost);
        if (bl) {
            return "\u4fee\u6539\u6210\u529f";
        }
        return "\u4fee\u6539\u5931\u8d25";
    }

    public String delPost(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return "\u5220\u9664\u5931\u8d25\uff0c\u672a\u627e\u5230\u5220\u9664\u6570\u636e";
        }
        List<String> result = Arrays.asList(ids.split(","));
        for (String id : result) {
            List childList = this.list((Wrapper)new LambdaQueryWrapper().eq(SysPost::getPostParentNo, (Object)id));
            if (HussarUtils.isNotEmpty((Object)childList)) {
                SysPost post = (SysPost)this.getById((Serializable)((Object)id));
                return "\u5c97\u4f4d" + post.getPostName() + "\u4e0b\u6709\u5176\u4ed6\u5c97\u4f4d\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664";
            }
            List mainList = this.userPostMainService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserPostMain::getUpPostId, (Object)id));
            if (HussarUtils.isNotEmpty((Object)mainList)) {
                SysPost post = (SysPost)this.getById((Serializable)((Object)id));
                return "\u5c97\u4f4d" + post.getPostName() + "\u6b63\u5728\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664";
            }
            List concurrentlyList = this.userPostConcurrentlyService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserPostConcurrently::getUpPostId, (Object)id));
            if (!HussarUtils.isNotEmpty((Object)concurrentlyList)) continue;
            SysPost post = (SysPost)this.getById((Serializable)((Object)id));
            return "\u5c97\u4f4d" + post.getPostName() + "\u6b63\u5728\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664";
        }
        boolean bl = this.removeByIds(result);
        if (bl) {
            return "\u5220\u9664\u6210\u529f";
        }
        return "\u5220\u9664\u5931\u8d25";
    }

    public List<JSTreeModel> getPostTree(SysPost sysPost) {
        List listTree = TreeModelUtils.merge(((SysPostMapper)this.baseMapper).getPostTree(sysPost));
        JSTreeModel root = new JSTreeModel();
        root.setId(Long.valueOf(-1L));
        root.setCode(null);
        root.setText("\u5c97\u4f4d");
        root.setParent(null);
        root.setType("-1");
        root.setImgUrl("tree-com");
        root.setChildrenList(listTree);
        ArrayList<JSTreeModel> resultTree = new ArrayList<JSTreeModel>();
        resultTree.add(root);
        return resultTree;
    }

    public List<SysPost> getPostTreeByNode(SysPost sysPost) {
        List<SysPost> list = ((SysPostMapper)this.baseMapper).getPostTreeByNode();
        List<SysPost> resultList = this.buildTree(list, sysPost.getPostType());
        SysPost root = new SysPost();
        root.setPostId(Long.valueOf(-1L));
        root.setPostNo(null);
        root.setPostName("\u5c97\u4f4d");
        root.setPostParentNo(null);
        root.setImgUrl("tree-com");
        root.setChildrenList(resultList);
        ArrayList<SysPost> resultTree = new ArrayList<SysPost>();
        resultTree.add(root);
        return resultTree;
    }

    public List<SysPost> buildTree(List<SysPost> all, String postType) {
        if (CollectionUtils.isEmpty(all)) {
            return Lists.newArrayList();
        }
        List<SysPost> parentList = all.stream().filter(e -> e.getPostType().equals(postType) && "-1".equals(e.getPostParentNo())).collect(Collectors.toList());
        this.getSubList(parentList, all);
        return parentList;
    }

    private void getSubList(List<SysPost> parentList, List<SysPost> all) {
        parentList.forEach(e -> {
            List<SysPost> subList = all.stream().filter(o -> o.getPostParentNo().equals(String.valueOf(e.getPostId()))).collect(Collectors.toList());
            e.setChildrenList(subList);
            if (!CollectionUtils.isEmpty(subList)) {
                this.getSubList(subList, all);
            }
        });
    }

    public List<JSTreeModel> getPostTreeByNodeIsChoose(SysPost sysPost) {
        List listTree = TreeModelUtils.merge(((SysPostMapper)this.baseMapper).getPostTreeInStru(sysPost.getOpStruId()));
        JSTreeModel root = new JSTreeModel();
        root.setId(Long.valueOf(-1L));
        root.setCode(null);
        root.setText("\u5c97\u4f4d");
        root.setParent(null);
        root.setType("-1");
        root.setImgUrl("tree-com");
        root.setChildrenList(listTree);
        ArrayList<JSTreeModel> resultTree = new ArrayList<JSTreeModel>();
        resultTree.add(root);
        return resultTree;
    }

    @HussarTransactional
    public String addPostAll(SysPost sysPost) {
        try {
            if (sysPost == null) {
                return "\u4fdd\u5b58\u5931\u8d25";
            }
            List rolePostList = sysPost.getRolePostList();
            this.sysPostService.saveOrUpdate((Object)sysPost);
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            qw.like(SysRolePost::getRpPostId, (Object)sysPost.getPostId());
            this.sysRolePostService.remove((Wrapper)qw);
            for (SysRolePost sysRolePost : rolePostList) {
                sysRolePost.setRpPostId(sysPost.getPostId());
                sysRolePost.setOutPostId(sysPost.getOutPostId());
                sysRolePost.setOutOriginId(sysPost.getOutOriginId());
            }
            this.sysRolePostService.saveOrUpdateBatch((Collection)rolePostList);
            return "\u4fdd\u5b58\u6210\u529f";
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5b58\u5c97\u4f4d\u4fe1\u606f\u51fa\u9519\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
            return "\u4fdd\u5b58\u5c97\u4f4d\u4fe1\u606f\u51fa\u9519";
        }
    }

    public List<Long> getRoleIdByUserId(Long userId) {
        List<Long> list = ((SysPostMapper)this.baseMapper).getRoleIdByUserId(userId);
        list = list.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return list;
    }

    public List<Long> getRoleIdByPostAndStru(Long postId, Long struId) {
        List<Long> list = new ArrayList<Long>();
        list = this.getStruUp(list, struId);
        list.add(struId);
        return ((SysPostMapper)this.baseMapper).getRoleIdByPostAndStru(postId, list);
    }

    public List<Long> getStruUp(List<Long> list, Long struId) {
        Long parentId = ((SysPostMapper)this.baseMapper).getStruUp(struId);
        if (HussarUtils.isNotEmpty((Object)parentId) && parentId != 11L) {
            list.add(parentId);
            this.getStruUp(list, parentId);
        }
        return list;
    }

    public SecurityUser changePost(Long postId, Long deptId) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        UserDetails loginUserDetails = HussarSecurityUtils.getLoginUserDetails();
        if (HussarUtils.isEmpty((Object)loginUserDetails)) {
            return null;
        }
        SecurityUser securityUser = (SecurityUser)HussarCacheUtil.get((String)"login_user_info", (Object)loginUserDetails.getAccessToken());
        if (postId.compareTo(Convert.toLong((Object)shiroUser.getExtendUserMap("postMainId"))) == 0) {
            SysOrganVo sysOrganVo;
            LambdaQueryWrapper sysUserPostMainQueryWrapper = new LambdaQueryWrapper();
            sysUserPostMainQueryWrapper.eq(SysUserPostMain::getUpId, (Object)postId);
            SysUserPostMain sysUserPostMain = (SysUserPostMain)this.userPostMainService.getOne((Wrapper)sysUserPostMainQueryWrapper);
            if (HussarUtils.isNotEmpty((Object)sysUserPostMain)) {
                HussarSecurityUtils.putSessionExtend((String)"postCurrent", (Object)sysUserPostMain.getUpPostId());
                HussarSecurityUtils.putSessionExtend((String)"postCurrentId", (Object)sysUserPostMain.getUpId());
                HussarSecurityUtils.putSessionExtend((String)"deptId", (Object)deptId);
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("postCurrent", (Object)sysUserPostMain.getUpPostId());
                    securityUser.addExtendUserMap("postCurrentId", (Object)sysUserPostMain.getUpId());
                    securityUser.addExtendUserMap("deptId", (Object)deptId);
                    SysOrgan sysOrgan = this.iSysStruService.getOrganInfoByDeparmentId(deptId);
                    securityUser.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                    this.buildExtendUserMap(securityUser);
                }
            }
            if (!HussarUtils.isNull((Object)(sysOrganVo = this.sysStruService.getOrgInfoByOrgId(deptId)))) {
                HussarSecurityUtils.putSessionExtend((String)"deptName", (Object)sysOrganVo.getOrganName());
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                }
            }
            if (HussarUtils.isNotEmpty((Object)securityUser)) {
                HussarCacheUtil.put((String)"login_user_info", (Object)loginUserDetails.getAccessToken(), (Object)securityUser, (long)1800L);
            }
        } else {
            SysOrganVo sysOrganVo;
            LambdaQueryWrapper sysUserPostConcurrentlyQueryWrapper = new LambdaQueryWrapper();
            sysUserPostConcurrentlyQueryWrapper.eq(SysUserPostConcurrently::getUpId, (Object)postId);
            SysUserPostConcurrently sysUserPostConcurrently = (SysUserPostConcurrently)this.userPostConcurrentlyService.getOne((Wrapper)sysUserPostConcurrentlyQueryWrapper);
            if (HussarUtils.isNotEmpty((Object)sysUserPostConcurrently)) {
                HussarSecurityUtils.putSessionExtend((String)"postCurrent", (Object)sysUserPostConcurrently.getUpPostId());
                HussarSecurityUtils.putSessionExtend((String)"postCurrentId", (Object)sysUserPostConcurrently.getUpId());
                HussarSecurityUtils.putSessionExtend((String)"deptId", (Object)deptId);
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("postCurrent", (Object)sysUserPostConcurrently.getUpPostId());
                    securityUser.addExtendUserMap("postCurrentId", (Object)sysUserPostConcurrently.getUpId());
                    securityUser.addExtendUserMap("deptId", (Object)deptId);
                    SysOrgan sysOrgan = this.iSysStruService.getOrganInfoByDeparmentId(deptId);
                    securityUser.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                    this.buildExtendUserMap(securityUser);
                }
            }
            if (!HussarUtils.isNull((Object)(sysOrganVo = this.sysStruService.getOrgInfoByOrgId(deptId)))) {
                HussarSecurityUtils.putSessionExtend((String)"deptName", (Object)sysOrganVo.getOrganName());
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                }
            }
            if (HussarUtils.isNotEmpty((Object)securityUser)) {
                HussarCacheUtil.put((String)"login_user_info", (Object)loginUserDetails.getAccessToken(), (Object)securityUser, (long)1800L);
            }
        }
        return securityUser;
    }

    public SecurityUser changePost(Long postId, Long deptId, UserDetails loginUserDetails, SysUserPostMain sysUserPostMain) {
        if (HussarUtils.isEmpty((Object)loginUserDetails)) {
            return null;
        }
        SecurityUser securityUser = (SecurityUser)HussarCacheUtil.get((String)"login_user_info", (Object)loginUserDetails.getAccessToken());
        SysOrgan sysOrgan = this.iSysStruService.getOrganInfoByDeparmentId(deptId);
        SysOrganVo sysOrganVo = this.sysStruService.getOrgInfoByOrgId(deptId);
        if (securityUser == null) {
            if (postId.compareTo(Convert.toLong((Object)loginUserDetails.getExtendUserMap("postMainId"))) == 0) {
                if (HussarUtils.isNotEmpty((Object)sysUserPostMain)) {
                    loginUserDetails.addExtendUserMap("postCurrent", (Object)sysUserPostMain.getUpPostId());
                    loginUserDetails.addExtendUserMap("postCurrentId", (Object)sysUserPostMain.getUpId());
                    loginUserDetails.addExtendUserMap("deptId", (Object)deptId);
                    if (HussarUtils.isNotEmpty((Object)loginUserDetails)) {
                        loginUserDetails.addExtendUserMap("postCurrent", (Object)sysUserPostMain.getUpPostId());
                        loginUserDetails.addExtendUserMap("postCurrentId", (Object)sysUserPostMain.getUpId());
                        loginUserDetails.addExtendUserMap("deptId", (Object)deptId);
                        loginUserDetails.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                        this.buildExtendUserMap(loginUserDetails);
                    }
                }
                if (!HussarUtils.isNull((Object)sysOrganVo)) {
                    loginUserDetails.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                    if (HussarUtils.isNotEmpty((Object)loginUserDetails)) {
                        loginUserDetails.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                    }
                }
                return securityUser;
            }
            LambdaQueryWrapper sysUserPostConcurrentlyQueryWrapper = new LambdaQueryWrapper();
            sysUserPostConcurrentlyQueryWrapper.eq(SysUserPostConcurrently::getUpId, (Object)postId);
            SysUserPostConcurrently sysUserPostConcurrently = (SysUserPostConcurrently)this.userPostConcurrentlyService.getOne((Wrapper)sysUserPostConcurrentlyQueryWrapper);
            if (HussarUtils.isNotEmpty((Object)sysUserPostConcurrently)) {
                loginUserDetails.addExtendUserMap("postCurrent", (Object)sysUserPostConcurrently.getUpPostId());
                loginUserDetails.addExtendUserMap("postCurrentId", (Object)sysUserPostConcurrently.getUpId());
                loginUserDetails.addExtendUserMap("deptId", (Object)deptId);
                if (HussarUtils.isNotEmpty((Object)loginUserDetails)) {
                    loginUserDetails.addExtendUserMap("postCurrent", (Object)sysUserPostConcurrently.getUpPostId());
                    loginUserDetails.addExtendUserMap("postCurrentId", (Object)sysUserPostConcurrently.getUpId());
                    loginUserDetails.addExtendUserMap("deptId", (Object)deptId);
                    loginUserDetails.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                    this.buildExtendUserMap(loginUserDetails);
                }
            }
            if (!HussarUtils.isNull((Object)sysOrganVo)) {
                loginUserDetails.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                if (HussarUtils.isNotEmpty((Object)loginUserDetails)) {
                    loginUserDetails.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                }
            }
            return securityUser;
        }
        if (postId.compareTo(Convert.toLong((Object)securityUser.getExtendUserMap("postMainId"))) == 0) {
            if (HussarUtils.isNotEmpty((Object)sysUserPostMain)) {
                HussarSecurityUtils.putSessionExtend((String)"postCurrent", (Object)sysUserPostMain.getUpPostId());
                HussarSecurityUtils.putSessionExtend((String)"postCurrentId", (Object)sysUserPostMain.getUpId());
                HussarSecurityUtils.putSessionExtend((String)"deptId", (Object)deptId);
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("postCurrent", (Object)sysUserPostMain.getUpPostId());
                    securityUser.addExtendUserMap("postCurrentId", (Object)sysUserPostMain.getUpId());
                    securityUser.addExtendUserMap("deptId", (Object)deptId);
                    securityUser.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                    this.buildExtendUserMap(securityUser);
                }
            }
            if (!HussarUtils.isNull((Object)sysOrganVo)) {
                HussarSecurityUtils.putSessionExtend((String)"deptName", (Object)sysOrganVo.getOrganName());
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                }
            }
            if (HussarUtils.isNotEmpty((Object)securityUser)) {
                HussarCacheUtil.put((String)"login_user_info", (Object)loginUserDetails.getAccessToken(), (Object)securityUser, (long)1800L);
            }
        } else {
            LambdaQueryWrapper sysUserPostConcurrentlyQueryWrapper = new LambdaQueryWrapper();
            sysUserPostConcurrentlyQueryWrapper.eq(SysUserPostConcurrently::getUpId, (Object)postId);
            SysUserPostConcurrently sysUserPostConcurrently = (SysUserPostConcurrently)this.userPostConcurrentlyService.getOne((Wrapper)sysUserPostConcurrentlyQueryWrapper);
            if (HussarUtils.isNotEmpty((Object)sysUserPostConcurrently)) {
                HussarSecurityUtils.putSessionExtend((String)"postCurrent", (Object)sysUserPostConcurrently.getUpPostId());
                HussarSecurityUtils.putSessionExtend((String)"postCurrentId", (Object)sysUserPostConcurrently.getUpId());
                HussarSecurityUtils.putSessionExtend((String)"deptId", (Object)deptId);
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("postCurrent", (Object)sysUserPostConcurrently.getUpPostId());
                    securityUser.addExtendUserMap("postCurrentId", (Object)sysUserPostConcurrently.getUpId());
                    securityUser.addExtendUserMap("deptId", (Object)deptId);
                    securityUser.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                    this.buildExtendUserMap(securityUser);
                }
            }
            if (!HussarUtils.isNull((Object)sysOrganVo)) {
                HussarSecurityUtils.putSessionExtend((String)"deptName", (Object)sysOrganVo.getOrganName());
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                }
            }
            if (HussarUtils.isNotEmpty((Object)securityUser)) {
                HussarCacheUtil.put((String)"login_user_info", (Object)loginUserDetails.getAccessToken(), (Object)securityUser, (long)1800L);
            }
        }
        return securityUser;
    }

    public UserDetails changePostNew(Long employeeId, Long postId, Long deptId, UserDetails loginUserDetails, SysUserPostMain sysUserPostMain) {
        if (HussarUtils.isEmpty((Object)loginUserDetails)) {
            logger.info("loginUserDetails\u4e3anull");
            return null;
        }
        if (HussarUtils.isEmpty((Object)sysUserPostMain)) {
            return null;
        }
        SysOrgan sysOrgan = new SysOrgan();
        SysOrganVo sysOrganVo = new SysOrganVo();
        try {
            if (postId != null && postId.compareTo(Convert.toLong((Object)loginUserDetails.getExtendUserMap("postMain"))) == 0) {
                logger.info("sysUserPostMain={}", (Object)sysUserPostMain.toString());
                if (HussarUtils.isNotEmpty((Object)sysUserPostMain)) {
                    logger.info("sysUserPostMain\u8fdb\u5165");
                    loginUserDetails.addExtendUserMap("postCurrent", (Object)sysUserPostMain.getUpPostId());
                    loginUserDetails.addExtendUserMap("postCurrentId", (Object)sysUserPostMain.getUpId());
                    loginUserDetails.addExtendUserMap("deptId", (Object)deptId);
                    sysOrgan = this.iSysStruService.getOrganInfoByDeparmentId(deptId);
                    loginUserDetails.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                    loginUserDetails.addExtendUserMap("organName", (Object)sysOrgan.getOrganName());
                    this.buildExtendUserMap(loginUserDetails);
                }
                if (!HussarUtils.isNull((Object)(sysOrganVo = this.sysStruService.getOrgInfoByOrgId(deptId)))) {
                    loginUserDetails.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                }
                return loginUserDetails;
            }
            SysUserPostInfoVo userPostConcurrentlyNew = null;
            if (employeeId != null && postId != null && deptId != null) {
                userPostConcurrentlyNew = this.userPostMainMapper.getUserPostInfo(employeeId, postId, deptId);
                if (HussarUtils.isNotEmpty((Object)userPostConcurrentlyNew)) {
                    loginUserDetails.addExtendUserMap("corporationId", (Object)userPostConcurrentlyNew.getCompanyId());
                    LoginUserExtendInfoDto loginUserExtendInfo = new LoginUserExtendInfoDto();
                    loginUserExtendInfo.setId(String.valueOf(userPostConcurrentlyNew.getUpPostId()));
                    loginUserExtendInfo.setCode(userPostConcurrentlyNew.getPostNo());
                    loginUserExtendInfo.setType(userPostConcurrentlyNew.getPostType());
                    loginUserExtendInfo.setName(userPostConcurrentlyNew.getPostName());
                    loginUserExtendInfo.setMdmId(userPostConcurrentlyNew.getOutPostId());
                    loginUserExtendInfo.setOriginId(userPostConcurrentlyNew.getOutOriginId());
                    loginUserDetails.addExtendUserMap("postInfo", (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)loginUserExtendInfo)));
                    logger.error("userPostConcurrently={}", (Object)userPostConcurrentlyNew);
                    loginUserDetails.addExtendUserMap("postCurrent", (Object)userPostConcurrentlyNew.getUpPostId());
                    loginUserDetails.addExtendUserMap("postCurrentId", (Object)userPostConcurrentlyNew.getUpId());
                    loginUserDetails.addExtendUserMap("deptId", (Object)deptId);
                    Optional.ofNullable(this.sysPostService.getById((Serializable)((Object)String.valueOf(loginUserDetails.getExtendUserMap().get("postCurrent"))))).ifPresent(p -> loginUserDetails.addExtendUserMap("outOriginPostId", (Object)p.getOutPostId()));
                    sysOrgan = this.iSysStruService.getOrganInfoByDeparmentId(deptId);
                    loginUserDetails.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                    loginUserDetails.addExtendUserMap("organName", (Object)sysOrgan.getOrganName());
                    this.buildExtendUserMap(loginUserDetails);
                }
                if (!HussarUtils.isNull((Object)(sysOrganVo = this.sysStruService.getOrgInfoByOrgId(deptId)))) {
                    loginUserDetails.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                }
            }
        }
        catch (Exception e) {
            throw new BaseException("\u672a\u627e\u5230\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb\u4fe1\u606f\uff0c\u5207\u6362\u5c97\u4f4d\u5931\u8d25\u3002");
        }
        return loginUserDetails;
    }

    public SecurityUser changePostBy(Long employeeId, Long postId, Long deptId) {
        SysUserPostMain userPostMain = null;
        Long userPostId = this.getUserPostIdBy(employeeId, postId, deptId, userPostMain);
        if (userPostId != null && this.isNeedChangePost(postId, deptId).booleanValue()) {
            this.changePost(userPostId, deptId);
        } else if (userPostId == null) {
            throw new BaseException("\u672a\u627e\u5230\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb\u4fe1\u606f\uff0c\u5207\u6362\u5c97\u4f4d\u5931\u8d25\u3002");
        }
        return BaseSecurityUtil.getUser();
    }

    public SecurityUser changePostBy(Long employeeId, Long postId, Long deptId, UserDetails loginUserDetails) {
        logger.error("employeeId:{},postId:{},deptId:{}", new Object[]{employeeId, postId, deptId});
        SysUserPostMain userPostMain = null;
        Long userPostId = this.getUserPostIdBy(employeeId, postId, deptId, userPostMain);
        if (userPostId != null && this.isNeedChangePost(postId, deptId, loginUserDetails).booleanValue()) {
            return this.changePost(userPostId, deptId, loginUserDetails, userPostMain);
        }
        if (userPostId == null) {
            throw new BaseException("\u672a\u627e\u5230\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb\u4fe1\u606f\uff0c\u5207\u6362\u5c97\u4f4d\u5931\u8d25\u3002");
        }
        return (SecurityUser)HussarCacheUtil.get((String)"login_user_info", (Object)loginUserDetails.getAccessToken());
    }

    public UserDetails changePostBy(Long employeeId, Long postId, Long deptId, UserDetails loginUserDetails, SysUserPostMain userPostMain) {
        logger.error("employeeId:{},postId:{},deptId:{}", new Object[]{employeeId, postId, deptId});
        return this.changePostNew(employeeId, postId, deptId, loginUserDetails, userPostMain);
    }

    private SecurityUser changePostNew(Long employeeId, Long postId, Long deptId) {
        UserDetails loginUserDetails = HussarSecurityUtils.getLoginUserDetails();
        if (HussarUtils.isEmpty((Object)loginUserDetails)) {
            return null;
        }
        SysUserPostMain userPostMain = null;
        SysUserPostConcurrently userPostConcurrently = null;
        Long userPostId = null;
        boolean isMaster = true;
        if (employeeId != null && postId != null) {
            userPostMain = (SysUserPostMain)this.userPostMainService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPostMain::getUpUserId, (Object)employeeId)).eq(SysUserPostMain::getUpPostId, (Object)postId));
        }
        if (userPostMain != null) {
            logger.error("userPostMain={}", userPostMain);
            userPostId = userPostMain.getUpId();
        } else if (employeeId != null && postId != null && deptId != null && (userPostConcurrently = (SysUserPostConcurrently)this.userPostConcurrentlyService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPostConcurrently::getUpUserId, (Object)employeeId)).eq(SysUserPostConcurrently::getUpPostId, (Object)postId)).eq(SysUserPostConcurrently::getUpStruId, (Object)deptId))) != null) {
            logger.error("userPostConcurrently={}", (Object)userPostConcurrently);
            userPostId = userPostConcurrently.getUpId();
            isMaster = false;
        }
        if (userPostId != null && this.isNeedChangePost(userPostId, deptId).booleanValue()) {
            SecurityUser securityUser = (SecurityUser)HussarCacheUtil.get((String)"login_user_info", (Object)loginUserDetails.getAccessToken());
            if (isMaster) {
                SysOrganVo sysOrganVo;
                if (HussarUtils.isNotEmpty((Object)userPostMain)) {
                    HussarSecurityUtils.putSessionExtend((String)"postCurrent", (Object)userPostMain.getUpPostId());
                    HussarSecurityUtils.putSessionExtend((String)"postCurrentId", (Object)userPostMain.getUpId());
                    HussarSecurityUtils.putSessionExtend((String)"deptId", (Object)deptId);
                    if (HussarUtils.isNotEmpty((Object)securityUser)) {
                        securityUser.addExtendUserMap("postCurrent", (Object)userPostMain.getUpPostId());
                        securityUser.addExtendUserMap("postCurrentId", (Object)userPostMain.getUpId());
                        securityUser.addExtendUserMap("deptId", (Object)deptId);
                        SysOrgan sysOrgan = this.iSysStruService.getOrganInfoByDeparmentId(deptId);
                        securityUser.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                        this.buildExtendUserMap(securityUser);
                    }
                }
                if (!HussarUtils.isNull((Object)(sysOrganVo = this.sysStruService.getOrgInfoByOrgId(deptId)))) {
                    HussarSecurityUtils.putSessionExtend((String)"deptName", (Object)sysOrganVo.getOrganName());
                    if (HussarUtils.isNotEmpty((Object)securityUser)) {
                        securityUser.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                    }
                }
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    HussarCacheUtil.put((String)"login_user_info", (Object)loginUserDetails.getAccessToken(), (Object)securityUser, (long)1800L);
                }
            } else {
                SysOrganVo sysOrganVo;
                if (HussarUtils.isNotEmpty(userPostConcurrently)) {
                    HussarSecurityUtils.putSessionExtend((String)"postCurrent", (Object)userPostConcurrently.getUpPostId());
                    HussarSecurityUtils.putSessionExtend((String)"postCurrentId", (Object)userPostConcurrently.getUpId());
                    HussarSecurityUtils.putSessionExtend((String)"deptId", (Object)deptId);
                    if (HussarUtils.isNotEmpty((Object)securityUser)) {
                        securityUser.addExtendUserMap("postCurrent", (Object)userPostConcurrently.getUpPostId());
                        securityUser.addExtendUserMap("postCurrentId", (Object)userPostConcurrently.getUpId());
                        securityUser.addExtendUserMap("deptId", (Object)deptId);
                        SysOrgan sysOrgan = this.iSysStruService.getOrganInfoByDeparmentId(deptId);
                        securityUser.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                        this.buildExtendUserMap(securityUser);
                    }
                }
                if (!HussarUtils.isNull((Object)(sysOrganVo = this.sysStruService.getOrgInfoByOrgId(deptId)))) {
                    HussarSecurityUtils.putSessionExtend((String)"deptName", (Object)sysOrganVo.getOrganName());
                    if (HussarUtils.isNotEmpty((Object)securityUser)) {
                        securityUser.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                    }
                }
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    HussarCacheUtil.put((String)"login_user_info", (Object)loginUserDetails.getAccessToken(), (Object)securityUser, (long)1800L);
                }
            }
            return securityUser;
        }
        if (userPostId == null) {
            throw new BaseException("\u672a\u627e\u5230\u4eba\u5458\u5c97\u4f4d\u5173\u7cfb\u4fe1\u606f\uff0c\u5207\u6362\u5c97\u4f4d\u5931\u8d25\u3002");
        }
        return null;
    }

    public SecurityUser changePostBy(String deptId, String postId, String originDeptId, String originPostId, String mdmDeptId, String mdmPostId) {
        Long employeeId;
        Long hussarDeptId = null;
        hussarDeptId = HussarUtils.isNotEmpty((Object)deptId) ? Long.valueOf(Long.parseLong(deptId)) : (this.sysStruService.getHussarDeptIdBy(originDeptId, mdmDeptId) != null ? this.sysStruService.getHussarDeptIdBy(originDeptId, mdmDeptId) : null);
        Long hussarPostId = null;
        hussarPostId = HussarUtils.isNotEmpty((Object)postId) ? Long.valueOf(Long.parseLong(postId)) : (this.getHussarPostIdBy(originPostId, mdmPostId) != null ? this.getHussarPostIdBy(originPostId, mdmPostId) : null);
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long l = employeeId = HussarUtils.isNotEmpty((Object)securityUser) ? securityUser.getEmployeeId() : null;
        if (hussarDeptId == null && hussarPostId == null) {
            Long mainDeptId = this.sysStruService.getMainDeptIdBy(employeeId);
            Long mainPostId = this.getMainPostIdBy(employeeId);
            this.changePostBy(employeeId, mainPostId, mainDeptId);
            return BaseSecurityUtil.getUser();
        }
        this.changePostBy(employeeId, hussarPostId, hussarDeptId);
        return BaseSecurityUtil.getUser();
    }

    public SecurityUser changePostBy(String deptId, String postId, String originDeptId, String originPostId, String mdmDeptId, String mdmPostId, UserDetails loginUserDetails) {
        Long employeeId;
        Long hussarDeptId = null;
        hussarDeptId = HussarUtils.isNotEmpty((Object)deptId) ? Long.valueOf(Long.parseLong(deptId)) : this.sysStruService.getHussarDeptIdBy(originDeptId, mdmDeptId);
        Long hussarPostId = null;
        hussarPostId = HussarUtils.isNotEmpty((Object)postId) ? Long.valueOf(Long.parseLong(postId)) : this.getHussarPostIdBy(originPostId, mdmPostId);
        Long userId = loginUserDetails.getUserId();
        logger.error("userId:{}", (Object)userId);
        SysUsers users = (SysUsers)this.usersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getId, (Object)userId));
        Long l = employeeId = HussarUtils.isNotEmpty((Object)users) ? users.getEmployeeId() : null;
        if (hussarDeptId == null && hussarPostId == null) {
            Long mainDeptId = this.sysStruService.getMainDeptIdBy(employeeId);
            Long mainPostId = this.getMainPostIdBy(employeeId);
            return this.changePostBy(employeeId, mainPostId, mainDeptId, loginUserDetails);
        }
        return this.changePostBy(employeeId, hussarPostId, hussarDeptId, loginUserDetails);
    }

    public UserDetails changePostByUser(String deptId, String postId, String originDeptId, String originPostId, String mdmDeptId, String mdmPostId, UserDetails userDetails, SysUsers users) {
        Long hussarDeptId = null;
        hussarDeptId = HussarUtils.isNotEmpty((Object)deptId) ? Long.valueOf(Long.parseLong(deptId)) : this.sysStruService.getHussarDeptIdBy(originDeptId, mdmDeptId);
        Long hussarPostId = null;
        hussarPostId = HussarUtils.isNotEmpty((Object)postId) ? Long.valueOf(Long.parseLong(postId)) : this.getHussarPostIdBy(originPostId, mdmPostId);
        Long userId = users.getId();
        logger.error("userId:{}", (Object)userId);
        Long employeeId = HussarUtils.isNotEmpty((Object)users) ? users.getEmployeeId() : null;
        SysUserPostMain userPostMain = new SysUserPostMain();
        SysUserPostMainVo postMain = this.userPostMainService.getUserPostMain(users.getEmployeeId());
        LoginUserExtendInfoDto loginUserExtendInfo = new LoginUserExtendInfoDto();
        List<Long> roleIdList = this.getRolesIdByUserId(users.getId());
        if (HussarUtils.isNotEmpty((Object)postMain)) {
            userDetails.addExtendUserMap("outOriginPostId", (Object)postMain.getOutPostId());
            loginUserExtendInfo.setId(postMain.getPostId());
            loginUserExtendInfo.setCode(postMain.getPostNo());
            loginUserExtendInfo.setType(postMain.getPostType());
            loginUserExtendInfo.setName(postMain.getPostName());
            loginUserExtendInfo.setMdmId(postMain.getOutPostId());
            loginUserExtendInfo.setOriginId(postMain.getOutOriginId());
            userDetails.addExtendUserMap("postInfo", (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)loginUserExtendInfo)));
            userDetails.addExtendUserMap("postMain", (Object)postMain.getUpPostId());
            userDetails.addExtendUserMap("postCurrent", (Object)postMain.getUpPostId());
            userDetails.addExtendUserMap("postMainId", (Object)postMain.getUpId());
            userDetails.addExtendUserMap("postCurrentId", (Object)postMain.getUpId());
            userPostMain.setUpId(postMain.getUpId());
            userPostMain.setUpPostId(postMain.getUpPostId());
            List roleIdPostList = this.sysPostService.getRoleIdByUserId(users.getId());
            roleIdList.addAll(roleIdPostList);
        }
        userDetails.addExtendUserMap("gradeAdmin", (Object)(ToolUtil.isNotEmpty(roleIdList) && roleIdList.contains(SysUserAndRole.GRADEADMIN_ROLE.getValue()) ? 1 : 0));
        List<Long> roleList = this.getRolesIdByStruId(users.getDepartmentId());
        if (HussarUtils.isNotEmpty(roleIdList)) {
            roleIdList.addAll(roleList);
        }
        userDetails.addExtendUserMap("rolesList", roleIdList);
        ResourceGrantedAuthority resourceGrantedAuthority = this.getPermissionByRoleIds(roleIdList, users.getId());
        userDetails.addExtendUserMap("theme", (Object)this.themeService.queryUserThemeWithUserId(users.getId()));
        ArrayList<Long> roleListNew = new ArrayList<Long>(roleIdList);
        roleList.add(userDetails.getUserId());
        userDetails.addExtendUserMap("welcomeUrl", (Object)this.sysWelcomeService.getUserIndex(roleListNew));
        userDetails.addExtendUserMap("permissions", (Object)resourceGrantedAuthority.getGrantAuthorityList());
        if (hussarDeptId == null && hussarPostId == null) {
            Long mainDeptId = this.sysStruService.getMainDeptIdBy(employeeId);
            Long upPostId = null;
            if (HussarUtils.isNotEmpty((Object)postMain)) {
                upPostId = postMain.getUpId();
            }
            logger.info("\u65e0id\u8fdb\u5165\uff0c\u9ed8\u8ba4\u4e3b\u5c97");
            return this.changePostBy(employeeId, upPostId, mainDeptId, userDetails, userPostMain);
        }
        logger.info("\u6709id\uff0c\u8ddf\u968f\u5c97\u4f4d\u4fe1\u606f\u5207\u5c97");
        return this.changePostBy(employeeId, hussarPostId, hussarDeptId, userDetails, userPostMain);
    }

    private ResourceGrantedAuthority getPermissionByRoleIds(List<Long> roleList, Long userId) {
        ArrayList<String> resourcePermissions;
        ResourceGrantedAuthority resourceGrantedAuthority = new ResourceGrantedAuthority();
        if (roleList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
            List resourcesList = this.sysResourcesService.list();
            resourcePermissions = new ArrayList<String>();
            for (SysResources resources : resourcesList) {
                resourcePermissions.add(resources.getPermissions());
            }
        } else {
            resourcePermissions = this.sysResourcesService.queryPermissionsByRoleIds(roleList);
        }
        if (HussarUtils.isNotEmpty((Object)resourcePermissions)) {
            resourceGrantedAuthority.setGrantAuthorityList(resourcePermissions);
        }
        return resourceGrantedAuthority;
    }

    private List<Long> getRolesIdByStruId(Long struId) {
        return this.iSysStruRoleService.getRolesByStruId(struId);
    }

    private List<Long> getRolesIdByUserId(Long userId) {
        return this.iSysUserRoleService.getRolesByUserId(userId);
    }

    private Long getUserPostIdBy(Long employeeId, Long postId, Long deptId, SysUserPostMain userPostMain) {
        SysUserPostConcurrently userPostConcurrently = null;
        if (HussarUtils.isEmpty((Object)userPostMain)) {
            userPostMain = (SysUserPostMain)this.userPostMainService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPostMain::getUpUserId, (Object)employeeId)).eq(SysUserPostMain::getUpPostId, (Object)postId));
        }
        if (userPostMain != null) {
            logger.error("userPostMain={}", (Object)userPostMain);
            return userPostMain.getUpId();
        }
        if (employeeId != null && postId != null && deptId != null) {
            userPostConcurrently = (SysUserPostConcurrently)this.userPostConcurrentlyService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPostConcurrently::getUpUserId, (Object)employeeId)).eq(SysUserPostConcurrently::getUpPostId, (Object)postId)).eq(SysUserPostConcurrently::getUpStruId, (Object)deptId));
        }
        if (userPostConcurrently != null) {
            logger.error("userPostConcurrently={}", userPostConcurrently);
            return userPostConcurrently.getUpId();
        }
        return null;
    }

    private Boolean isNeedChangePost(Long postId, Long deptId) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (securityUser != null) {
            Long currentDeptId;
            JSONObject postInfo = JSONObject.parseObject((String)JSON.toJSONString((Object)securityUser.getExtendUserMap("postInfo")));
            JSONObject deptInfo = JSONObject.parseObject((String)JSON.toJSONString((Object)securityUser.getExtendUserMap("deptInfo")));
            Long currentPostId = postInfo.get((Object)"id") != null ? Long.valueOf(Long.parseLong(String.valueOf(postInfo.get((Object)"id")))) : null;
            Long l = currentDeptId = deptInfo.get((Object)"id") != null ? Long.valueOf(Long.parseLong(String.valueOf(deptInfo.get((Object)"id")))) : null;
            if (currentPostId != null && currentDeptId != null && postId != null && deptId != null) {
                return !postId.equals(currentPostId) || !deptId.equals(currentDeptId);
            }
        }
        return false;
    }

    private Boolean isNeedChangePost(Long postId, Long deptId, UserDetails loginUserDetails) {
        if (loginUserDetails != null) {
            Long currentDeptId;
            JSONObject postInfo = JSONObject.parseObject((String)JSON.toJSONString((Object)loginUserDetails.getExtendUserMap("postInfo")));
            JSONObject deptInfo = JSONObject.parseObject((String)JSON.toJSONString((Object)loginUserDetails.getExtendUserMap("deptInfo")));
            Long currentPostId = postInfo.get((Object)"id") != null ? Long.valueOf(Long.parseLong(String.valueOf(postInfo.get((Object)"id")))) : null;
            Long l = currentDeptId = deptInfo.get((Object)"id") != null ? Long.valueOf(Long.parseLong(String.valueOf(deptInfo.get((Object)"id")))) : null;
            if (currentPostId != null && currentDeptId != null && postId != null && deptId != null) {
                return !postId.equals(currentPostId) || !deptId.equals(currentDeptId);
            }
            throw new BaseException("\u672a\u627e\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u5c97\u4f4d\u548c\u90e8\u95e8\u4fe1\u606f\uff0c\u5207\u6362\u5c97\u4f4d\u5931\u8d25\u3002");
        }
        throw new BaseException("\u672a\u627e\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff0c\u5207\u6362\u5c97\u4f4d\u5931\u8d25\u3002");
    }

    private void buildExtendUserMap(SecurityUser userDetails) {
        SysStru corporation = (SysStru)this.iSysStruService.getById((Serializable)((Object)String.valueOf(userDetails.getExtendUserMap().get("corporationId"))));
        SysStru dept = (SysStru)this.iSysStruService.getById((Serializable)((Object)String.valueOf(userDetails.getExtendUserMap().get("deptId"))));
        if (HussarUtils.isNotEmpty((Object)corporation)) {
            userDetails.addExtendUserMap("outOriginOrganId", (Object)corporation.getOutStruId());
            userDetails.addExtendUserMap("outOriginOrganType", (Object)corporation.getStruType());
        }
        if (HussarUtils.isNotEmpty((Object)dept)) {
            userDetails.addExtendUserMap("outOriginDeptId", (Object)dept.getOutStruId());
            userDetails.addExtendUserMap("outOriginDeptType", (Object)dept.getStruType());
        }
        Optional.ofNullable(this.sysPostService.getById((Serializable)((Object)String.valueOf(userDetails.getExtendUserMap().get("postCurrent"))))).ifPresent(p -> userDetails.addExtendUserMap("outOriginPostId", (Object)p.getOutPostId()));
        SysUsers sysUsers = new SysUsers();
        sysUsers.setDepartmentId(dept.getId());
        List organTypeList = this.sysStruService.getOrganTypeList(sysUsers);
        HussarSecurityUtils.putSessionExtend((String)"organType", (Object)organTypeList);
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            userDetails.addExtendUserMap("organType", (Object)organTypeList);
        }
        String userMdmId = String.valueOf(userDetails.getExtendUserMap("outOriginUserId"));
        String deptMdmId = String.valueOf(userDetails.getExtendUserMap("outOriginDeptId"));
        String directCompanyMdmId = String.valueOf(userDetails.getExtendUserMap("outOriginOrganId"));
        String postMdmId = String.valueOf(userDetails.getExtendUserMap("outOriginPostId"));
        userDetails.addExtendUserMap("userInfo", (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)this.hussarLoginUserExtendInfoService.getUserInfo(userMdmId))));
        userDetails.addExtendUserMap("deptInfo", (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)this.hussarLoginUserExtendInfoService.getDeptInfo(deptMdmId))));
        userDetails.addExtendUserMap("postInfo", (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)this.hussarLoginUserExtendInfoService.getPostInfo(postMdmId))));
        userDetails.addExtendUserMap("companyInfo", this.wrapCompanyInfo(directCompanyMdmId, deptMdmId));
    }

    private UserDetails buildExtendUserMap(UserDetails userDetails) {
        Long corporation = Long.parseLong(userDetails.getExtendUserMap("corporationId").toString());
        Long dept = Long.parseLong(userDetails.getExtendUserMap("deptId").toString());
        List queryParam = Stream.of(corporation, dept).filter(Objects::nonNull).collect(Collectors.toList());
        List strus = new ArrayList();
        if (HussarUtils.isNotEmpty(queryParam)) {
            strus = this.iSysStruService.getStruByStruIds(queryParam);
        }
        String outOriginOrganId = "";
        String outOriginOrganType = "";
        String outOriginDeptId = "";
        String outOriginDeptType = "";
        if (HussarUtils.isNotEmpty(strus)) {
            for (SysStru sysStru : strus) {
                if (corporation.equals(sysStru.getId())) {
                    outOriginOrganId = sysStru.getOutStruId();
                    outOriginOrganType = sysStru.getStruType();
                    continue;
                }
                if (!dept.equals(sysStru.getId())) continue;
                outOriginDeptId = sysStru.getOutStruId();
                outOriginDeptType = sysStru.getStruType();
            }
        }
        userDetails.addExtendUserMap("outOriginOrganId", (Object)outOriginOrganId);
        userDetails.addExtendUserMap("outOriginOrganType", (Object)outOriginOrganType);
        userDetails.addExtendUserMap("outOriginDeptId", (Object)outOriginDeptId);
        userDetails.addExtendUserMap("outOriginDeptType", (Object)outOriginDeptType);
        String deptMdmId = String.valueOf(userDetails.getExtendUserMap("outOriginDeptId"));
        String directCompanyMdmId = String.valueOf(userDetails.getExtendUserMap("outOriginOrganId"));
        SysUsers sysUsers = new SysUsers();
        sysUsers.setDepartmentId(dept);
        List organTypeList = this.sysStruService.getOrganTypeList(sysUsers);
        userDetails.addExtendUserMap("organType", (Object)organTypeList);
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            userDetails.addExtendUserMap("organType", (Object)organTypeList);
        }
        Map<String, SysStru> map = strus.stream().collect(Collectors.toMap(SysStru::getOutStruId, Function.identity()));
        LoginUserExtendInfoDto deptInfo = new LoginUserExtendInfoDto();
        deptInfo.setName((String)userDetails.getExtendUserMap("organName"));
        deptInfo.setCode((String)userDetails.getExtendUserMap("organCode"));
        SysStru dept1 = (SysStru)map.get(deptMdmId);
        if (HussarUtils.isNotEmpty((Object)dept1)) {
            deptInfo.setId(dept1.getId() + "");
            deptInfo.setType(dept1.getStruType());
            deptInfo.setMdmId(dept1.getOutStruId());
            deptInfo.setOriginId(dept1.getOutOriginId());
        }
        logger.info("22222222222222222");
        userDetails.addExtendUserMap("deptInfo", (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)deptInfo)));
        userDetails.addExtendUserMap("companyInfo", this.wrapCompanyInfo(directCompanyMdmId, deptMdmId, map));
        return userDetails;
    }

    public List<SysUserPostVo> getAllPostByUserId(Long userId) {
        SysUserPostVo sysUserPostVo = ((SysPostMapper)this.baseMapper).getMainPostByUserId(userId);
        List<SysUserPostVo> list = ((SysPostMapper)this.baseMapper).getConPostByUserId(userId);
        if (sysUserPostVo != null) {
            list.add(0, sysUserPostVo);
            Long sturId = ((SysPostMapper)this.baseMapper).getStruIdByUserId(sysUserPostVo.getUpUserId());
            sysUserPostVo.setUpStruId(sturId);
        }
        return list;
    }

    public List<SysUserPostVo> getChangePostList(Long userId) {
        List<SysUserPostVo> list = this.getAllPostByUserId(userId);
        for (SysUserPostVo sysUserPostVo : list) {
            String afterSub;
            String name;
            if (sysUserPostVo.getUpStruId() == null || !HussarUtils.isNotEmpty((Object)(name = ((SysStru)this.sysStruService.getOne((Wrapper)new LambdaUpdateWrapper().eq(SysStru::getId, (Object)sysUserPostVo.getUpStruId()))).getPathName()))) continue;
            String newName = name.replace(">>", "-");
            logger.info("newName: " + newName);
            if (newName.contains("-")) {
                String beforSub = newName.substring(0, newName.indexOf("-"));
                afterSub = newName.substring(beforSub.length() + 1);
                if (afterSub.contains(">")) {
                    String afterSubBefore = afterSub.substring(0, afterSub.indexOf(">"));
                    afterSub = afterSub.substring(afterSubBefore.length() + 1);
                }
            } else {
                afterSub = newName;
            }
            sysUserPostVo.setPostName(afterSub + sysUserPostVo.getPostName());
            this.organ = null;
            this.organName = null;
        }
        return list;
    }

    public String getAddPostInfo(Long postId) {
        SysPost postInfo = (SysPost)((SysPostMapper)this.baseMapper).selectById(postId);
        String postParentCode = "";
        if (ToolUtil.isNotEmpty((Object)postInfo) && ToolUtil.isEmpty((Object)(postParentCode = postInfo.getPostNo()))) {
            postParentCode = "";
        }
        String businessName = "POST_CODE";
        String tableName = "SYS_POST";
        String currentCode = this.sysIdtableService.getCurrentCode(businessName, tableName, postParentCode);
        return currentCode;
    }

    public List<SysPostOut> existPost() {
        return ((SysPostMapper)this.baseMapper).existPost();
    }

    public List<SysOrganType> getOrgTypeOption() {
        List<SysOrganType> list = this.sysOrganTypeMapper.getOrgTypeOption();
        list = list.stream().filter(v -> !v.getTypeName().equals("\u4eba\u5458")).collect(Collectors.toList());
        return list;
    }

    public List<SysStruRule> getOrgRoleByCode(String orgType, String isRoot) {
        return ((SysPostMapper)this.baseMapper).getOrgRoleByCode(orgType, isRoot);
    }

    private Map<String, Object> wrapUnitInfo(String deptMdmId) {
        HashMap<String, Object> unitMap = new HashMap<String, Object>();
        SysStru stru = (SysStru)this.iSysStruService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOutStruId, (Object)deptMdmId));
        List unitInfos = this.hussarLoginUserExtendInfoService.listUnitInfos(stru);
        for (int i = 0; i < unitInfos.size(); ++i) {
            unitMap.put("level" + (i + 1), JSONObject.parseObject((String)JSON.toJSONString(unitInfos.get(i))));
        }
        return unitMap;
    }

    private Map<String, Object> wrapDirectCompanyInfo(String directCompanyMdmId) {
        HashMap<String, Object> directCompanyMap = new HashMap<String, Object>();
        LoginUserExtendInfoDto directCompanyInfo = this.hussarLoginUserExtendInfoService.getOrganizationInfoNew(directCompanyMdmId);
        if (HussarUtils.isNotEmpty((Object)directCompanyInfo)) {
            directCompanyMap.put("direct", JSONObject.parseObject((String)JSON.toJSONString((Object)directCompanyInfo)));
        }
        return directCompanyMap;
    }

    private Map<String, Object> wrapCompanyInfo(String directCompanyMdmId, String deptMdmId) {
        HashMap<String, Object> companyMap = new HashMap<String, Object>();
        companyMap.putAll(this.wrapDirectCompanyInfo(deptMdmId));
        companyMap.putAll(this.wrapUnitInfo(deptMdmId));
        return companyMap;
    }

    private Map<String, Object> wrapCompanyInfo(String directCompanyMdmId, String deptMdmId, Map<String, SysStru> map) {
        HashMap<String, Object> companyMap = new HashMap<String, Object>();
        companyMap.putAll(this.wrapDirectCompanyInfo(map.get(directCompanyMdmId)));
        companyMap.putAll(this.wrapUnitInfo(map.get(deptMdmId)));
        return companyMap;
    }

    private Map<String, Object> wrapDirectCompanyInfo(SysStru directCompanyMdm) {
        HashMap<String, Object> directCompanyMap = new HashMap<String, Object>();
        LoginUserExtendInfoDto directCompanyInfo = this.hussarLoginUserExtendInfoService.getDirectCompanyInfo(directCompanyMdm);
        if (HussarUtils.isNotEmpty((Object)directCompanyInfo)) {
            directCompanyMap.put("direct", JSONObject.parseObject((String)JSON.toJSONString((Object)directCompanyInfo)));
        }
        return directCompanyMap;
    }

    private Map<String, Object> wrapUnitInfo(SysStru deptMdm) {
        HashMap<String, Object> unitMap = new HashMap<String, Object>();
        List unitInfos = this.hussarLoginUserExtendInfoService.listUnitInfosNew(deptMdm);
        for (int i = 0; i < unitInfos.size(); ++i) {
            unitMap.put("level" + (i + 1), JSONObject.parseObject((String)JSON.toJSONString(unitInfos.get(i))));
        }
        return unitMap;
    }

    public Long getHussarPostIdBy(String originPostId, String mdmPostId) {
        SysPost post = null;
        if (HussarUtils.isNotEmpty((Object)originPostId)) {
            post = (SysPost)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysPost::getOutOriginId, (Object)originPostId));
            return post != null ? post.getPostId() : null;
        }
        if (HussarUtils.isNotEmpty((Object)mdmPostId)) {
            post = (SysPost)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysPost::getOutPostId, (Object)mdmPostId));
            return post != null ? post.getPostId() : null;
        }
        return null;
    }

    public Long getMainPostIdBy(Long employeeId) {
        if (HussarUtils.isNotEmpty((Object)employeeId)) {
            SysUserPostMain userPostMain = (SysUserPostMain)this.userPostMainService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUserPostMain::getUpUserId, (Object)employeeId));
            return HussarUtils.isNotEmpty((Object)userPostMain) ? userPostMain.getUpPostId() : null;
        }
        return null;
    }

    public SysUserPostMain getMainPostIdBy(Long employeeId, SysUserPostMain userPostMain) {
        if (HussarUtils.isNotEmpty((Object)employeeId)) {
            userPostMain = (SysUserPostMain)this.userPostMainService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUserPostMain::getUpUserId, (Object)employeeId));
            if (HussarUtils.isNotEmpty((Object)userPostMain)) {
                return userPostMain;
            }
            return null;
        }
        return null;
    }
}

