/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.post.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.post.dto.SysStruPostDto;
import com.jxdinfo.hussar.authorization.post.model.SysStruPost;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostConcurrently;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostMain;
import com.jxdinfo.hussar.authorization.post.service.StruPostService;
import com.jxdinfo.hussar.authorization.post.service.UserPostConcurrentlyService;
import com.jxdinfo.hussar.authorization.post.service.UserPostMainService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.post.post.dao.StruPostMapper;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class StruPostServiceImpl
extends HussarServiceImpl<StruPostMapper, SysStruPost>
implements StruPostService {
    @Resource
    private StruPostService struPostService;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private UserPostMainService userPostMainService;
    @Resource
    private UserPostConcurrentlyService userPostConcurrentlyService;
    @Resource
    private StruPostMapper struPostMapper;

    public String saveStruPost(SysStruPostDto sysStruPostDto) {
        Long struId = this.struPostService.getStruId(sysStruPostDto.getOrganCode());
        List list = sysStruPostDto.getList();
        if (struId != null) {
            for (SysStruPost sysStruPost : list) {
                sysStruPost.setOpStruId(struId);
            }
            boolean bl = this.saveOrUpdateBatch(list);
            if (bl) {
                return "\u4fdd\u5b58\u6210\u529f";
            }
            return "\u4fdd\u5b58\u5931\u8d25";
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u8be5\u7ec4\u7ec7\u4fe1\u606f");
    }

    public String addStruPostAll(List<SysStruPost> list, Long struId) {
        if (struId != null) {
            if (list.size() > 0) {
                for (SysStruPost sysStruPost : list) {
                    sysStruPost.setOpStruId(struId);
                }
                boolean bl = this.addPostAll(list, struId);
                if (bl) {
                    return "\u4fdd\u5b58\u6210\u529f";
                }
                return "\u4fdd\u5b58\u5931\u8d25";
            }
            return "\u4fdd\u5b58\u6210\u529f";
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u8be5\u7ec4\u7ec7\u4fe1\u606f");
    }

    public Long getStruId(String organCode) {
        return ((StruPostMapper)this.baseMapper).getStruId(organCode);
    }

    @HussarTransactional
    public boolean addPostAll(List<SysStruPost> sysStruPostList, Long struId) {
        try {
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            qw.eq(SysStruPost::getOpStruId, (Object)struId);
            this.remove((Wrapper)qw);
            this.struPostService.saveOrUpdateBatch(sysStruPostList);
            return true;
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5b58\u5c97\u4f4d\u673a\u6784\u5173\u7cfb\u4fe1\u606f\u51fa\u9519\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
            return false;
        }
    }

    public boolean checkPerson(SysStruPostDto sysStruPostDto) {
        boolean flag = true;
        Long struId = null;
        if (HussarUtils.isNotEmpty((Object)sysStruPostDto.getOrganCode())) {
            struId = this.struPostService.getStruId(sysStruPostDto.getOrganCode());
        }
        List list = sysStruPostDto.getList();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(SysStruPost::getOpStruId, (Object)struId);
        List oldList = this.list((Wrapper)qw);
        if (HussarUtils.isEmpty((Object)list)) {
            if (HussarUtils.isNotEmpty((Object)oldList)) {
                for (SysStruPost sysStruPost : oldList) {
                    List<Long> staffList = this.struPostMapper.getStaffList(struId);
                    LambdaQueryWrapper qwc = new LambdaQueryWrapper();
                    qwc.eq(SysUserPostMain::getUpPostId, (Object)sysStruPost.getOpPostId());
                    List listMain = this.userPostMainService.list((Wrapper)qwc);
                    if (HussarUtils.isNotEmpty(staffList) && HussarUtils.isNotEmpty((Object)listMain)) {
                        block1: for (Long l : staffList) {
                            for (SysUserPostMain sysUserPostMain : listMain) {
                                if (!l.equals(sysUserPostMain.getUpUserId())) continue;
                                flag = false;
                                continue block1;
                            }
                        }
                    }
                    LambdaQueryWrapper qwj = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)qwj.eq(SysUserPostConcurrently::getUpPostId, (Object)sysStruPost.getOpPostId())).eq(SysUserPostConcurrently::getUpStruId, (Object)sysStruPost.getOpStruId());
                    List listConcurrently = this.userPostConcurrentlyService.list((Wrapper)qwj);
                    if (listConcurrently.size() == 0) continue;
                    flag = false;
                    break;
                }
            }
        } else if (HussarUtils.isNotEmpty((Object)oldList)) {
            ArrayList<SysStruPost> oldListCopy = new ArrayList<SysStruPost>();
            for (SysStruPost sysStruPost : oldList) {
                boolean i = false;
                for (SysStruPost s : list) {
                    if (!sysStruPost.getOpPostId().equals(s.getOpPostId())) continue;
                    i = true;
                    break;
                }
                if (!i) continue;
                oldListCopy.add(sysStruPost);
            }
            oldList.removeAll(oldListCopy);
            if (HussarUtils.isNotEmpty((Object)oldList)) {
                for (SysStruPost sysStruPost : oldList) {
                    List<Long> staffList = this.struPostMapper.getStaffList(struId);
                    LambdaQueryWrapper qwc = new LambdaQueryWrapper();
                    qwc.eq(SysUserPostMain::getUpPostId, (Object)sysStruPost.getOpPostId());
                    List listMain = this.userPostMainService.list((Wrapper)qwc);
                    if (HussarUtils.isNotEmpty(staffList) && HussarUtils.isNotEmpty((Object)listMain)) {
                        block6: for (Long l : staffList) {
                            for (SysUserPostMain sysUserPostMain : listMain) {
                                if (!l.equals(sysUserPostMain.getUpUserId())) continue;
                                flag = false;
                                continue block6;
                            }
                        }
                    }
                    LambdaQueryWrapper qwj = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)qwj.eq(SysUserPostConcurrently::getUpPostId, (Object)sysStruPost.getOpPostId())).eq(SysUserPostConcurrently::getUpStruId, (Object)sysStruPost.getOpStruId());
                    List listConcurrently = this.userPostConcurrentlyService.list((Wrapper)qwj);
                    if (listConcurrently.size() == 0) continue;
                    flag = false;
                    break;
                }
            } else {
                flag = true;
            }
        }
        return flag;
    }

    public List<SysStruPost> getStruPost(SysStruPost sysStruPost) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(SysStruPost::getOpStruId, (Object)sysStruPost.getOpStruId());
        return this.list((Wrapper)qw);
    }

    public List<SysOrganType> getOrgTypeOption() {
        List<SysOrganType> list = this.sysOrganTypeMapper.getOrgTypeOption();
        list = list.stream().filter(v -> !v.getTypeName().equals("\u4eba\u5458")).collect(Collectors.toList());
        return list;
    }

    public List<SysStruRule> getOrgRoleByCode(String orgType, String isRoot) {
        return this.struPostMapper.getOrgRoleByCode(orgType, isRoot);
    }
}

