/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.application.dto.ApplicationDto;
import com.jxdinfo.hussar.authorization.application.dto.SeqDto;
import com.jxdinfo.hussar.authorization.application.model.ApplicationUser;
import com.jxdinfo.hussar.authorization.application.model.SysApplicationVariable;
import com.jxdinfo.hussar.authorization.application.model.SysApplications;
import com.jxdinfo.hussar.authorization.application.service.IApplicationUserService;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationVariableService;
import com.jxdinfo.hussar.authorization.application.vo.ApplicationResourceVo;
import com.jxdinfo.hussar.authorization.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleInfoDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.post.application.dao.ApplicationPostMapper;
import com.jxdinfo.hussar.post.application.dao.ApplicationRoleMapper;
import com.jxdinfo.hussar.post.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service
public class SysApplicationServiceImpl
extends HussarServiceImpl<SysApplicationMapper, SysApplications>
implements ISysApplicationService {
    private static final String VARNAME = "varName";
    private static final String VARVALUE = "varValue";
    private static final Long QIANKUN_RESOURCE = 654044010905870336L;
    private static final Long IFRAME_RESOURCE = 654044153998745600L;
    private static final Long QIANKUN_FUNCTION = 654044380499550208L;
    private static final Long IFRAME_FUNCTION = 654044280356347904L;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    ApplicationRoleMapper applicationRoleMapper;
    @Resource
    ApplicationPostMapper applicationPostMapper;
    @Resource
    private ISysApplicationVariableService sysApplicationVariableService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysResManageService sysResManageService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private IApplicationUserService applicationUserService;

    @DSTransactional
    @CacheEvict(value={"resource_info"}, allEntries=true)
    public Long add(ApplicationDto applicationDto) {
        List<SysApplicationVariable> variableList;
        boolean saveResult;
        SysApplications sysApplication = this.setSysApp(applicationDto);
        int insertResult = this.sysApplicationMapper.insert(sysApplication);
        if (insertResult != 1) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        if (HussarUtils.isNotEmpty((Object)applicationDto.getVariables()) && !"[]".equals(applicationDto.getVariables()) && !(saveResult = this.sysApplicationVariableService.saveBatch(variableList = this.setAppVars(applicationDto, sysApplication)))) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        if (!"2".equals(applicationDto.getTypes())) {
            FuncModuleInfoDto funcModuleInfoDto = new FuncModuleInfoDto();
            funcModuleInfoDto.setFunctionModuleName(sysApplication.getAppName());
            funcModuleInfoDto.setAppId(sysApplication.getAppId());
            if ("0".equals(applicationDto.getTypes())) {
                funcModuleInfoDto.setParentModuleId(QIANKUN_FUNCTION);
            } else {
                funcModuleInfoDto.setParentModuleId(IFRAME_FUNCTION);
            }
            boolean result = this.sysFunctionModulesService.saveOrUpdateFunctionModule(funcModuleInfoDto);
            if (!result) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25");
            }
            String moduleCode = this.sysIdtableService.getCurrentCode("MODULE_CODE", "SYS_RESOURCE_MODULES");
            String moduleName = sysApplication.getAppName();
            Long appId = sysApplication.getAppId();
            SysResourceModules sysResourceModules = new SysResourceModules();
            sysResourceModules.setModuleCode(moduleCode);
            sysResourceModules.setModuleName(moduleName);
            if ("0".equals(applicationDto.getTypes())) {
                sysResourceModules.setParentModuleId(QIANKUN_RESOURCE);
            } else {
                sysResourceModules.setParentModuleId(IFRAME_RESOURCE);
            }
            sysResourceModules.setAppId(appId);
            result = this.sysResManageService.saveModules(sysResourceModules).isSuccess();
            if (!result) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25");
            }
        }
        return sysApplication.getAppId();
    }

    @DSTransactional
    @CacheEvict(value={"resource_info"}, allEntries=true)
    public String edit(ApplicationDto applicationDto) {
        List<SysApplicationVariable> variableList;
        boolean saveResult;
        boolean deleteResult;
        SysApplications sysApplication = this.setSysApp(applicationDto);
        int editResult = this.sysApplicationMapper.updateById(sysApplication);
        if (editResult != 1) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25");
        }
        long varNum = this.sysApplicationVariableService.count((Wrapper)new LambdaQueryWrapper().eq(SysApplicationVariable::getAppId, (Object)applicationDto.getAppId()));
        if (varNum != 0L && !(deleteResult = this.sysApplicationVariableService.remove((Wrapper)new LambdaQueryWrapper().eq(SysApplicationVariable::getAppId, (Object)applicationDto.getAppId())))) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25");
        }
        if (HussarUtils.isNotEmpty((Object)applicationDto.getVariables()) && !"[]".equals(applicationDto.getVariables()) && !(saveResult = this.sysApplicationVariableService.saveBatch(variableList = this.setAppVars(applicationDto, sysApplication)))) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25");
        }
        if (!"2".equals(applicationDto.getTypes())) {
            boolean result;
            FuncModuleInfoDto funcModuleInfoDto = new FuncModuleInfoDto();
            funcModuleInfoDto.setFunctionModuleName(sysApplication.getAppName());
            funcModuleInfoDto.setAppId(sysApplication.getAppId());
            if ("0".equals(applicationDto.getTypes())) {
                funcModuleInfoDto.setParentModuleId(QIANKUN_FUNCTION);
            } else {
                funcModuleInfoDto.setParentModuleId(IFRAME_FUNCTION);
            }
            ArrayList<Long> parentFunction = new ArrayList<Long>();
            parentFunction.add(QIANKUN_FUNCTION);
            parentFunction.add(IFRAME_FUNCTION);
            List sysFunctionModules = this.sysFunctionModulesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getAppId, (Object)sysApplication.getAppId())).in(SysFunctionModules::getParentModuleId, parentFunction));
            if (ToolUtil.isNotEmpty((Object)sysFunctionModules)) {
                funcModuleInfoDto.setFunctionModuleId(((SysFunctionModules)sysFunctionModules.get(0)).getId());
            }
            if (!(result = this.sysFunctionModulesService.saveOrUpdateFunctionModule(funcModuleInfoDto))) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25");
            }
            String moduleName = sysApplication.getAppName();
            Long appId = sysApplication.getAppId();
            SysResourceModules sysResourceModules = new SysResourceModules();
            sysResourceModules.setModuleName(moduleName);
            if ("0".equals(applicationDto.getTypes())) {
                sysResourceModules.setParentModuleId(QIANKUN_RESOURCE);
            } else {
                sysResourceModules.setParentModuleId(IFRAME_RESOURCE);
            }
            sysResourceModules.setAppId(appId);
            ArrayList<Long> parentResource = new ArrayList<Long>();
            parentResource.add(QIANKUN_RESOURCE);
            parentResource.add(IFRAME_RESOURCE);
            List resourceModules = this.sysResourceMosulesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceModules::getAppId, (Object)appId)).in(SysResourceModules::getParentModuleId, parentResource));
            if (ToolUtil.isNotEmpty((Object)resourceModules)) {
                sysResourceModules.setId(((SysResourceModules)resourceModules.get(0)).getId());
                String moduleCode = ((SysResourceModules)resourceModules.get(0)).getModuleCode();
                sysResourceModules.setModuleCode(moduleCode);
            }
            if (!(result = this.sysResManageService.saveModules(sysResourceModules).isSuccess())) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25");
            }
        }
        return "\u4fee\u6539\u6210\u529f";
    }

    private List<SysApplicationVariable> setAppVars(ApplicationDto applicationDto, SysApplications sysApplication) {
        ArrayList<SysApplicationVariable> variableList = new ArrayList<SysApplicationVariable>();
        JSONArray jsonArray = JSON.parseArray((String)applicationDto.getVariables());
        for (int i = 0; i < jsonArray.size(); ++i) {
            SysApplicationVariable sysApplicationVariable = new SysApplicationVariable();
            sysApplicationVariable.setVarName(jsonArray.getJSONObject(i).getString(VARNAME));
            sysApplicationVariable.setVarValue(jsonArray.getJSONObject(i).getString(VARVALUE));
            sysApplicationVariable.setAppId(sysApplication.getAppId());
            variableList.add(sysApplicationVariable);
        }
        return variableList;
    }

    private SysApplications setSysApp(ApplicationDto applicationDto) {
        SysApplications sysApplication = new SysApplications();
        if (HussarUtils.isNotEmpty((Object)applicationDto.getAppId())) {
            long sameNum = this.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplications::getAppLabel, (Object)applicationDto.getAppLabel())).ne(SysApplications::getAppId, (Object)applicationDto.getAppId()));
            if (sameNum != 0L) {
                throw new BaseException("\u5e94\u7528\u6807\u8bc6\u5df2\u5b58\u5728");
            }
            sameNum = this.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplications::getAppName, (Object)applicationDto.getAppName())).ne(SysApplications::getAppId, (Object)applicationDto.getAppId()));
            if (sameNum != 0L) {
                throw new BaseException("\u5e94\u7528\u5df2\u5b58\u5728");
            }
            sysApplication.setAppId(applicationDto.getAppId());
            sysApplication.setSeq(applicationDto.getSeq());
        } else {
            long appNum = this.count((Wrapper)new LambdaQueryWrapper().eq(SysApplications::getAppLabel, (Object)applicationDto.getAppLabel()));
            if (appNum != 0L) {
                throw new BaseException("\u5e94\u7528\u6807\u8bc6\u5df2\u5b58\u5728");
            }
            appNum = this.count((Wrapper)new LambdaQueryWrapper().eq(SysApplications::getAppName, (Object)applicationDto.getAppName()));
            if (appNum != 0L) {
                throw new BaseException("\u5e94\u7528\u5df2\u5b58\u5728");
            }
            int order = 1;
            Integer maxOrder = this.sysApplicationMapper.getMaxOrderByParentId(applicationDto.getGroupId());
            if (HussarUtils.isNotEmpty((Object)maxOrder)) {
                order = maxOrder + 1;
            }
            sysApplication.setSeq(order);
        }
        sysApplication.setGroupId(applicationDto.getGroupId());
        sysApplication.setAppName(applicationDto.getAppName());
        sysApplication.setAppLabel(applicationDto.getAppLabel());
        sysApplication.setDes(applicationDto.getDes());
        sysApplication.setTypes(applicationDto.getTypes());
        sysApplication.setImagePath(applicationDto.getImagePath());
        sysApplication.setAppUrl(applicationDto.getAppUrl());
        sysApplication.setEntrance(applicationDto.getEntrance());
        return sysApplication;
    }

    @DSTransactional
    @CacheEvict(value={"resource_info"}, allEntries=true)
    public String delete(Long appId) {
        List sysResourceModules;
        boolean hasDeleted;
        int deleteResult = this.sysApplicationMapper.deleteById(appId);
        if (deleteResult != 1) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        long varNum = this.sysApplicationVariableService.count((Wrapper)new LambdaQueryWrapper().eq(SysApplicationVariable::getAppId, (Object)appId));
        if (varNum != 0L && !(hasDeleted = this.sysApplicationVariableService.remove((Wrapper)new LambdaQueryWrapper().eq(SysApplicationVariable::getAppId, (Object)appId)))) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        List sysFunctionModules = this.sysFunctionModulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getAppId, (Object)appId));
        if (ToolUtil.isNotEmpty((Object)sysFunctionModules)) {
            ArrayList<Long> modulesId = new ArrayList<Long>();
            for (SysFunctionModules module : sysFunctionModules) {
                modulesId.add(module.getId());
            }
            hasDeleted = this.sysFunctionModulesService.deleteFunctionModule(modulesId);
            if (!hasDeleted) {
                throw new BaseException("\u5220\u9664\u5931\u8d25");
            }
        }
        if (ToolUtil.isNotEmpty((Object)(sysResourceModules = this.sysResourceMosulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getAppId, (Object)appId))))) {
            ArrayList<Long> modulesId = new ArrayList<Long>();
            for (SysResourceModules module : sysResourceModules) {
                modulesId.add(module.getId());
            }
            hasDeleted = this.sysResourceMosulesService.delResModule(modulesId);
            if (!hasDeleted) {
                throw new BaseException("\u5220\u9664\u5931\u8d25");
            }
        }
        this.applicationRoleMapper.deleteRole(appId);
        this.applicationPostMapper.deletePostAndApplication(appId);
        long appUserNum = this.applicationUserService.count((Wrapper)new LambdaQueryWrapper().eq(ApplicationUser::getAppId, (Object)appId));
        if (appUserNum != 0L && !(hasDeleted = this.applicationUserService.remove((Wrapper)new LambdaQueryWrapper().eq(ApplicationUser::getAppId, (Object)appId)))) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return "\u5220\u9664\u6210\u529f";
    }

    public SysApplicationVo search(Long appId) {
        return this.sysApplicationMapper.search(appId);
    }

    public boolean hasAppsInGroup(Long groupId) {
        long appNum = this.count((Wrapper)new LambdaQueryWrapper().eq(SysApplications::getGroupId, (Object)groupId));
        return appNum != 0L;
    }

    public List<JSTreeModel> getApplicationByGroupId(Long groupId, String groupName) {
        if (HussarUtils.isEmpty((Object)groupId)) {
            throw new BaseException("\u6a21\u5757id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<JSTreeModel> result = this.sysApplicationMapper.getAppByGroupId(groupId);
        JSTreeModel root = new JSTreeModel();
        root.setId(groupId);
        root.setText(groupName);
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isModule");
        result.add(root);
        return TreeModelUtils.merge(result);
    }

    public IPage<SysApplicationVo> getApplicationByPage(Page<SysApplicationVo> page, SysApplications sysApplication) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        page.setRecords(this.sysApplicationMapper.getApplicationByPage(page, sysApplication));
        return page;
    }

    public List<SysApplicationVo> getApplicationByTypesAndName(SysApplications sysApplication) {
        String types = sysApplication.getTypes();
        String appName = sysApplication.getAppName();
        return this.sysApplicationMapper.getApplicationByTypesAndName(types, appName);
    }

    public List<ApplicationResourceVo> selectApplication(String types) {
        SecurityUser user = BaseSecurityUtil.getUser();
        List roleId = user.getRolesList();
        ArrayList<String> roleIds = new ArrayList<String>();
        List<ApplicationResourceVo> list = new ArrayList<ApplicationResourceVo>();
        if (ToolUtil.isNotEmpty((Object)roleId)) {
            for (Long role : roleId) {
                roleIds.add(role.toString());
            }
            list = this.sysApplicationMapper.selectApplication(types, roleIds);
        }
        return list;
    }

    public String saveSeq(List<SeqDto> seqDtoList) {
        ArrayList<SysApplications> applications = new ArrayList<SysApplications>();
        for (SeqDto seq : seqDtoList) {
            SysApplications sysApplication = new SysApplications();
            sysApplication.setSeq(seq.getSeq());
            sysApplication.setAppId(seq.getId());
            applications.add(sysApplication);
        }
        if (HussarUtils.isNotEmpty(applications)) {
            boolean hasUpdate;
            boolean bl = hasUpdate = this.sysApplicationMapper.saveSeq(applications) == applications.size();
            if (!hasUpdate) {
                throw new BaseException("\u4fdd\u5b58\u6392\u5e8f\u4fe1\u606f\u5931\u8d25");
            }
        }
        return "\u4fdd\u5b58\u6210\u529f";
    }
}

