/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.post.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.authorization.post.vo.PostCodeVo;
import com.jxdinfo.hussar.authorization.post.vo.SysUserPostVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c97\u4f4d\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/post"})
public class SysPostController
extends HussarBaseController<SysPost, ISysPostService> {
    @Resource
    private ISysPostService sysPostService;

    @ApiOperation(value="\u5c97\u4f4d\u4fe1\u606f\u67e5\u8be2", notes="\u5c97\u4f4d\u4fe1\u606f\u67e5\u8be2")
    @CheckPermission(value={"post:getPostList"})
    @GetMapping(value={"/getPostList"})
    @AuditLog(moduleName="\u5c97\u4f4d\u4fe1\u606f", eventDesc="\u5c97\u4f4d\u4fe1\u606f\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<SysPost>> getPostList(SysPost sysPost, Page<SysPost> page) {
        return ApiResponse.success((Object)this.sysPostService.getPostList(sysPost, page));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5c97\u4f4d\u4fe1\u606f", notes="\u6dfb\u52a0\u5c97\u4f4d\u4fe1\u606f")
    @CheckPermission(value={"post:addPost"})
    @PostMapping(value={"/addPost"})
    @AuditLog(moduleName="\u6dfb\u52a0\u5c97\u4f4d\u4fe1\u606f", eventDesc="\u6dfb\u52a0\u5c97\u4f4d\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> addPost(@RequestBody SysPost sysPost) {
        return ApiResponse.success((String)this.sysPostService.addPost(sysPost));
    }

    @ApiOperation(value="\u4fee\u6539\u5c97\u4f4d\u4fe1\u606f", notes="\u4fee\u6539\u5c97\u4f4d\u4fe1\u606f")
    @CheckPermission(value={"post:editPost"})
    @PostMapping(value={"/editPost"})
    @AuditLog(moduleName="\u4fee\u6539\u5c97\u4f4d\u4fe1\u606f", eventDesc="\u4fee\u6539\u5c97\u4f4d\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> editPost(@RequestBody SysPost sysPost) {
        return ApiResponse.success((String)this.sysPostService.editPost(sysPost));
    }

    @ApiOperation(value="\u5220\u9664\u5c97\u4f4d\u4fe1\u606f", notes="\u5220\u9664\u5c97\u4f4d\u4fe1\u606f")
    @CheckPermission(value={"post:delPost"})
    @GetMapping(value={"/delPost"})
    @AuditLog(moduleName="\u5220\u9664\u5c97\u4f4d\u4fe1\u606f", eventDesc="\u5220\u9664\u5c97\u4f4d\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> delPost(String ids) {
        return ApiResponse.success((String)this.sysPostService.delPost(ids));
    }

    @ApiOperation(value="\u67e5\u8be2\u5c97\u4f4d\u6811-\u5168\u90e8", notes="\u67e5\u8be2\u5c97\u4f4d\u6811-\u5168\u90e8")
    @CheckPermission(value={"post:getPostTree"})
    @PostMapping(value={"/getPostTree"})
    @AuditLog(moduleName="\u67e5\u8be2\u5c97\u4f4d\u6811-\u5168\u90e8", eventDesc="\u67e5\u8be2\u5c97\u4f4d\u6811-\u5168\u90e8", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getPostTree(@RequestBody SysPost sysPost) {
        return ApiResponse.success((Object)this.sysPostService.getPostTree(sysPost));
    }

    @ApiOperation(value="\u67e5\u8be2\u5c97\u4f4d\u6811-\u6839\u636e\u8282\u70b9\u67e5\u8be2", notes="\u67e5\u8be2\u5c97\u4f4d\u6811-\u6839\u636e\u8282\u70b9\u67e5\u8be2")
    @CheckPermission(value={"post:getPostTreeByNode"})
    @PostMapping(value={"/getPostTreeByNode"})
    @AuditLog(moduleName="\u67e5\u8be2\u5c97\u4f4d\u6811-\u6839\u636e\u8282\u70b9\u67e5\u8be2", eventDesc="\u67e5\u8be2\u5c97\u4f4d\u6811-\u6839\u636e\u8282\u70b9\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysPost>> getPostTreeByNode(@RequestBody SysPost sysPost) {
        return ApiResponse.success((Object)this.sysPostService.getPostTreeByNode(sysPost));
    }

    @ApiOperation(value="\u4eba\u5458\u7ba1\u7406\u5c97\u4f4d\u6811\u67e5\u8be2\u5df2\u5173\u8054\u5c97\u4f4d", notes="\u4eba\u5458\u7ba1\u7406\u5c97\u4f4d\u6811\u67e5\u8be2\u5df2\u5173\u8054\u5c97\u4f4d")
    @CheckPermission(value={"post:getPostTreeByNodeIsChoose"})
    @PostMapping(value={"/getPostTreeByNodeIsChoose"})
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406\u5c97\u4f4d\u6811\u67e5\u8be2\u5df2\u5173\u8054\u5c97\u4f4d", eventDesc="\u4eba\u5458\u7ba1\u7406\u5c97\u4f4d\u6811\u67e5\u8be2\u5df2\u5173\u8054\u5c97\u4f4d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getPostTreeByNodeIsChosed(@RequestBody SysPost sysPost) {
        return ApiResponse.success((Object)this.sysPostService.getPostTreeByNodeIsChoose(sysPost));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5c97\u4f4d\u4fe1\u606f-\u89d2\u8272\u4fe1\u606f-\u62d3\u5c55\u89d2\u8272\u4fe1\u606f", notes="\u6dfb\u52a0\u5c97\u4f4d\u4fe1\u606f-\u89d2\u8272\u4fe1\u606f-\u62d3\u5c55\u89d2\u8272\u4fe1\u606f")
    @CheckPermission(value={"post:addPostAll"})
    @PostMapping(value={"/addPostAll"})
    @CacheEvict(value={"authorization_info", "resource_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u6dfb\u52a0\u5c97\u4f4d\u4fe1\u606f-\u89d2\u8272\u4fe1\u606f-\u62d3\u5c55\u89d2\u8272\u4fe1\u606f", eventDesc="\u6dfb\u52a0\u5c97\u4f4d\u4fe1\u606f-\u89d2\u8272\u4fe1\u606f-\u62d3\u5c55\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> addPostAll(@RequestBody SysPost sysPost) {
        return ApiResponse.success((String)this.sysPostService.addPostAll(sysPost));
    }

    @ApiOperation(value="\u5207\u6362\u5c97\u4f4d\u4fe1\u606f", notes="\u5207\u6362\u5c97\u4f4d\u4fe1\u606f")
    @CheckPermission(value={"post:changePost"})
    @PostMapping(value={"/changePost"})
    @AuditLog(moduleName="\u5207\u6362\u5c97\u4f4d\u4fe1\u606f", eventDesc="\u5207\u6362\u5c97\u4f4d\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<UserDetails> changePost(@RequestBody SysPost sysPost) {
        return ApiResponse.success((Object)this.sysPostService.changePost(sysPost.getPostId(), sysPost.getDeptId()));
    }

    @ApiOperation(value="\u6839\u636e\u4eba\u5458\u4fe1\u606f\u5207\u6362\u5c97\u4f4d", notes="\u6839\u636e\u4eba\u5458\u4fe1\u606f\u5207\u6362\u5c97\u4f4d")
    @GetMapping(value={"/changePostByDeptIdAndPostId"})
    @AuditLog(moduleName="\u6839\u636e\u4eba\u5458\u4fe1\u606f\u5207\u6362\u5c97\u4f4d", eventDesc="\u6839\u636e\u4eba\u5458\u4fe1\u606f\u5207\u6362\u5c97\u4f4d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<SecurityUser> changePostByDeptIdAndPostId(@RequestParam(value="deptId") String deptId, @RequestParam(value="postId") String postId, @RequestParam(value="originDeptId") String originDeptId, @RequestParam(value="originPostId") String originPostId, @RequestParam(value="mdmDeptId") String mdmDeptId, @RequestParam(value="mdmPostId") String mdmPostId) {
        return ApiResponse.success((Object)this.sysPostService.changePostBy(deptId, postId, originDeptId, originPostId, mdmDeptId, mdmPostId));
    }

    @ApiOperation(value="\u67e5\u8be2\u5207\u6362\u5c97\u4f4d\u5217\u8868", notes="\u67e5\u8be2\u5207\u6362\u5c97\u4f4d\u5217\u8868")
    @CheckPermission(value={"post:getChangePostList"})
    @GetMapping(value={"/getChangePostList"})
    @AuditLog(moduleName="\u67e5\u8be2\u5207\u6362\u5c97\u4f4d\u5217\u8868", eventDesc="\u67e5\u8be2\u5207\u6362\u5c97\u4f4d\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysUserPostVo>> getChangePostList() {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        return ApiResponse.success((Object)this.sysPostService.getChangePostList(securityUser.getUserId()));
    }

    @ApiOperation(value="\u6839\u636e\u7236\u7ea7\u5c97\u4f4did\u751f\u6210\u5c97\u4f4d\u7f16\u7801", notes="\u6839\u636e\u7236\u7ea7\u5c97\u4f4did\u751f\u6210\u5c97\u4f4d\u7f16\u7801")
    @CheckPermission(value={"post:getAddPostInfo"})
    @GetMapping(value={"/getAddPostInfo"})
    @AuditLog(moduleName="\u6839\u636e\u7236\u7ea7\u5c97\u4f4did\u751f\u6210\u5c97\u4f4d\u7f16\u7801", eventDesc="\u6839\u636e\u7236\u7ea7\u5c97\u4f4did\u751f\u6210\u5c97\u4f4d\u7f16\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<PostCodeVo> getAddPostInfo(Long postId) {
        PostCodeVo postCodeVo = new PostCodeVo();
        postCodeVo.setPostCode(this.sysPostService.getAddPostInfo(postId));
        return ApiResponse.success((Object)postCodeVo);
    }
}

