/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.application.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.application.dto.ApplicationCenterDto;
import com.jxdinfo.hussar.authorization.application.model.ApplicationGroupUser;
import com.jxdinfo.hussar.authorization.application.model.ApplicationUser;
import com.jxdinfo.hussar.authorization.application.service.IApplicationCenterService;
import com.jxdinfo.hussar.authorization.application.service.IApplicationGroupUserService;
import com.jxdinfo.hussar.authorization.application.service.IApplicationUserService;
import com.jxdinfo.hussar.authorization.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostConcurrently;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.authorization.post.service.UserPostConcurrentlyService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.post.application.dao.ApplicationUserMapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ApplicationCenterServiceImpl
implements IApplicationCenterService {
    @Resource
    private IApplicationUserService applicationUserService;
    @Resource
    private IApplicationGroupUserService applicationGroupUserService;
    @Resource
    private ApplicationUserMapper applicationUserMapper;
    @Resource
    private ISysPostService sysPostService;
    @Resource
    private UserPostConcurrentlyService userPostConcurrentlyService;

    public List<ApplicationCenterDto> getAllApplication() {
        Long positionId;
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        assert (currentUser != null);
        List roleIds = ConstantFactory.me().getRolesIdByShiroUser(currentUser);
        Long l = positionId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postCurrent")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postCurrent")));
        if (ToolUtil.isNotEmpty(positionId)) {
            Long mainPositionId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postMain")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postMain")));
            Long struId = null;
            if (!positionId.equals(mainPositionId)) {
                Long currentId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postCurrentId")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postCurrentId")));
                SysUserPostConcurrently userPostConcurrently = (SysUserPostConcurrently)this.userPostConcurrentlyService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUserPostConcurrently::getUpId, (Object)currentId));
                if (ToolUtil.isNotEmpty((Object)userPostConcurrently)) {
                    struId = userPostConcurrently.getUpStruId();
                }
            } else {
                struId = currentUser.getDeptId();
            }
            List roleId = this.sysPostService.getRoleIdByPostAndStru(positionId, struId);
            roleIds.addAll(roleId);
        }
        if (roleIds.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
            return this.applicationUserMapper.getAdminApplication(currentUser.getUserId());
        }
        return this.applicationUserMapper.getAllApplication(roleIds, positionId, currentUser.getUserId());
    }

    @DSTransactional
    public String saveAppCenter(List<ApplicationCenterDto> applicationCenterDtos) {
        boolean insertResult;
        boolean deleteResult;
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        assert (currentUser != null);
        Long userId = currentUser.getUserId();
        boolean hasExist = ToolUtil.isNotEmpty((Object)this.applicationGroupUserService.list((Wrapper)new LambdaQueryWrapper().eq(ApplicationGroupUser::getUserId, (Object)userId)));
        if (hasExist && !(deleteResult = this.applicationGroupUserService.remove((Wrapper)new LambdaQueryWrapper().eq(ApplicationGroupUser::getUserId, (Object)userId)))) {
            throw new BaseException("\u5220\u9664\u65e7\u914d\u7f6e\u5931\u8d25");
        }
        hasExist = ToolUtil.isNotEmpty((Object)this.applicationUserService.list((Wrapper)new LambdaQueryWrapper().eq(ApplicationUser::getUserId, (Object)userId)));
        if (hasExist && !(deleteResult = this.applicationUserService.remove((Wrapper)new LambdaQueryWrapper().eq(ApplicationUser::getUserId, (Object)userId)))) {
            throw new BaseException("\u5220\u9664\u65e7\u914d\u7f6e\u5931\u8d25");
        }
        ArrayList<ApplicationUser> applicationUsers = new ArrayList<ApplicationUser>();
        ArrayList<ApplicationGroupUser> applicationGroupUsers = new ArrayList<ApplicationGroupUser>();
        for (int i = 0; i < applicationCenterDtos.size(); ++i) {
            ApplicationGroupUser applicationGroupUser = new ApplicationGroupUser();
            applicationGroupUser.setGroupId(applicationCenterDtos.get(i).getGroupId());
            applicationGroupUser.setUserId(userId);
            applicationGroupUser.setSeq(i + 1);
            applicationGroupUsers.add(applicationGroupUser);
            List applicationVos = applicationCenterDtos.get(i).getApplications();
            for (int j = 0; j < applicationVos.size(); ++j) {
                ApplicationUser applicationUser = new ApplicationUser();
                applicationUser.setAppId(((ApplicationCenterDto.ApplicationVo)applicationVos.get(j)).getAppId());
                applicationUser.setUserId(userId);
                applicationUser.setSeq(j + 1);
                applicationUsers.add(applicationUser);
            }
        }
        if (ToolUtil.isNotEmpty(applicationUsers) && !(insertResult = this.applicationUserService.saveBatch(applicationUsers))) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
        }
        if (ToolUtil.isNotEmpty(applicationGroupUsers) && !(insertResult = this.applicationGroupUserService.saveBatch(applicationGroupUsers))) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
        }
        return "\u4fdd\u5b58\u6210\u529f";
    }

    public List<ApplicationCenterDto> getAppCenter() {
        Long positionId;
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        assert (currentUser != null);
        if (currentUser.getRolesList().contains(SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
            return this.applicationUserMapper.getAdminAppCenter(currentUser.getUserId());
        }
        List roleIds = ConstantFactory.me().getRolesIdByShiroUser(currentUser);
        Long l = positionId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postCurrent")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postCurrent")));
        if (ToolUtil.isNotEmpty(positionId)) {
            Long mainPositionId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postMain")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postMain")));
            Long struId = null;
            if (!positionId.equals(mainPositionId)) {
                Long currentId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postCurrentId")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postCurrentId")));
                SysUserPostConcurrently userPostConcurrently = (SysUserPostConcurrently)this.userPostConcurrentlyService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUserPostConcurrently::getUpId, (Object)currentId));
                if (ToolUtil.isNotEmpty((Object)userPostConcurrently)) {
                    struId = userPostConcurrently.getUpStruId();
                }
            } else {
                struId = currentUser.getDeptId();
            }
            List roleId = this.sysPostService.getRoleIdByPostAndStru(positionId, struId);
            roleIds.addAll(roleId);
        }
        if (HussarUtils.isNotEmpty((Object)currentUser.getExtendUserMap("postCurrent"))) {
            return this.applicationUserMapper.getAppCenter(currentUser.getUserId(), Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postCurrent"))), roleIds);
        }
        return this.applicationUserMapper.getAppCenter(currentUser.getUserId(), null, roleIds);
    }
}

