/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.application.controller;

import com.jxdinfo.hussar.authorization.application.dto.ApplicationGroupDto;
import com.jxdinfo.hussar.authorization.application.dto.SeqDto;
import com.jxdinfo.hussar.authorization.application.model.SysApplicationGroup;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationGroupService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e94\u7528\u6a21\u5757\u7ef4\u62a4"})
@RestController
@RequestMapping(value={"/applicationGroup"})
public class SysApplicationGroupManageController
extends HussarBaseController<SysApplicationGroup, ISysApplicationGroupService> {
    @Resource
    private ISysApplicationGroupService sysApplicationGroupService;

    @ApiOperation(value="\u65b0\u589e\u6a21\u5757")
    @PostMapping(value={"/add"})
    @AuditLog(moduleName="\u5e94\u7528\u6a21\u5757\u7ef4\u62a4", eventDesc="\u65b0\u589e\u5e94\u7528\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> add(@ApiParam(value="\u6a21\u5757\u4fe1\u606f\u6570\u636e") @RequestBody ApplicationGroupDto applicationGroupDto) {
        return ApiResponse.success((String)this.sysApplicationGroupService.add(applicationGroupDto));
    }

    @ApiOperation(value="\u4fee\u6539\u6a21\u5757")
    @PostMapping(value={"/edit"})
    @AuditLog(moduleName="\u5e94\u7528\u6a21\u5757\u7ef4\u62a4", eventDesc="\u4fee\u6539\u5e94\u7528\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> edit(@ApiParam(value="\u6a21\u5757\u4fe1\u606f\u6570\u636e") @RequestBody ApplicationGroupDto applicationGroupDto) {
        return ApiResponse.success((String)this.sysApplicationGroupService.edit(applicationGroupDto));
    }

    @ApiOperation(value="\u5220\u9664\u6a21\u5757")
    @PostMapping(value={"/delete"})
    @AuditLog(moduleName="\u5e94\u7528\u6a21\u5757\u7ef4\u62a4", eventDesc="\u5220\u9664\u5e94\u7528\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> delete(@ApiParam(value="\u6a21\u5757id") @RequestBody Long groupId) {
        return ApiResponse.success((String)this.sysApplicationGroupService.delete(groupId));
    }

    @ApiOperation(value="\u67e5\u8be2\u6a21\u5757\u8be6\u7ec6")
    @GetMapping(value={"/search"})
    @AuditLog(moduleName="\u5e94\u7528\u6a21\u5757\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u5e94\u7528\u6a21\u5757\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysApplicationGroup> search(@ApiParam(value="\u6a21\u5757id") @RequestParam Long groupId) {
        return ApiResponse.success((Object)this.sysApplicationGroupService.getById((Serializable)groupId));
    }

    @ApiOperation(value="\u67e5\u8be2\u6a21\u5757\u4e0b\u7684\u5b50\u6a21\u5757")
    @GetMapping(value={"/getChildrenGroup"})
    @AuditLog(moduleName="\u5e94\u7528\u6a21\u5757\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u6a21\u5757\u4e0b\u7684\u5b50\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getChildrenGroup(@ApiParam(value="\u6a21\u5757Id") @RequestParam Long groupId, @ApiParam(value="\u6a21\u5757\u540d") @RequestParam String groupName) {
        return ApiResponse.success((Object)this.sysApplicationGroupService.getChildrenGroup(groupId, groupName));
    }

    @ApiOperation(value="\u4fdd\u5b58\u5b50\u6a21\u5757\u6392\u5e8f")
    @PostMapping(value={"/saveSeq"})
    @AuditLog(moduleName="\u5e94\u7528\u6a21\u5757\u7ef4\u62a4", eventDesc="\u5b50\u6a21\u5757\u6392\u5e8f\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> saveSeq(@ApiParam(value="\u6392\u5e8f\u4fe1\u606f") @RequestBody List<SeqDto> seqDtoList) {
        return ApiResponse.success((String)this.sysApplicationGroupService.saveSeq(seqDtoList));
    }

    @GetMapping(value={"/getApplicationTree"})
    @ApiOperation(value="\u67e5\u8be2\u6a21\u5757\u6811", notes="\u83b7\u53d6\u6a21\u5757\u6811")
    @AuditLog(moduleName="\u83b7\u53d6\u6a21\u5757\u6811", eventDesc="\u83b7\u53d6\u6a21\u5757\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getApplicationTree() {
        return ApiResponse.success((Object)this.sysApplicationGroupService.getApplicationTree());
    }
}

