/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.post.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationPostService;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.dto.SysPostOut;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.model.SysRolePost;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostConcurrently;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostMain;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.authorization.post.service.ISysRolePostService;
import com.jxdinfo.hussar.authorization.post.service.UserPostConcurrentlyService;
import com.jxdinfo.hussar.authorization.post.service.UserPostMainService;
import com.jxdinfo.hussar.authorization.post.vo.SysUserPostVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.Convert;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.post.post.dao.SysPostMapper;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ISysPostServiceImpl
extends HussarServiceImpl<SysPostMapper, SysPost>
implements ISysPostService {
    @Resource
    private ISysRolePostService sysRolePostService;
    @Resource
    private ISysStruService sysStruService;
    private SysOrganVo organ;
    private String organName;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private UserPostConcurrentlyService userPostConcurrentlyService;
    @Resource
    private UserPostMainService userPostMainService;
    @Autowired
    private ISysApplicationPostService sysApplicationPostService;
    @Resource
    private ISysStruService iSysStruService;
    @Autowired
    private ISysPostService sysPostService;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private ISysUsersService usersService;
    private static final Logger logger = LoggerFactory.getLogger(ISysPostServiceImpl.class);

    public IPage<SysPost> getPostList(SysPost sysPost, Page<SysPost> page) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        if (HussarUtils.isNotBlank((CharSequence)sysPost.getPostNo())) {
            qw.like(SysPost::getPostNo, (Object)sysPost.getPostNo());
        }
        if (HussarUtils.isNotBlank((CharSequence)sysPost.getPostName())) {
            qw.like(SysPost::getPostName, (Object)sysPost.getPostName());
        }
        if (HussarUtils.isNotBlank((CharSequence)sysPost.getPostType())) {
            qw.eq(SysPost::getPostType, (Object)sysPost.getPostType());
        }
        if (sysPost.getPostParentNo() != null) {
            qw.eq(SysPost::getPostParentNo, (Object)sysPost.getPostParentNo());
        }
        return this.page((IPage)page, (Wrapper)qw);
    }

    public String addPost(SysPost sysPost) {
        if (sysPost == null) {
            return "\u4fdd\u5b58\u5931\u8d25";
        }
        boolean bl = this.save((BaseEntity)sysPost);
        if (bl) {
            return "\u4fdd\u5b58\u6210\u529f";
        }
        return "\u4fdd\u5b58\u5931\u8d25";
    }

    public String editPost(SysPost sysPost) {
        if (sysPost == null || sysPost.getPostId() == null) {
            return "\u4fee\u6539\u5931\u8d25";
        }
        boolean bl = this.updateById((BaseEntity)sysPost);
        if (bl) {
            return "\u4fee\u6539\u6210\u529f";
        }
        return "\u4fee\u6539\u5931\u8d25";
    }

    public String delPost(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return "\u5220\u9664\u5931\u8d25\uff0c\u672a\u627e\u5230\u5220\u9664\u6570\u636e";
        }
        List<String> result = Arrays.asList(ids.split(","));
        for (String id : result) {
            List childList = this.list((Wrapper)new LambdaQueryWrapper().eq(SysPost::getPostParentNo, (Object)id));
            if (HussarUtils.isNotEmpty((Object)childList)) {
                SysPost post = (SysPost)this.getById((Serializable)((Object)id));
                return "\u5c97\u4f4d" + post.getPostName() + "\u4e0b\u6709\u5176\u4ed6\u5c97\u4f4d\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664";
            }
            List mainList = this.userPostMainService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserPostMain::getUpPostId, (Object)id));
            if (HussarUtils.isNotEmpty((Object)mainList)) {
                SysPost post = (SysPost)this.getById((Serializable)((Object)id));
                return "\u5c97\u4f4d" + post.getPostName() + "\u6b63\u5728\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664";
            }
            List concurrentlyList = this.userPostConcurrentlyService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserPostConcurrently::getUpPostId, (Object)id));
            if (!HussarUtils.isNotEmpty((Object)concurrentlyList)) continue;
            SysPost post = (SysPost)this.getById((Serializable)((Object)id));
            return "\u5c97\u4f4d" + post.getPostName() + "\u6b63\u5728\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664";
        }
        boolean bl = this.removeByIds(result);
        if (bl) {
            return "\u5220\u9664\u6210\u529f";
        }
        return "\u5220\u9664\u5931\u8d25";
    }

    public List<JSTreeModel> getPostTree(SysPost sysPost) {
        List listTree = TreeModelUtils.merge(((SysPostMapper)this.baseMapper).getPostTree(sysPost));
        JSTreeModel root = new JSTreeModel();
        root.setId(Long.valueOf(-1L));
        root.setCode(null);
        root.setText("\u5c97\u4f4d");
        root.setParent(null);
        root.setType("-1");
        root.setImgUrl("tree-com");
        root.setChildrenList(listTree);
        ArrayList<JSTreeModel> resultTree = new ArrayList<JSTreeModel>();
        resultTree.add(root);
        return resultTree;
    }

    public List<SysPost> getPostTreeByNode(SysPost sysPost) {
        List<SysPost> list = ((SysPostMapper)this.baseMapper).getPostTreeByNode();
        List<SysPost> resultList = this.buildTree(list, sysPost.getPostType());
        SysPost root = new SysPost();
        root.setPostId(Long.valueOf(-1L));
        root.setPostNo(null);
        root.setPostName("\u5c97\u4f4d");
        root.setPostParentNo(null);
        root.setImgUrl("tree-com");
        root.setChildrenList(resultList);
        ArrayList<SysPost> resultTree = new ArrayList<SysPost>();
        resultTree.add(root);
        return resultTree;
    }

    public List<SysPost> buildTree(List<SysPost> all, String postType) {
        if (CollectionUtils.isEmpty(all)) {
            return Lists.newArrayList();
        }
        List<SysPost> parentList = all.stream().filter(e -> e.getPostType().equals(postType) && "-1".equals(e.getPostParentNo())).collect(Collectors.toList());
        this.getSubList(parentList, all);
        return parentList;
    }

    private void getSubList(List<SysPost> parentList, List<SysPost> all) {
        parentList.forEach(e -> {
            List<SysPost> subList = all.stream().filter(o -> o.getPostParentNo().equals(String.valueOf(e.getPostId()))).collect(Collectors.toList());
            e.setChildrenList(subList);
            if (!CollectionUtils.isEmpty(subList)) {
                this.getSubList(subList, all);
            }
        });
    }

    public List<JSTreeModel> getPostTreeByNodeIsChoose(SysPost sysPost) {
        List listTree = TreeModelUtils.merge(((SysPostMapper)this.baseMapper).getPostTreeInStru(sysPost.getOpStruId()));
        JSTreeModel root = new JSTreeModel();
        root.setId(Long.valueOf(-1L));
        root.setCode(null);
        root.setText("\u5c97\u4f4d");
        root.setParent(null);
        root.setType("-1");
        root.setImgUrl("tree-com");
        root.setChildrenList(listTree);
        ArrayList<JSTreeModel> resultTree = new ArrayList<JSTreeModel>();
        resultTree.add(root);
        return resultTree;
    }

    @HussarTransactional
    public String addPostAll(SysPost sysPost) {
        try {
            if (sysPost == null) {
                return "\u4fdd\u5b58\u5931\u8d25";
            }
            String postName = sysPost.getPostName();
            String postStatus = sysPost.getPostStatus();
            List rolePostList = sysPost.getRolePostList();
            if (HussarUtils.isNotEmpty((Object)sysPost.getPostId())) {
                LambdaQueryWrapper qw1 = new LambdaQueryWrapper();
                qw1.like(SysPost::getPostId, (Object)sysPost.getPostId());
                sysPost = (SysPost)((SysPostMapper)this.baseMapper).selectOne((Wrapper)qw1);
            }
            sysPost.setPostStatus(postStatus);
            sysPost.setPostName(postName);
            this.sysPostService.saveOrUpdate((Object)sysPost);
            LambdaQueryWrapper qw = new LambdaQueryWrapper();
            qw.like(SysRolePost::getRpPostId, (Object)sysPost.getPostId());
            this.sysRolePostService.remove((Wrapper)qw);
            for (SysRolePost sysRolePost : rolePostList) {
                sysRolePost.setRpPostId(sysPost.getPostId());
                sysRolePost.setOutPostId(sysPost.getOutPostId());
                sysRolePost.setOutOriginId(sysPost.getOutOriginId());
            }
            this.sysRolePostService.saveOrUpdateBatch((Collection)rolePostList);
            return "\u4fdd\u5b58\u6210\u529f";
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5b58\u5c97\u4f4d\u4fe1\u606f\u51fa\u9519\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
            return "\u4fdd\u5b58\u5c97\u4f4d\u4fe1\u606f\u51fa\u9519";
        }
    }

    public List<Long> getRoleIdByUserId(Long userId) {
        List<Long> list = ((SysPostMapper)this.baseMapper).getRoleIdByUserId(userId);
        list = list.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return list;
    }

    public List<Long> getRoleIdByPostAndStru(Long postId, Long struId) {
        List<Long> list = new ArrayList<Long>();
        list = this.getStruUp(list, struId);
        list.add(struId);
        return ((SysPostMapper)this.baseMapper).getRoleIdByPostAndStru(postId, list);
    }

    public List<Long> getStruUp(List<Long> list, Long struId) {
        Long parentId = ((SysPostMapper)this.baseMapper).getStruUp(struId);
        if (HussarUtils.isNotEmpty((Object)parentId) && parentId != 11L) {
            list.add(parentId);
            this.getStruUp(list, parentId);
        }
        return list;
    }

    public UserDetails changePost(Long postId, Long deptId) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        UserDetails loginUserDetails = HussarSecurityUtils.getLoginUserDetails();
        if (HussarUtils.isEmpty((Object)loginUserDetails)) {
            return null;
        }
        SecurityUser securityUser = (SecurityUser)HussarCacheUtil.get((String)"login_user_info", (Object)loginUserDetails.getAccessToken());
        if (postId.compareTo(Convert.toLong((Object)shiroUser.getExtendUserMap("postMainId"))) == 0) {
            SysOrganVo sysOrganVo;
            LambdaQueryWrapper sysUserPostMainQueryWrapper = new LambdaQueryWrapper();
            sysUserPostMainQueryWrapper.eq(SysUserPostMain::getUpId, (Object)postId);
            SysUserPostMain sysUserPostMain = (SysUserPostMain)this.userPostMainService.getOne((Wrapper)sysUserPostMainQueryWrapper);
            if (HussarUtils.isNotEmpty((Object)sysUserPostMain)) {
                HussarSecurityUtils.putSessionExtend((String)"postCurrent", (Object)sysUserPostMain.getUpPostId());
                HussarSecurityUtils.putSessionExtend((String)"postCurrentId", (Object)sysUserPostMain.getUpId());
                HussarSecurityUtils.putSessionExtend((String)"deptId", (Object)deptId);
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("postCurrent", (Object)sysUserPostMain.getUpPostId());
                    securityUser.addExtendUserMap("postCurrentId", (Object)sysUserPostMain.getUpId());
                    securityUser.addExtendUserMap("deptId", (Object)deptId);
                    SysOrgan sysOrgan = this.iSysStruService.getOrganInfoByDeparmentId(deptId);
                    securityUser.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                    this.buildExtendUserMap(securityUser);
                }
            }
            if (!HussarUtils.isNull((Object)(sysOrganVo = this.sysStruService.getOrgInfoByOrgId(deptId)))) {
                HussarSecurityUtils.putSessionExtend((String)"deptName", (Object)sysOrganVo.getOrganName());
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                }
            }
            if (HussarUtils.isNotEmpty((Object)securityUser)) {
                HussarCacheUtil.put((String)"login_user_info", (Object)loginUserDetails.getAccessToken(), (Object)securityUser, (long)1800L);
            }
        } else {
            SysOrganVo sysOrganVo;
            LambdaQueryWrapper sysUserPostConcurrentlyQueryWrapper = new LambdaQueryWrapper();
            sysUserPostConcurrentlyQueryWrapper.eq(SysUserPostConcurrently::getUpId, (Object)postId);
            SysUserPostConcurrently sysUserPostConcurrently = (SysUserPostConcurrently)this.userPostConcurrentlyService.getOne((Wrapper)sysUserPostConcurrentlyQueryWrapper);
            if (HussarUtils.isNotEmpty((Object)sysUserPostConcurrently)) {
                HussarSecurityUtils.putSessionExtend((String)"postCurrent", (Object)sysUserPostConcurrently.getUpPostId());
                HussarSecurityUtils.putSessionExtend((String)"postCurrentId", (Object)sysUserPostConcurrently.getUpId());
                HussarSecurityUtils.putSessionExtend((String)"deptId", (Object)deptId);
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("postCurrent", (Object)sysUserPostConcurrently.getUpPostId());
                    securityUser.addExtendUserMap("postCurrentId", (Object)sysUserPostConcurrently.getUpId());
                    securityUser.addExtendUserMap("deptId", (Object)deptId);
                    SysOrgan sysOrgan = this.iSysStruService.getOrganInfoByDeparmentId(deptId);
                    securityUser.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
                    this.buildExtendUserMap(securityUser);
                }
            }
            if (!HussarUtils.isNull((Object)(sysOrganVo = this.sysStruService.getOrgInfoByOrgId(deptId)))) {
                HussarSecurityUtils.putSessionExtend((String)"deptName", (Object)sysOrganVo.getOrganName());
                if (HussarUtils.isNotEmpty((Object)securityUser)) {
                    securityUser.addExtendUserMap("deptName", (Object)sysOrganVo.getOrganName());
                }
            }
            if (HussarUtils.isNotEmpty((Object)securityUser)) {
                HussarCacheUtil.put((String)"login_user_info", (Object)loginUserDetails.getAccessToken(), (Object)securityUser, (long)1800L);
            }
        }
        return HussarSecurityUtils.getLoginUserDetails();
    }

    private void buildExtendUserMap(SecurityUser userDetails) {
        SysStru corporation = (SysStru)this.iSysStruService.getById((Serializable)((Object)String.valueOf(userDetails.getExtendUserMap().get("corporationId"))));
        SysStru dept = (SysStru)this.iSysStruService.getById((Serializable)((Object)String.valueOf(userDetails.getExtendUserMap().get("deptId"))));
        if (HussarUtils.isNotEmpty((Object)corporation)) {
            userDetails.addExtendUserMap("outOriginOrganId", (Object)corporation.getOutStruId());
            userDetails.addExtendUserMap("outOriginOrganType", (Object)corporation.getStruType());
        }
        if (HussarUtils.isNotEmpty((Object)dept)) {
            userDetails.addExtendUserMap("outOriginDeptId", (Object)dept.getOutStruId());
            userDetails.addExtendUserMap("outOriginDeptType", (Object)dept.getStruType());
        }
        Optional.ofNullable(this.sysPostService.getById((Serializable)((Object)String.valueOf(userDetails.getExtendUserMap().get("postCurrent"))))).ifPresent(p -> userDetails.addExtendUserMap("outOriginPostId", (Object)p.getOutPostId()));
    }

    public List<SysUserPostVo> getAllPostByUserId(Long userId) {
        SysUserPostVo sysUserPostVo = ((SysPostMapper)this.baseMapper).getMainPostByUserId(userId);
        List<SysUserPostVo> list = ((SysPostMapper)this.baseMapper).getConPostByUserId(userId);
        if (sysUserPostVo != null) {
            list.add(0, sysUserPostVo);
            Long sturId = ((SysPostMapper)this.baseMapper).getStruIdByUserId(sysUserPostVo.getUpUserId());
            sysUserPostVo.setUpStruId(sturId);
        }
        return list;
    }

    public List<SysUserPostVo> getChangePostList(Long userId) {
        List<SysUserPostVo> list = this.getAllPostByUserId(userId);
        for (SysUserPostVo sysUserPostVo : list) {
            String afterSub;
            String name;
            if (sysUserPostVo.getUpStruId() == null || !HussarUtils.isNotEmpty((Object)(name = ((SysStru)this.sysStruService.getOne((Wrapper)new LambdaUpdateWrapper().eq(SysStru::getId, (Object)sysUserPostVo.getUpStruId()))).getPathName()))) continue;
            String newName = name.replace(">>", "-");
            logger.info("newName: " + newName);
            if (newName.contains("-")) {
                String beforSub = newName.substring(0, newName.indexOf("-"));
                afterSub = newName.substring(beforSub.length() + 1);
                if (afterSub.contains(">")) {
                    String afterSubBefore = afterSub.substring(0, afterSub.indexOf(">"));
                    afterSub = afterSub.substring(afterSubBefore.length() + 1);
                }
            } else {
                afterSub = newName;
            }
            sysUserPostVo.setPostName(afterSub + sysUserPostVo.getPostName());
            this.organ = null;
            this.organName = null;
        }
        return list;
    }

    public String getAddPostInfo(Long postId) {
        SysPost postInfo = (SysPost)((SysPostMapper)this.baseMapper).selectById(postId);
        String postParentCode = "";
        if (ToolUtil.isNotEmpty((Object)postInfo) && ToolUtil.isEmpty((Object)(postParentCode = postInfo.getPostNo()))) {
            postParentCode = "";
        }
        String businessName = "POST_CODE";
        String tableName = "SYS_POST";
        String currentCode = this.sysIdtableService.getCurrentCode(businessName, tableName, postParentCode);
        return currentCode;
    }

    public List<SysPostOut> existPost() {
        return ((SysPostMapper)this.baseMapper).existPost();
    }

    public List<SysOrganType> getOrgTypeOption() {
        List<SysOrganType> list = this.sysOrganTypeMapper.getOrgTypeOption();
        list = list.stream().filter(v -> !v.getTypeName().equals("\u4eba\u5458")).collect(Collectors.toList());
        return list;
    }

    public List<SysStruRule> getOrgRoleByCode(String orgType, String isRoot) {
        return ((SysPostMapper)this.baseMapper).getOrgRoleByCode(orgType, isRoot);
    }
}

