/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.application.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.application.dto.ApplicationRoleDto;
import com.jxdinfo.hussar.authorization.application.dto.RoleApplicationDto;
import com.jxdinfo.hussar.authorization.application.model.SysApplicationRoles;
import com.jxdinfo.hussar.authorization.application.model.SysApplications;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationGroupService;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationRolesService;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.post.application.dao.ApplicationRoleMapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysApplicationRolesImpl
extends ServiceImpl<ApplicationRoleMapper, SysApplicationRoles>
implements ISysApplicationRolesService {
    @Resource
    ApplicationRoleMapper applicationRoleMapper;
    @Resource
    ISysApplicationGroupService sysApplicationGroupService;
    @Resource
    private ISysApplicationService sysApplicationService;

    @DSTransactional
    public void addApplicationAndRoles(ApplicationRoleDto applicationRoleDto) {
        Long appId = applicationRoleDto.getAppId();
        String roleIds = applicationRoleDto.getRoleIds();
        if (ToolUtil.isEmpty((Object)appId)) {
            throw new RuntimeException("\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] ids = roleIds.split(",");
        this.applicationRoleMapper.deleteRole(appId);
        ArrayList<SysApplicationRoles> applicationRolesList = new ArrayList<SysApplicationRoles>();
        for (String rolesId : ids) {
            if (ToolUtil.isEmpty((Object)rolesId)) continue;
            SysApplicationRoles sysApplicationRoles = new SysApplicationRoles();
            sysApplicationRoles.setAppId(appId);
            sysApplicationRoles.setRoleId(Long.valueOf(rolesId));
            applicationRolesList.add(sysApplicationRoles);
        }
        if (ToolUtil.isNotEmpty(applicationRolesList)) {
            super.saveBatch(applicationRolesList, applicationRolesList.size());
        }
    }

    public List<JSTreeModel> getApplicationRoleTree(Long appId) {
        List<Long> roleIds = this.applicationRoleMapper.getRoleIdByAppId(appId);
        List<JSTreeModel> result = this.applicationRoleMapper.allRoleTree();
        if (ToolUtil.isEmpty(roleIds)) {
            return TreeModelUtils.merge(this.getRoleTree(result));
        }
        List<JSTreeModel> treeModels = this.getRoleTree(result);
        if (ToolUtil.isNotEmpty((Object)appId)) {
            block0: for (JSTreeModel jsTreeModel : treeModels) {
                for (Long id : roleIds) {
                    if (ToolUtil.equals((Object)jsTreeModel.getId(), (Object)id)) {
                        jsTreeModel.setState(true, true, true);
                        continue block0;
                    }
                    jsTreeModel.setState(false, false, true);
                }
            }
        }
        return TreeModelUtils.merge(treeModels);
    }

    @DSTransactional
    public void addRoleAndApplications(RoleApplicationDto roleApplicationDto) {
        Long roleId = roleApplicationDto.getRoleId();
        String appIds = roleApplicationDto.getAppIds();
        if (ToolUtil.isEmpty((Object)roleId)) {
            throw new BaseException("\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.applicationRoleMapper.deleteRoleAndApplication(roleId);
        if (ToolUtil.isEmpty((Object)appIds)) {
            return;
        }
        String[] ids = appIds.split(",");
        ArrayList<Long> appIdList = new ArrayList<Long>();
        for (String id : ids) {
            if (!ToolUtil.isNotEmpty((Object)id)) continue;
            appIdList.add(Long.valueOf(id));
        }
        List appList = this.sysApplicationService.listByIds(appIdList);
        ArrayList<SysApplicationRoles> sysApplicationRoles = new ArrayList<SysApplicationRoles>();
        for (SysApplications app : appList) {
            if (!ToolUtil.isNotEmpty((Object)app)) continue;
            SysApplicationRoles applicationRoles = new SysApplicationRoles();
            applicationRoles.setRoleId(roleId);
            applicationRoles.setAppId(app.getAppId());
            sysApplicationRoles.add(applicationRoles);
        }
        if (ToolUtil.isNotEmpty(sysApplicationRoles)) {
            super.saveBatch(sysApplicationRoles);
        }
    }

    public List<JSTreeModel> getRoleApplicationTree(Long roleId) {
        List applicationGroup = this.sysApplicationGroupService.getApplicationAndGroupTree();
        List<Long> appIdList = this.applicationRoleMapper.getAppIdByRoleId(roleId);
        if (ToolUtil.isEmpty(appIdList)) {
            return TreeModelUtils.merge(this.getApplicationTree(applicationGroup));
        }
        List<JSTreeModel> treeModels = this.getApplicationTree(applicationGroup);
        if (ToolUtil.isNotEmpty((Object)roleId)) {
            block0: for (JSTreeModel jsTreeModel : treeModels) {
                for (Long id : appIdList) {
                    if (ToolUtil.equals((Object)jsTreeModel.getId(), (Object)id)) {
                        jsTreeModel.setState(true, true, true);
                        continue block0;
                    }
                    jsTreeModel.setState(false, false, true);
                }
            }
        }
        return TreeModelUtils.merge(treeModels);
    }

    private List<JSTreeModel> getRoleTree(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursiveRoleTree(list, result, 0L);
        JSTreeModel model = new JSTreeModel();
        model.setId(Constants.RES_NODE_ID);
        model.setCode("GROUP");
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setText("\u89d2\u8272\u6811");
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    private List<JSTreeModel> getApplicationTree(List<JSTreeModel> list) {
        List<JSTreeModel> result = list;
        JSTreeModel model = new JSTreeModel();
        model.setId(Constants.RES_NODE_ID);
        model.setCode("GROUP");
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setText("\u5e94\u7528\u6a21\u5757\u6811");
        model.setLabel("\u5e94\u7528\u6a21\u5757\u6811");
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    private void recursiveRoleTree(List<JSTreeModel> list, List<JSTreeModel> result, Long parentId) {
        Long newParentId = parentId;
        for (int i = 0; i < list.size(); ++i) {
            JSTreeModel map = list.get(i);
            if (!"ROLE".equals(map.getCode()) && !newParentId.equals(map.getId())) continue;
            newParentId = map.getParent();
            result.add(map);
            list.remove(map);
            --i;
            this.recursiveRoleTree(list, result, newParentId);
        }
    }
}

