/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.application.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.authorization.application.dto.ApplicationDto;
import com.jxdinfo.hussar.authorization.application.dto.ApplicationPostDto;
import com.jxdinfo.hussar.authorization.application.dto.ApplicationRoleDto;
import com.jxdinfo.hussar.authorization.application.dto.RoleApplicationDto;
import com.jxdinfo.hussar.authorization.application.dto.SeqDto;
import com.jxdinfo.hussar.authorization.application.model.SysApplicationPost;
import com.jxdinfo.hussar.authorization.application.model.SysApplications;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationPostService;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationRolesService;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.application.vo.ApplicationResourceVo;
import com.jxdinfo.hussar.authorization.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e94\u7528\u7ef4\u62a4"})
@RestController
@RequestMapping(value={"/application"})
public class SysApplicationManageController
extends HussarBaseController<SysApplications, ISysApplicationService> {
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    ISysApplicationRolesService sysApplicationRolesService;
    @Resource
    ISysApplicationPostService sysApplicationPostService;

    @ApiOperation(value="\u65b0\u589e\u5e94\u7528")
    @PostMapping(value={"/add"})
    @AuditLog(moduleName="\u5e94\u7528\u7ef4\u62a4", eventDesc="\u65b0\u589e\u5e94\u7528", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> add(@ApiParam(value="\u5e94\u7528\u4fe1\u606f\u6570\u636e") @RequestBody ApplicationDto applicationDto) {
        return ApiResponse.success((Object)this.sysApplicationService.add(applicationDto));
    }

    @ApiOperation(value="\u4fee\u6539\u5e94\u7528")
    @PostMapping(value={"/edit"})
    @AuditLog(moduleName="\u5e94\u7528\u7ef4\u62a4", eventDesc="\u4fee\u6539\u5e94\u7528", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> edit(@ApiParam(value="\u5e94\u7528\u4fe1\u606f\u6570\u636e") @RequestBody ApplicationDto applicationDto) {
        return ApiResponse.success((String)this.sysApplicationService.edit(applicationDto));
    }

    @ApiOperation(value="\u5220\u9664\u5e94\u7528")
    @PostMapping(value={"/delete"})
    @AuditLog(moduleName="\u5e94\u7528\u7ef4\u62a4", eventDesc="\u5220\u9664\u5e94\u7528", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> delete(@ApiParam(value="\u5e94\u7528id") @RequestBody Long appId) {
        return ApiResponse.success((String)this.sysApplicationService.delete(appId));
    }

    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u8be6\u60c5")
    @GetMapping(value={"/search"})
    @AuditLog(moduleName="\u5e94\u7528\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u5e94\u7528\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysApplicationVo> search(@ApiParam(value="\u5e94\u7528id") @RequestParam Long appId) {
        return ApiResponse.success((Object)this.sysApplicationService.search(appId));
    }

    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u5217\u8868")
    @GetMapping(value={"/select"})
    @AuditLog(moduleName="\u5e94\u7528\u67e5\u770b", eventDesc="\u67e5\u8be2\u5e94\u7528\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ApplicationResourceVo>> selectApplication(@ApiParam(value="\u5e94\u7528\u7c7b\u578b") String types) {
        return ApiResponse.success((Object)this.sysApplicationService.selectApplication(types));
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u5757ID\u67e5\u8be2\u5e94\u7528")
    @GetMapping(value={"/getApplicationByGroupId"})
    @AuditLog(moduleName="\u5e94\u7528\u7ef4\u62a4", eventDesc="\u6839\u636eID\u83b7\u53d6\u5e94\u7528", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getApplicationByGroupId(@ApiParam(value="\u6a21\u5757id") @RequestParam Long groupId, @ApiParam(value="\u6a21\u5757\u540d") @RequestParam String groupName) {
        return ApiResponse.success((Object)this.sysApplicationService.getApplicationByGroupId(groupId, groupName));
    }

    @ApiOperation(value="\u4fdd\u5b58\u5e94\u7528\u6392\u5e8f")
    @PostMapping(value={"/saveSeq"})
    @AuditLog(moduleName="\u5e94\u7528\u7ef4\u62a4", eventDesc="\u5e94\u7528\u6392\u5e8f\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> saveSeq(@ApiParam(value="\u6392\u5e8f\u4fe1\u606f") @RequestBody List<SeqDto> seqDtoList) {
        return ApiResponse.success((String)this.sysApplicationService.saveSeq(seqDtoList));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5e94\u7528\u548c\u89d2\u8272\u7684\u5173\u8054\u5173\u7cfb")
    @PostMapping(value={"/addApplicationAndRoles"})
    @AuditLog(moduleName="\u5e94\u7528\u89d2\u8272\u5173\u8054", eventDesc="\u6dfb\u52a0\u5e94\u7528\u89d2\u8272\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> addApplicationAndRoles(@ApiParam(value="\u5173\u8054\u4fe1\u606f") @RequestBody ApplicationRoleDto applicationRoleDto) {
        this.sysApplicationRolesService.addApplicationAndRoles(applicationRoleDto);
        return ApiResponse.success((String)"\u5e94\u7528\u89d2\u8272\u5173\u8054\u6210\u529f");
    }

    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272\u548c\u5e94\u7528\u7684\u5173\u8054\u5173\u7cfb")
    @PostMapping(value={"/addRoleAndApplications"})
    @AuditLog(moduleName="\u89d2\u8272\u5e94\u7528\u5173\u8054", eventDesc="\u6dfb\u52a0\u89d2\u8272\u5e94\u7528\u5173\u8054", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> addRoleAndApplications(@ApiParam(value="\u5173\u8054\u4fe1\u606f") @RequestBody RoleApplicationDto roleApplicationDto) {
        this.sysApplicationRolesService.addRoleAndApplications(roleApplicationDto);
        return ApiResponse.success((String)"\u5e94\u7528\u89d2\u8272\u5173\u8054\u6210\u529f");
    }

    @ApiOperation(value="\u6dfb\u52a0\u5e94\u7528\u548c\u5c97\u4f4d\u7684\u5173\u8054\u5173\u7cfb")
    @PostMapping(value={"/addApplicationAndPosts"})
    @AuditLog(moduleName="\u5e94\u7528\u5c97\u4f4d\u5173\u8054", eventDesc="\u6dfb\u52a0\u5e94\u7528\u5c97\u4f4d\u5173\u8054", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> addApplicationAndPost(@ApiParam(value="\u5173\u8054\u5173\u7cfb") @RequestBody ApplicationPostDto applicationPostDto) {
        this.sysApplicationPostService.addApplicationAndPosts(applicationPostDto);
        return ApiResponse.success((String)"\u6dfb\u52a0\u5e94\u7528\u5c97\u4f4d\u5173\u8054\u6210\u529f");
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e94\u7528")
    @GetMapping(value={"/getApplicationByPage"})
    @AuditLog(moduleName="\u5206\u9875\u83b7\u53d6\u5e94\u7528\u4fe1\u606f", eventDesc="\u5206\u9875\u83b7\u53d6\u5e94\u7528", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<SysApplicationVo>> getApplicationByPage(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<SysApplicationVo> page, @ApiParam(value="\u5e94\u7528\u5bf9\u8c61") SysApplications sysApplication) {
        return ApiResponse.success((Object)this.sysApplicationService.getApplicationByPage(page, sysApplication));
    }

    @ApiOperation(value="\u6839\u636e\u5e94\u7528\u7c7b\u522b\u548c\u540d\u79f0\u83b7\u53d6\u5e94\u7528")
    @GetMapping(value={"/getApplicatioByTypesAndName"})
    @AuditLog(moduleName="\u6839\u636e\u5e94\u7528\u7c7b\u522b\u548c\u540d\u79f0\u83b7\u53d6\u5e94\u7528", eventDesc="\u67e5\u8be2\u5e94\u7528", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysApplicationVo>> getApplicationByTypesAndName(@ApiParam(value="\u6240\u8981\u67e5\u8be2\u7684\u5e94\u7528\u5b9e\u4f53") SysApplications sysApplication) {
        return ApiResponse.success((Object)this.sysApplicationService.getApplicationByTypesAndName(sysApplication));
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u5e94\u7528\u5173\u8054\u7684\u89d2\u8272\u6811", notes="\u83b7\u53d6\u67d0\u4e2a\u5e94\u7528\u5173\u8054\u7684\u89d2\u8272\u6811")
    @GetMapping(value={"/applicationRoleTree"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u83b7\u53d6\u67d0\u4e2a\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getApplicationRoleTree(@ApiParam(value="\u5e94\u7528id") Long appId) {
        return ApiResponse.success((Object)this.sysApplicationRolesService.getApplicationRoleTree(appId));
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u89d2\u8272\u5173\u8054\u5e94\u7528\u7684\u5e94\u7528\u6811", notes="\u83b7\u53d6\u67d0\u4e2a\u89d2\u8272\u5173\u8054\u5e94\u7528\u7684\u5e94\u7528\u6811")
    @GetMapping(value={"/roleApplicationTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ba1\u7406", eventDesc="\u83b7\u53d6\u67d0\u4e2a\u89d2\u8272\u5173\u8054\u5e94\u7528\u7684\u5e94\u7528\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getRoleApplicationTree(@ApiParam(value="\u89d2\u8272id") Long roleId) {
        return ApiResponse.success((Object)this.sysApplicationRolesService.getRoleApplicationTree(roleId));
    }

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u548c\u5c97\u4f4d\u7684\u5173\u8054\u5173\u7cfb", notes="\u83b7\u53d6\u5e94\u7528\u548c\u5c97\u4f4d\u7684\u5173\u8054\u5173\u7cfb")
    @GetMapping(value={"/applicationPostTree"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u83b7\u53d6\u67d0\u4e2a\u5e94\u7528\u548c\u5c97\u4f4d\u7684\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysApplicationPost>> getApplicationPostTree(@ApiParam(value="\u5e94\u7528ID") Long appId) {
        return ApiResponse.success((Object)this.sysApplicationPostService.getApplicationPostTree(appId));
    }

    @ApiOperation(value="\u83b7\u53d6\u5c97\u4f4d\u548c\u5e94\u7528\u7684\u5173\u8054\u5173\u7cfb", notes="\u83b7\u53d6\u5c97\u4f4d\u548c\u5e94\u7528\u7684\u5173\u8054\u5173\u7cfb")
    @GetMapping(value={"/postApplicationTree"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u83b7\u53d6\u67d0\u4e2a\u5c97\u4f4d\u548c\u5e94\u7528\u7684\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysApplicationPost>> getPostApplicationTree(@ApiParam(value="\u5c97\u4f4dID") Long postId) {
        return ApiResponse.success((Object)this.sysApplicationPostService.getPostApplicationTree(postId));
    }

    @ApiOperation(value="\u5220\u9664\u5e94\u7528\u89d2\u8272\u5173\u8054\u5173\u7cfb", notes="\u5220\u9664\u89d2\u8272\u5bf9\u5e94\u7528\u7684\u6743\u9650")
    @PostMapping(value={"/deleteApplicationAndRole"})
    @AuditLog(moduleName="\u5220\u9664\u5e94\u7528\u89d2\u8272\u5173\u8054\u5173\u7cfb", eventDesc="\u6839\u636e\u5e94\u7528ID\u5220\u9664\u5e94\u7528\u89d2\u8272\u7684\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteApplicationAndRole() {
        return ApiResponse.success();
    }
}

