/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.application.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.application.dto.ApplicationPostDto;
import com.jxdinfo.hussar.authorization.application.model.SysApplicationPost;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationPostService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.post.application.dao.ApplicationPostMapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysApplicationPostImpl
extends ServiceImpl<ApplicationPostMapper, SysApplicationPost>
implements ISysApplicationPostService {
    @Resource
    ApplicationPostMapper applicationPostMapper;

    @DSTransactional
    public void addApplicationAndPosts(ApplicationPostDto applicationPostDto) {
        Long appId = applicationPostDto.getAppId();
        String postIds = applicationPostDto.getPostIds();
        if (ToolUtil.isEmpty((Object)appId)) {
            throw new RuntimeException("\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] ids = postIds.split(",");
        this.applicationPostMapper.deletePostAndApplication(appId);
        ArrayList<SysApplicationPost> applicationPostList = new ArrayList<SysApplicationPost>();
        for (String postId : ids) {
            if (ToolUtil.isEmpty((Object)postId)) continue;
            SysApplicationPost sysApplicationPost = new SysApplicationPost();
            sysApplicationPost.setAppId(appId);
            sysApplicationPost.setPostId(Long.valueOf(postId));
            applicationPostList.add(sysApplicationPost);
        }
        if (ToolUtil.isNotEmpty(applicationPostList)) {
            super.saveBatch(applicationPostList, applicationPostList.size());
        }
    }

    public List<SysApplicationPost> getApplicationPostTree(Long appId) {
        List applicationPostList = this.applicationPostMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysApplicationPost::getAppId, (Object)appId));
        return applicationPostList;
    }

    public List<SysApplicationPost> getPostApplicationTree(Long postId) {
        List applicationPostList = this.applicationPostMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysApplicationPost::getPostId, (Object)postId));
        return applicationPostList;
    }
}

