/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.post.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.model.SysUsersPositionOut;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersOutService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.dto.SysPostOut;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostConcurrently;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostMain;
import com.jxdinfo.hussar.authorization.post.service.IHussarBaseSyncPostService;
import com.jxdinfo.hussar.authorization.post.service.ISysPostOutService;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.authorization.post.service.UserPostConcurrentlyService;
import com.jxdinfo.hussar.authorization.post.service.UserPostMainService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.post.post.dao.HussarBaseSyncPostMapper;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.post.post.service.impl.hussarBaseSyncPostServiceImpl")
public class HussarBaseSyncPostServiceImpl
extends HussarServiceImpl<HussarBaseSyncPostMapper, SysPostOut>
implements IHussarBaseSyncPostService {
    private static final Logger log = LoggerFactory.getLogger(HussarBaseSyncPostServiceImpl.class);
    @Resource
    private ISysPostService sysPostService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private UserPostMainService userPostMainService;
    @Resource
    private UserPostConcurrentlyService userPostConcurrentlyService;
    @Autowired
    private ISysPostOutService sysPostOutService;
    @Autowired
    private SeqBuilder seqBuilder;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysOrganTypeService sysOrganTypeService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Autowired
    protected ISysUsersOutService sysUsersOutService;

    public Map<String, Object> savePost(SysPostOut post) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (post == null) {
            map.put("success", false);
            map.put("message", "\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\u3002");
        } else {
            try {
                post.setPushTime(LocalDateTime.now());
                post.setProcessingState(0);
                post.setFailReason(null);
                boolean bl = this.sysPostOutService.saveOrUpdate((Object)post);
                map.put("success", bl);
                if (bl) {
                    map.put("message", "\u63a5\u6536\u6570\u636e\u6210\u529f\u3002");
                } else {
                    map.put("message", "\u63a5\u6536\u6570\u636e\u5931\u8d25\u3002");
                }
            }
            catch (Exception e) {
                map.put("success", false);
                map.put("message", "\u63a5\u6536\u6570\u636e\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38\u3002");
            }
        }
        return map;
    }

    public void asyncPost() {
        this.operationPost();
    }

    public Map<String, Object> operationPost() {
        log.info("\u5c97\u4f4d\u540c\u6b65\u5f00\u59cb");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List list = this.sysPostService.existPost();
            log.info("\u9700\u8981\u5904\u7406\u7684\u5c97\u4f4d" + list.size() + "\u6761");
            if (list.size() > 0) {
                this.sysStruMapper.updatePostStateById(list);
            }
            ArrayList<SysPostOut> addList = new ArrayList<SysPostOut>();
            ArrayList<SysPostOut> editList = new ArrayList<SysPostOut>();
            ArrayList<SysPostOut> deletelist = new ArrayList<SysPostOut>();
            for (SysPostOut sysPostOut : list) {
                if (sysPostOut.getIsDeleted() == 1) {
                    deletelist.add(sysPostOut);
                    continue;
                }
                if (HussarUtils.isEmpty((Object)sysPostOut.getPostId())) {
                    addList.add(sysPostOut);
                    continue;
                }
                editList.add(sysPostOut);
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            List struList = this.sysPostService.list((Wrapper)wrapper);
            log.info("\u5c97\u4f4d\u65b0\u589e\u6570\u636e" + addList.size() + "\u6761");
            this.addPost(addList, struList);
            log.info("\u5c97\u4f4d\u4fee\u6539\u6570\u636e" + editList.size() + "\u6761");
            this.editPost(editList, struList);
            this.deleteOrgan(deletelist);
            this.sysPostOutService.updateBatchById(deletelist);
            map.put("success", true);
            map.put("message", "\u5904\u7406\u6210\u529f\u3002");
        }
        catch (Exception e) {
            map.put("success", false);
            map.put("message", e.getMessage());
            this.sysStruMapper.updatePostStatusToZero();
        }
        log.info("\u5c97\u4f4d\u540c\u6b65\u7ed3\u675f");
        return map;
    }

    public boolean addPost(List<SysPostOut> addList, List<SysPost> struList) {
        if (addList.size() > 0) {
            for (SysPostOut sysPostOut : addList) {
                Long id = this.seqBuilder.build().nextValue();
                sysPostOut.setPostId(id);
            }
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            for (SysPostOut sysPostOut : addList) {
                try {
                    this.add(addList, sysPostOut, struList);
                }
                catch (Exception e) {
                    sysPostOut.setProcessingState(2);
                    sysPostOut.setFailReason(e.getMessage());
                }
            }
            this.sysPostOutService.updateBatchById(addList);
            batchSqlSession.flushStatements();
        }
        catch (Exception e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", (Throwable)e);
        }
        return true;
    }

    public boolean editPost(List<SysPostOut> editList, List<SysPost> struList) {
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            for (SysPostOut sysPostOut : editList) {
                try {
                    this.edit(editList, sysPostOut, struList);
                }
                catch (Exception e) {
                    sysPostOut.setProcessingState(2);
                    sysPostOut.setFailReason(e.getMessage());
                }
            }
            this.sysPostOutService.updateBatchById(editList);
            batchSqlSession.flushStatements();
        }
        catch (Exception e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", (Throwable)e);
        }
        return true;
    }

    public boolean deleteOrgan(List<SysPostOut> deletelist) {
        for (SysPostOut sysPostOut : deletelist) {
            try {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(SysPost::getOutPostId, (Object)sysPostOut.getId());
                SysPost post = (SysPost)this.sysPostService.getOne((Wrapper)wrapper);
                if (HussarUtils.isEmpty((Object)post)) {
                    throw new BaseException("\u5220\u9664\u6570\u636e\u4e0d\u5b58\u5728\u3002");
                }
                this.sysPostService.removeById((Serializable)post.getPostId());
                sysPostOut.setProcessingState(1);
                sysPostOut.setFailReason("\u5220\u9664\u6210\u529f\u3002");
            }
            catch (Exception e) {
                sysPostOut.setProcessingState(2);
                sysPostOut.setFailReason(e.getMessage());
            }
        }
        return true;
    }

    public boolean add(List<SysPostOut> addList, SysPostOut post, List<SysPost> struList) {
        SysPost sysPost = this.transformationPost(post, null, struList, addList);
        this.sysPostService.save((Object)sysPost);
        post.setProcessingState(1);
        this.sysPostOutService.updateById((Object)post);
        return true;
    }

    public boolean edit(List<SysPostOut> editList, SysPostOut post, List<SysPost> struList) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysPost::getOutPostId, (Object)post.getId());
        SysPost po = (SysPost)this.sysPostService.getOne((Wrapper)lambdaQueryWrapper);
        SysPost sysPost = this.transformationPost(post, po, struList, editList);
        this.sysPostService.updateById((Object)sysPost);
        post.setProcessingState(1);
        this.sysPostOutService.updateById((Object)post);
        return true;
    }

    public SysPost transformationPost(SysPostOut sysPostOut, SysPost po, List<SysPost> sysPostList, List<SysPostOut> postList) {
        SysPost sysPost = new SysPost();
        if (po != null) {
            sysPost = po;
        } else {
            sysPost.setPostId(sysPostOut.getPostId());
        }
        if (sysPostOut.getIsDeleted() == 1) {
            sysPost.setDelFlag(sysPostOut.getIsDeleted());
        } else {
            sysPost.setOutPostId(sysPostOut.getId());
            sysPost.setPostName(sysPostOut.getName());
            sysPost.setPostNo(sysPostOut.getCode());
            sysPost.setPostStatus(String.valueOf(sysPostOut.getEnabled() == 1 ? 0 : 1));
            sysPost.setOutSortNumber(sysPostOut.getSortNumber());
            sysPost.setOutOriginId(sysPostOut.getOriginId());
            if (HussarUtils.isNotEmpty((Object)sysPostOut.getPositionTypeCode())) {
                boolean existType;
                LambdaQueryWrapper typeLambdaQueryWrapper = new LambdaQueryWrapper();
                typeLambdaQueryWrapper.eq(SysOrganType::getOrganType, (Object)sysPostOut.getPositionTypeCode());
                boolean bl = existType = this.sysOrganTypeService.count((Wrapper)typeLambdaQueryWrapper) > 0L;
                if (!existType) {
                    throw new BaseException("\u4e0d\u5b58\u5728\u7684\u5c97\u4f4d\u7c7b\u578b\u3002");
                }
            } else {
                throw new BaseException("\u5c97\u4f4d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            sysPost.setPostType(sysPostOut.getPositionTypeCode());
            if (sysPostOut.getParentId() == null || "".equals(sysPostOut.getParentId())) {
                sysPost.setPostParentNo("-1");
            } else {
                List list = sysPostList.stream().filter(item -> sysPostOut.getParentId().equals(item.getOutPostId())).collect(Collectors.toList());
                List outList = postList.stream().filter(item -> sysPostOut.getParentId().equals(item.getId())).collect(Collectors.toList());
                if (list.size() > 0) {
                    sysPost.setPostParentNo(String.valueOf(((SysPost)list.get(0)).getPostId()));
                } else if (outList.size() > 0) {
                    sysPost.setPostParentNo(String.valueOf(((SysPostOut)outList.get(0)).getPostId()));
                } else {
                    throw new BaseException("\u7236\u7ea7\u5c97\u4f4did\u672a\u627e\u5230\u3002");
                }
            }
        }
        return sysPost;
    }

    public void savePostList(List<SysUsersPositionOut> positionList, String userId) {
        ArrayList<SysUserPostMain> mainlist = new ArrayList<SysUserPostMain>();
        ArrayList<SysUserPostConcurrently> concurrentlylist = new ArrayList<SysUserPostConcurrently>();
        String str = "";
        List myList = positionList.stream().filter(res -> res.getEnabled() == 1).collect(Collectors.toList());
        if (myList != null && myList.size() > 0) {
            LambdaQueryWrapper lambdaQueryWrapperUser = new LambdaQueryWrapper();
            lambdaQueryWrapperUser.eq(SysUsers::getOutUserId, (Object)userId);
            SysUsers user = (SysUsers)this.sysUsersService.getOne((Wrapper)lambdaQueryWrapperUser);
            List positionIds = myList.stream().map(SysUsersPositionOut::getPositionId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaQueryWrapperPost = new LambdaQueryWrapper();
            lambdaQueryWrapperPost.in(SysPost::getOutPostId, positionIds);
            List postList = this.sysPostService.list((Wrapper)lambdaQueryWrapperPost);
            List list = myList.stream().map(SysUsersPositionOut::getDepartmentId).collect(Collectors.toList());
            List struList = this.sysStruService.getStruList(list);
            for (SysUsersPositionOut sysUsersPositionOut : myList) {
                List strus;
                List postIds = postList.stream().filter(apple -> sysUsersPositionOut.getPositionId().equals(apple.getOutPostId())).collect(Collectors.toList());
                if (sysUsersPositionOut.getMainPosition() == 1) {
                    SysUserPostMain sysUserPostMain = new SysUserPostMain();
                    sysUserPostMain.setUpUserId(user.getEmployeeId());
                    if (HussarUtils.isNotEmpty(postIds)) {
                        sysUserPostMain.setUpPostId(((SysPost)postIds.get(0)).getPostId());
                        mainlist.add(sysUserPostMain);
                        continue;
                    }
                    str = str + "\u4e3b\u5c97\u627e\u4e0d\u5230\uff0c\u4eba\u5458id\uff1a" + userId + ",\u4e3b\u5c97id\uff1a" + sysUsersPositionOut.getPositionId() + ";";
                    break;
                }
                SysUserPostConcurrently sysUserPostConcurrently = new SysUserPostConcurrently();
                sysUserPostConcurrently.setUpUserId(user.getEmployeeId());
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(SysStru::getOutStruId, (Object)sysUsersPositionOut.getCompanyId());
                SysStru stru = (SysStru)this.sysStruService.getOne((Wrapper)wrapper);
                sysUserPostConcurrently.setUpCompanyId(stru.getId());
                if (!HussarUtils.isNotEmpty(postIds)) {
                    str = str + "\u517c\u5c97\u627e\u4e0d\u5230\uff0c\u4eba\u5458id\uff1a" + userId + ",\u517c\u5c97id\uff1a" + sysUsersPositionOut.getPositionId() + ";";
                    break;
                }
                sysUserPostConcurrently.setUpPostId(((SysPost)postIds.get(0)).getPostId());
                if (struList.size() > 0) {
                    strus = struList.stream().filter(apple -> sysUsersPositionOut.getDepartmentId().equals(apple.getOutStruId())).collect(Collectors.toList());
                    if (strus.size() <= 0) {
                        str = str + "\u517c\u5c97\uff1a" + sysUsersPositionOut.getPositionId() + "\u7684\u7ec4\u7ec7\u673a\u6784id\uff1a" + sysUsersPositionOut.getDepartmentId() + "\u627e\u4e0d\u5230;";
                        break;
                    }
                } else {
                    str = str + "\u517c\u5c97id\uff1a" + sysUsersPositionOut.getPositionId() + "\u7684\u7ec4\u7ec7\u673a\u6784id\uff1a" + sysUsersPositionOut.getDepartmentId() + "\u627e\u4e0d\u5230;";
                    break;
                }
                sysUserPostConcurrently.setUpStruId(Long.valueOf(String.valueOf(((SysStru)strus.get(0)).getId())));
                if (sysUsersPositionOut.getEnabled() == 0) continue;
                concurrentlylist.add(sysUserPostConcurrently);
            }
        } else {
            str = "\u5c97\u4f4d\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002";
        }
        if (!"".equals(str)) {
            throw new BaseException(str);
        }
        if (mainlist.size() > 0) {
            this.userPostMainService.saveBatch(mainlist);
        }
        if (concurrentlylist.size() > 0) {
            this.userPostConcurrentlyService.saveBatch(concurrentlylist);
        }
    }
}

