/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.post.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.application.dto.ApplicationGroupDto;
import com.jxdinfo.hussar.authorization.application.dto.SeqDto;
import com.jxdinfo.hussar.authorization.application.model.SysApplicationGroup;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationGroupService;
import com.jxdinfo.hussar.authorization.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.post.application.dao.SysApplicationGroupMapper;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysApplicationGroupManageServiceImpl
extends HussarServiceImpl<SysApplicationGroupMapper, SysApplicationGroup>
implements ISysApplicationGroupService {
    @Resource
    private SysApplicationGroupMapper sysApplicationGroupMapper;
    @Resource
    private ISysApplicationService sysApplicationService;

    public String add(ApplicationGroupDto applicationGroupDto) {
        SysApplicationGroup sysApplicationGroup = this.setSysApplicationGroup(applicationGroupDto);
        int insertResult = this.sysApplicationGroupMapper.insert(sysApplicationGroup);
        if (insertResult != 1) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        return "\u65b0\u589e\u6210\u529f";
    }

    public String edit(ApplicationGroupDto applicationGroupDto) {
        SysApplicationGroup sysApplicationGroup = this.setSysApplicationGroup(applicationGroupDto);
        int editResult = this.sysApplicationGroupMapper.updateById(sysApplicationGroup);
        if (editResult != 1) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25");
        }
        return "\u4fee\u6539\u6210\u529f";
    }

    private SysApplicationGroup setSysApplicationGroup(ApplicationGroupDto applicationGroupDto) {
        if (HussarUtils.isEmpty((Object)applicationGroupDto.getGroupName())) {
            throw new BaseException("\u6a21\u5757\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysApplicationGroup sysApplicationGroup = new SysApplicationGroup();
        if (HussarUtils.isNotEmpty((Object)applicationGroupDto.getId())) {
            long sameNum = this.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplicationGroup::getGroupName, (Object)applicationGroupDto.getGroupName())).ne(SysApplicationGroup::getGroupId, (Object)applicationGroupDto.getId()));
            if (sameNum != 0L) {
                throw new BaseException("\u5df2\u5b58\u5728\u8be5\u6a21\u5757");
            }
            sysApplicationGroup.setGroupId(applicationGroupDto.getId());
            sysApplicationGroup.setSeq(applicationGroupDto.getSeq());
        } else {
            long sameNum = this.count((Wrapper)new LambdaQueryWrapper().eq(SysApplicationGroup::getGroupName, (Object)applicationGroupDto.getGroupName()));
            if (sameNum != 0L) {
                throw new BaseException("\u5df2\u5b58\u5728\u8be5\u6a21\u5757");
            }
            int order = 1;
            Integer maxOrder = this.sysApplicationGroupMapper.getMaxOrderByParentId(applicationGroupDto.getParentId());
            if (HussarUtils.isNotEmpty((Object)maxOrder)) {
                order = maxOrder + 1;
            }
            sysApplicationGroup.setSeq(Integer.valueOf(order));
        }
        sysApplicationGroup.setGroupName(applicationGroupDto.getGroupName());
        sysApplicationGroup.setDes(applicationGroupDto.getDes());
        sysApplicationGroup.setImagePath(applicationGroupDto.getImagePath());
        sysApplicationGroup.setParentId(applicationGroupDto.getParentId());
        return sysApplicationGroup;
    }

    public String delete(Long groupId) {
        long sonNum = this.count((Wrapper)new LambdaQueryWrapper().eq(SysApplicationGroup::getParentId, (Object)groupId));
        if (sonNum != 0L) {
            throw new BaseException("\u5b58\u5728\u5b50\u6a21\u5757");
        }
        boolean hasApps = this.sysApplicationService.hasAppsInGroup(groupId);
        if (hasApps) {
            throw new BaseException("\u6a21\u5757\u4e0b\u5b58\u5728\u5e94\u7528");
        }
        int deleteNum = this.sysApplicationGroupMapper.deleteById(groupId);
        if (deleteNum != 1) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return "\u5220\u9664\u6210\u529f";
    }

    public List<JSTreeModel> getApplicationTree() {
        try {
            return TreeModelUtils.merge(this.getApplicationsTree());
        }
        catch (Exception e) {
            throw new BaseException("\u83b7\u53d6\u6a21\u5757\u6811\u5931\u8d25");
        }
    }

    public List<JSTreeModel> getApplicationAndGroupTree() {
        return this.sysApplicationGroupMapper.getApplicationAndGroupTree();
    }

    public List<JSTreeModel> getChildrenGroup(Long groupId, String groupName) {
        if (HussarUtils.isEmpty((Object)groupId)) {
            throw new BaseException("\u6a21\u5757id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<JSTreeModel> result = this.sysApplicationGroupMapper.getChildrenGroup(groupId);
        JSTreeModel root = new JSTreeModel();
        root.setId(groupId);
        root.setText(groupName);
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isModule");
        result.add(root);
        return TreeModelUtils.merge(result);
    }

    public String saveSeq(List<SeqDto> seqDtoList) {
        ArrayList<SysApplicationGroup> applicationGroups = new ArrayList<SysApplicationGroup>();
        for (SeqDto seq : seqDtoList) {
            SysApplicationGroup sysApplicationGroup = new SysApplicationGroup();
            sysApplicationGroup.setSeq(Integer.valueOf(seq.getSeq()));
            sysApplicationGroup.setGroupId(seq.getId());
            applicationGroups.add(sysApplicationGroup);
        }
        if (HussarUtils.isNotEmpty(applicationGroups)) {
            boolean hasUpdate;
            boolean bl = hasUpdate = this.sysApplicationGroupMapper.saveSeq(applicationGroups) == applicationGroups.size();
            if (!hasUpdate) {
                throw new BaseException("\u4fdd\u5b58\u6392\u5e8f\u4fe1\u606f\u5931\u8d25");
            }
        }
        return "\u4fdd\u5b58\u6210\u529f";
    }

    public List<JSTreeModel> getApplicationsTree() {
        List<JSTreeModel> jsTreeModelList = this.sysApplicationGroupMapper.getApplicationTree();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.MENU_NODE_ID);
        root.setLabel("\u6a21\u5757\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setType("isRoot");
        jsTreeModelList.add(root);
        return jsTreeModelList;
    }
}

