/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.plugin.config;

import com.jxdinfo.hussar.core.HussarCoreAutoConfiguration;
import com.jxdinfo.hussar.plugin.config.pluginListener.PluginListerner;
import com.jxdinfo.hussar.support.cache.config.HussarCacheConfiguration;
import com.jxdinfo.hussar.support.hotloadd.framework.extension.mainservice.MainServiceExtension;
import com.jxdinfo.hussar.support.hotloadd.framework.extension.transaction.HussarPluginTransactionExtension;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.AbstractExtension;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.SpringBootMybatisExtension;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.AutoIntegrationConfiguration;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.application.DefaultPluginApplication;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.application.PluginApplication;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.listener.PluginInitializerListener;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.operator.PluginOperator;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.user.PluginUser;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ImportAutoConfiguration(value={HussarCoreAutoConfiguration.class})
@Import(value={AutoIntegrationConfiguration.class})
@ComponentScan(basePackages={"com.jxdinfo.hussar.plugin"})
@MapperScan(basePackages={"com.jxdinfo.hussar.plugin.dao"})
@AutoConfigureAfter(value={HussarCacheConfiguration.class})
@ConditionalOnProperty(prefix="plugin", name={"enable"}, havingValue="true")
public class HussarExtendPluginConfiguration {
    @Bean
    public DefaultPluginApplication pluginApplication(ApplicationContext applicationContext, PluginInitializerListener pluginInitializerListener) {
        DefaultPluginApplication pluginApplication = new DefaultPluginApplication();
        this.addMybatisPluginExtension((PluginApplication)pluginApplication);
        pluginApplication.addExtension((AbstractExtension)new HussarPluginTransactionExtension());
        pluginApplication.addExtension((AbstractExtension)new MainServiceExtension());
        pluginApplication.addListener(PluginListerner.class);
        pluginApplication.initialize(applicationContext, pluginInitializerListener);
        return pluginApplication;
    }

    @Bean
    public PluginUser pluginUser(DefaultPluginApplication pluginApplication) {
        return pluginApplication.getPluginUser();
    }

    @Bean
    public PluginOperator pluginOperator(DefaultPluginApplication pluginApplication) {
        return pluginApplication.getPluginOperator();
    }

    private void addMybatisPluginExtension(PluginApplication pluginApplication) {
        pluginApplication.addExtension((AbstractExtension)new SpringBootMybatisExtension(SpringBootMybatisExtension.Type.MYBATIS_PLUS));
    }
}

