/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.example.plugin.feign;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.example.plugin.feign.HussarCommonFeignService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HussarCommonFeignController
implements HussarCommonFeignService {
    @Resource
    private ISysUserRoleService roleService;

    public void saveUserRole(List<String> ids) {
        List idList = ids.stream().map(Long::parseLong).collect(Collectors.toList());
        ArrayList<SysUserRole> list = new ArrayList<SysUserRole>();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        for (Long id : idList) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(id);
            sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
            sysUserRole.setAdminOption("1");
            sysUserRole.setCreator(securityUser.getId());
            sysUserRole.setCreateTime(LocalDateTime.now());
            list.add(sysUserRole);
        }
        if (ToolUtil.isNotEmpty(idList)) {
            idList.add(Constants.SECURITY_USER);
            idList.add(Constants.SYSTEM_USER);
            idList.add(Constants.AUDIT_USER);
            this.roleService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(SysUserRole::getUserId, idList)).or()).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.PUBLIC_ROLE.getValue()));
            this.roleService.saveBatch(list);
        }
    }

    public void changeAuditLoginInfo() {
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName("\u767b\u5f55");
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGIN);
        auditLogModel.setEventDesc("\u767b\u5f55\u6210\u529f\uff01");
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
    }
}

