/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pinyin.util;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.pinyin.annotation.PinyinSearchColumn;
import com.jxdinfo.hussar.pinyin.util.DsTypesManagerUtil;
import com.jxdinfo.hussar.pinyin.util.HigngoDbTypesUtil;
import com.jxdinfo.hussar.pinyin.util.MybatisUtil;
import com.jxdinfo.hussar.pinyin.util.PostgresqlDbTypeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SqlServerDbTypeUtil
implements DsTypesManagerUtil {
    public static String BIT = "bit";
    public static String INT = "int";
    public static String SMALLINT = "smallint";
    public static String TINYINT = "tinyint";
    public static String NUMERIC = "numeric";
    public static String DECIMAL = "decimal";
    public static String FLOAT = "float";
    public static String REAL = "real";
    public static String CHAR = "char";
    public static String VARCHAR = "varchar";
    public static String TEXT = "text";
    public static String NCHAR = "nchar";
    public static String NVARCHAR = "nvarchar";
    public static String NTEXT = "ntext";
    public static String VARBINARY = "varbinary";
    public static String DATE = "date";
    public static String TIME = "time";
    public static String DATETIME = "datetime";
    public static String DATETIME2 = "datetime2";
    public static String NOTNULL = "NOT NULL";
    public static String NULL = "NULL";
    private static final String MAX_DESCRIBE = "(max)";

    @Override
    public String getCreateTableSql(ResultSetMetaData orignSelectRs, ResultSetMetaData searchColumnsRs) {
        StringBuffer sbuf = new StringBuffer();
        try {
            int columnCount = orignSelectRs.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = orignSelectRs.getColumnName(i);
                if (HussarUtils.isNotEmpty((Object)columnName)) {
                    sbuf.append(columnName).append(" ");
                }
                String columnTypeName = orignSelectRs.getColumnTypeName(i);
                String colDescribe = this.getColumnTypeDescribe(orignSelectRs, i);
                if (HussarUtils.isNotEmpty((Object)columnTypeName)) {
                    sbuf.append(columnTypeName.toLowerCase());
                    if (HussarUtils.isNotEmpty((Object)colDescribe)) {
                        sbuf.append(colDescribe);
                    }
                    sbuf.append(" ");
                }
                if (0 == orignSelectRs.isNullable(i)) {
                    if (i == 1) {
                        sbuf.append(PostgresqlDbTypeUtil.NOTNULL).append(" ").append("PRIMARY KEY").append(", ");
                        continue;
                    }
                    sbuf.append(PostgresqlDbTypeUtil.NOTNULL).append(" ").append(", ");
                    continue;
                }
                if (1 != orignSelectRs.isNullable(i)) continue;
                sbuf.append(PostgresqlDbTypeUtil.NULL).append(", ");
            }
            sbuf.append(this.getCreateTableSearchColumnsSql(searchColumnsRs));
            sbuf.append(")");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return sbuf.toString();
    }

    @Override
    public List<List<Object>> getDataValues(ResultSet orign, ResultSet search, String[] clomuns, String[] searchColumns, String tableName) {
        ArrayList<List<Object>> orignResult = new ArrayList<List<Object>>();
        ArrayList<Object> orignValues = null;
        Map<String, String> columnJavaTypes = null;
        try {
            ResultSetMetaData meta = orign.getMetaData();
            int columnNum = meta.getColumnCount();
            while (orign.next()) {
                orignValues = new ArrayList<Object>();
                for (int i = 1; i <= columnNum; ++i) {
                    String type = meta.getColumnTypeName(i);
                    if (HussarUtils.isEmpty(columnJavaTypes)) {
                        columnJavaTypes = this.getColumnJavaTypes(tableName);
                    }
                    if (this.checkNumericType(meta.getColumnTypeName(i)).booleanValue()) {
                        int getPrecision = meta.getPrecision(i);
                        int getScale = meta.getScale(i);
                        if (getScale == 0) {
                            if (getPrecision > 10 && getPrecision <= 20) {
                                Long columnLong = orign.getLong(clomuns[i - 1]);
                                orignValues.add(i - 1, columnLong);
                                continue;
                            }
                            if (getPrecision <= 10) {
                                Integer columnInt = orign.getInt(clomuns[i - 1]);
                                orignValues.add(i - 1, columnInt);
                                continue;
                            }
                        }
                        if (getScale > 0) {
                            BigDecimal columnBigDecimal = orign.getBigDecimal(clomuns[i - 1]);
                            orignValues.add(i - 1, columnBigDecimal);
                            continue;
                        }
                    }
                    if (this.checkJavaStringType(meta.getColumnTypeName(i)).booleanValue()) {
                        String columnString = orign.getString(clomuns[i - 1]);
                        orignValues.add(i - 1, columnString);
                        continue;
                    }
                    if (this.checkDecimalType(meta.getColumnTypeName(i)).booleanValue()) {
                        BigDecimal columnFloat = orign.getBigDecimal(clomuns[i - 1]);
                        orignValues.add(i - 1, columnFloat);
                        continue;
                    }
                    if (this.checkFloatType(meta.getColumnTypeName(i)).booleanValue()) {
                        BigDecimal columnFloat = orign.getBigDecimal(clomuns[i - 1]);
                        orignValues.add(i - 1, columnFloat);
                        continue;
                    }
                    if (this.checkIntegerType(meta.getColumnTypeName(i)).booleanValue()) {
                        Integer columnInteger = orign.getInt(clomuns[i - 1]);
                        orignValues.add(i - 1, columnInteger);
                        continue;
                    }
                    if (this.checkJavaBytesType(meta.getColumnTypeName(i)).booleanValue()) {
                        byte[] columnBytes = orign.getBytes(clomuns[i - 1]);
                        orignValues.add(i - 1, columnBytes);
                        continue;
                    }
                    if (this.checkDateType(meta.getColumnTypeName(i)).booleanValue()) {
                        LocalDate localDate = orign.getDate(clomuns[i - 1]).toLocalDate();
                        orignValues.add(i - 1, localDate);
                        continue;
                    }
                    if (this.checkTimeType(meta.getColumnTypeName(i)).booleanValue()) {
                        LocalTime localTime = orign.getTime(clomuns[i - 1]).toLocalTime();
                        orignValues.add(i - 1, localTime);
                        continue;
                    }
                    if (this.checkDateTimeType(meta.getColumnTypeName(i)).booleanValue()) {
                        LocalDateTime localDateTime = orign.getTimestamp(clomuns[i - 1]).toLocalDateTime();
                        orignValues.add(i - 1, localDateTime);
                        continue;
                    }
                    if (!this.checkBoolType(meta.getColumnTypeName(i)).booleanValue()) continue;
                    Boolean columnBoolean = orign.getBoolean(clomuns[i - 1]);
                    orignValues.add(i - 1, columnBoolean);
                }
                orignResult.add(orignValues);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return orignResult;
    }

    @Override
    public Map<String, String> searchColumnAnnationInfos(String tableName, String[] searchColumns) {
        HashMap<String, String> map = new HashMap<String, String>();
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        List tableFields = tableInfo.getFieldList();
        for (String columnName : searchColumns) {
            Field tableField = ((TableFieldInfo)tableFields.stream().filter(tableFieldInfo -> columnName.equals(tableFieldInfo.getColumn())).collect(Collectors.toList()).get(0)).getField();
            if (Arrays.stream(tableField.getDeclaredAnnotations()).filter(s -> "com.jxdinfo.hussar.pinyin.annotation.PinyinSearchColumn".equals(s.annotationType().getName())).collect(Collectors.toList()).size() <= 0) continue;
            PinyinSearchColumn psc = tableField.getAnnotation(PinyinSearchColumn.class);
            map.put(columnName, psc.type());
        }
        return map;
    }

    public Map<String, String> getColumnJavaTypes(String tableName) {
        HashMap<String, String> map = new HashMap<String, String>();
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        if (HussarUtils.isNotEmpty((Object)tableInfo)) {
            map.put(tableInfo.getKeyColumn(), tableInfo.getKeyType().getName());
            List tableFields = tableInfo.getFieldList();
            for (TableFieldInfo tableFieldInfo : tableFields) {
                map.put(tableFieldInfo.getColumn(), tableFieldInfo.getPropertyType().getName());
            }
        }
        return map;
    }

    public String getColumnTypeDescribe(ResultSetMetaData metaData, int i) {
        String colDescribe = "";
        try {
            int columnDisplaySize;
            String columnTypeName = metaData.getColumnTypeName(i);
            if (this.checkCharType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = 0x3FFFFFFF == columnDisplaySize ? MAX_DESCRIBE : "(" + columnDisplaySize + ")";
            }
            if (this.checkNumericType(columnTypeName).booleanValue() || this.checkDecimalType(columnTypeName).booleanValue()) {
                int getPrecision = metaData.getPrecision(i);
                int getScale = metaData.getScale(i);
                colDescribe = "(" + getPrecision + "," + getScale + ")";
            }
            if (this.checkVarbinaryType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = Integer.MAX_VALUE == columnDisplaySize ? MAX_DESCRIBE : "(" + columnDisplaySize + ")";
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return colDescribe;
    }

    public String getCreateTableSearchColumnsSql(ResultSetMetaData metaData) {
        StringBuffer sbufFull = new StringBuffer();
        StringBuffer sbufInitial = new StringBuffer();
        ArrayList sbufFullList = Lists.newArrayListWithCapacity((int)4);
        try {
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = metaData.getColumnName(i);
                if (HussarUtils.isNotEmpty((Object)columnName)) {
                    sbufFull.append(columnName.concat(MybatisUtil.SEARCHCOLUMNFULLSUFFIX)).append(" ");
                    sbufInitial.append(columnName.concat(MybatisUtil.SEARCHCOLUMNINITIALSUFFIX)).append(" ");
                }
                String columnTypeName = metaData.getColumnTypeName(i);
                String colDescribe = this.getSearchColumnTypeDescribe(metaData, i);
                if (HussarUtils.isNotEmpty((Object)columnTypeName)) {
                    sbufFull.append(columnTypeName.toLowerCase());
                    sbufInitial.append(columnTypeName.toLowerCase());
                    if (HussarUtils.isNotEmpty((Object)colDescribe)) {
                        sbufFull.append(colDescribe);
                        sbufInitial.append(colDescribe);
                    }
                    sbufFull.append(" ");
                    sbufInitial.append(" ");
                }
                if (0 == metaData.isNullable(i)) {
                    sbufFull.append(HigngoDbTypesUtil.NOTNULL).append(" ");
                    sbufInitial.append(HigngoDbTypesUtil.NOTNULL).append(" ");
                } else if (1 == metaData.isNullable(i)) {
                    sbufFull.append(HigngoDbTypesUtil.NULL).append(" ");
                    sbufInitial.append(HigngoDbTypesUtil.NULL).append(" ");
                }
                sbufFullList.add(sbufFull.toString());
                sbufFullList.add(sbufInitial.toString());
                sbufFull.delete(0, sbufFull.length());
                sbufInitial.delete(0, sbufInitial.length());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return String.join((CharSequence)",", sbufFullList);
    }

    public String getSearchColumnTypeDescribe(ResultSetMetaData metaData, int i) {
        String colDescribe = "";
        try {
            int columnDisplaySize;
            String columnTypeName = metaData.getColumnTypeName(i);
            if (this.checkCharType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = 0x3FFFFFFF == columnDisplaySize ? MAX_DESCRIBE : "(" + (columnDisplaySize *= 6) + ")";
            }
            if (this.checkNumericType(columnTypeName).booleanValue() || this.checkDecimalType(columnTypeName).booleanValue()) {
                int getPrecision = metaData.getPrecision(i);
                int getScale = metaData.getScale(i);
                colDescribe = "(" + getPrecision + "," + getScale + ")";
            }
            if (this.checkVarbinaryType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = Integer.MAX_VALUE == columnDisplaySize ? MAX_DESCRIBE : "(" + (columnDisplaySize *= 6) + ")";
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return colDescribe;
    }

    public Boolean checkCharType(String columnTypeName) {
        boolean result = false;
        if (columnTypeName.equals(VARCHAR) || columnTypeName.equals(CHAR) || columnTypeName.equals(NCHAR) || columnTypeName.equals(NVARCHAR)) {
            result = true;
        }
        return result;
    }

    public Boolean checkNumericType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(NUMERIC)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkDecimalType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(DECIMAL)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkVarbinaryType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(VARBINARY)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkJavaStringType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(CHAR) || columnTypeName.equals(TEXT) || columnTypeName.equals(VARCHAR) || columnTypeName.equals(NCHAR) || columnTypeName.equals(NVARCHAR) || columnTypeName.equals(NTEXT)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkFloatType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(FLOAT) || columnTypeName.equals(REAL)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkIntegerType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(TINYINT) || columnTypeName.equals(INT) || columnTypeName.equals(SMALLINT)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkJavaBytesType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(VARBINARY)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkDateType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(DATE)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkTimeType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(TIME)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkDateTimeType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(DATETIME) || columnTypeName.equals(DATETIME2)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkBoolType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(BIT)) {
            flag = true;
        }
        return flag;
    }
}

