/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pinyin.util;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.pinyin.annotation.PinyinSearchColumn;
import com.jxdinfo.hussar.pinyin.util.DsTypesManagerUtil;
import com.jxdinfo.hussar.pinyin.util.MybatisUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OracleDbTypeUtil
implements DsTypesManagerUtil {
    public static String NUMBER = "NUMBER";
    public static String FLOAT = "FLOAT";
    public static String RAW = "RAW";
    public static String DATE = "DATE";
    public static String TIMESTAMP = "TIMESTAMP";
    public static String CHAR = "CHAR";
    public static String NCHAR = "NCHAR";
    public static String VARCHAR2 = "VARCHAR2";
    public static String NVARCHAR2 = "NVARCHAR2";
    public static String CLOB = "CLOB";
    public static String NCLOB = "NCLOB";
    public static String BLOB = "BLOB";
    public static String NOTNULL = "NOT NULL";
    public static String NULL = "NULL";

    @Override
    public String getCreateTableSql(ResultSetMetaData orignSelectRs, ResultSetMetaData searchColumnsRs) {
        StringBuffer sbuf = new StringBuffer();
        try {
            int columnCount = orignSelectRs.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = orignSelectRs.getColumnName(i);
                if (HussarUtils.isNotEmpty((Object)columnName)) {
                    sbuf.append(columnName).append(" ");
                }
                String columnTypeName = orignSelectRs.getColumnTypeName(i);
                if (orignSelectRs.getScale(i) == -127) {
                    columnTypeName = FLOAT;
                }
                String colDescribe = this.getColumnTypeDescribe(orignSelectRs, i);
                if (HussarUtils.isNotEmpty((Object)columnTypeName)) {
                    sbuf.append(columnTypeName.toLowerCase());
                    if (HussarUtils.isNotEmpty((Object)colDescribe)) {
                        sbuf.append(colDescribe);
                    }
                    sbuf.append(" ");
                }
                if (0 == orignSelectRs.isNullable(i)) {
                    if (i == 1) {
                        sbuf.append(NOTNULL).append(" ").append("PRIMARY KEY").append(", ");
                        continue;
                    }
                    sbuf.append(NOTNULL).append(" ").append(", ");
                    continue;
                }
                if (1 != orignSelectRs.isNullable(i)) continue;
                sbuf.append(", ");
            }
            sbuf.append(this.getCreateTableSearchColumnsSql(searchColumnsRs));
            sbuf.append(")");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return sbuf.toString();
    }

    public String getColumnTypeDescribe(ResultSetMetaData metaData, int i) {
        String colDescribe = "";
        try {
            int columnDisplaySize;
            String columnTypeName = metaData.getColumnTypeName(i);
            if (this.checkCharType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = "(" + columnDisplaySize + ")";
            }
            if (this.checkRAWType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = "(" + columnDisplaySize + ")";
            }
            if (this.checkNumberType(columnTypeName).booleanValue()) {
                int getPrecision = metaData.getPrecision(i);
                int getScale = metaData.getScale(i);
                colDescribe = -127 == getScale ? "(" + getPrecision + ")" : "(" + getPrecision + "," + getScale + ")";
            }
            if (this.checkFloatType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = "(" + columnDisplaySize + ")";
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return colDescribe;
    }

    public String getCreateTableSearchColumnsSql(ResultSetMetaData metaData) {
        StringBuffer sbufFull = new StringBuffer();
        StringBuffer sbufInitial = new StringBuffer();
        ArrayList sbufFullList = Lists.newArrayListWithCapacity((int)4);
        try {
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = metaData.getColumnName(i);
                if (HussarUtils.isNotEmpty((Object)columnName)) {
                    sbufFull.append(columnName.concat(MybatisUtil.SEARCHCOLUMNFULLSUFFIX)).append(" ");
                    sbufInitial.append(columnName.concat(MybatisUtil.SEARCHCOLUMNINITIALSUFFIX)).append(" ");
                }
                String columnTypeName = metaData.getColumnTypeName(i);
                String colDescribe = this.getSearchColumnTypeDescribe(metaData, i);
                if (HussarUtils.isNotEmpty((Object)columnTypeName)) {
                    sbufFull.append(columnTypeName.toLowerCase());
                    sbufInitial.append(columnTypeName.toLowerCase());
                    if (HussarUtils.isNotEmpty((Object)colDescribe)) {
                        sbufFull.append(colDescribe);
                        sbufInitial.append(colDescribe);
                    }
                    sbufFull.append(" ");
                    sbufInitial.append(" ");
                }
                if (0 == metaData.isNullable(i)) {
                    sbufFull.append(NOTNULL).append(" ");
                    sbufInitial.append(NOTNULL).append(" ");
                } else if (1 == metaData.isNullable(i)) {
                    sbufFull.append(" ");
                    sbufInitial.append(" ");
                }
                sbufFullList.add(sbufFull.toString());
                sbufFullList.add(sbufInitial.toString());
                sbufFull.delete(0, sbufFull.length());
                sbufInitial.delete(0, sbufInitial.length());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return String.join((CharSequence)",", sbufFullList);
    }

    public String getSearchColumnTypeDescribe(ResultSetMetaData metaData, int i) {
        String colDescribe = "";
        try {
            int columnDisplaySize;
            String columnTypeName = metaData.getColumnTypeName(i);
            if (this.checkCharType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = "(" + (columnDisplaySize *= 6) + ")";
            }
            if (this.checkRAWType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = "(" + (columnDisplaySize *= 6) + ")";
            }
            if (this.checkNumberType(columnTypeName).booleanValue()) {
                int getPrecision = metaData.getPrecision(i);
                int getScale = metaData.getScale(i);
                colDescribe = "(" + getPrecision + "," + getScale + ")";
            }
            if (this.checkFloatType(columnTypeName).booleanValue()) {
                columnDisplaySize = metaData.getColumnDisplaySize(i);
                colDescribe = "(" + columnDisplaySize + ")";
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return colDescribe;
    }

    @Override
    public List<List<Object>> getDataValues(ResultSet orign, ResultSet search, String[] clomuns, String[] searchColumns, String tableName) {
        ArrayList<List<Object>> orignResult = new ArrayList<List<Object>>();
        ArrayList<Object> orignValues = null;
        try {
            ResultSetMetaData meta = orign.getMetaData();
            int columnNum = meta.getColumnCount();
            while (orign.next()) {
                orignValues = new ArrayList<Object>();
                for (int i = 1; i <= columnNum; ++i) {
                    if (this.checkNumberType(meta.getColumnTypeName(i)).booleanValue()) {
                        int getPrecision = meta.getPrecision(i);
                        int getScale = meta.getScale(i);
                        if (getScale == 0) {
                            if (getPrecision > 10 && getPrecision <= 20) {
                                Long columnLong = orign.getLong(clomuns[i - 1]);
                                orignValues.add(i - 1, columnLong);
                                continue;
                            }
                            if (getPrecision <= 10) {
                                Integer columnInt = orign.getInt(clomuns[i - 1]);
                                orignValues.add(i - 1, columnInt);
                                continue;
                            }
                        }
                        if (getScale == -127) {
                            BigDecimal columnFloat = orign.getBigDecimal(clomuns[i - 1]);
                            orignValues.add(i - 1, columnFloat);
                            continue;
                        }
                        if (getScale > 0) {
                            BigDecimal columnBigDecimal = orign.getBigDecimal(clomuns[i - 1]);
                            orignValues.add(i - 1, columnBigDecimal);
                            continue;
                        }
                    }
                    if (this.checkJavaStringType(meta.getColumnTypeName(i)).booleanValue()) {
                        String columnString = orign.getString(clomuns[i - 1]);
                        orignValues.add(i - 1, columnString);
                        continue;
                    }
                    if (this.checkFloatType(meta.getColumnTypeName(i)).booleanValue()) {
                        BigDecimal columnFloat = orign.getBigDecimal(clomuns[i - 1]);
                        orignValues.add(i - 1, columnFloat);
                        continue;
                    }
                    if (this.checkJavaBytesType(meta.getColumnTypeName(i)).booleanValue()) {
                        byte[] columnBytes = orign.getBytes(clomuns[i - 1]);
                        orignValues.add(i - 1, columnBytes);
                        continue;
                    }
                    if (this.checkDateType(meta.getColumnTypeName(i)).booleanValue()) {
                        LocalDate localDate = orign.getDate(clomuns[i - 1]).toLocalDate();
                        orignValues.add(i - 1, localDate);
                        continue;
                    }
                    if (!this.checkTimestampType(meta.getColumnTypeName(i)).booleanValue()) continue;
                    LocalDateTime localDateTime = orign.getTimestamp(clomuns[i - 1]).toLocalDateTime();
                    orignValues.add(i - 1, localDateTime);
                }
                orignResult.add(orignValues);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return orignResult;
    }

    @Override
    public Map<String, String> searchColumnAnnationInfos(String tableName, String[] searchColumns) {
        HashMap<String, String> map = new HashMap<String, String>();
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        List tableFields = tableInfo.getFieldList();
        int num = searchColumns.length;
        for (String columnName : searchColumns) {
            Field tableField = ((TableFieldInfo)tableFields.stream().filter(tableFieldInfo -> columnName.equals(tableFieldInfo.getColumn())).collect(Collectors.toList()).get(0)).getField();
            if (Arrays.stream(tableField.getDeclaredAnnotations()).filter(s -> "com.jxdinfo.hussar.pinyin.annotation.PinyinSearchColumn".equals(s.annotationType().getName())).collect(Collectors.toList()).size() <= 0) continue;
            PinyinSearchColumn psc = tableField.getAnnotation(PinyinSearchColumn.class);
            map.put(columnName, psc.type());
        }
        return map;
    }

    public Boolean checkJavaStringType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(CHAR) || columnTypeName.equals(VARCHAR2) || columnTypeName.equals(NCHAR) || columnTypeName.equals(NVARCHAR2) || columnTypeName.equals(CLOB) || columnTypeName.equals(NCLOB)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkJavaBytesType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(RAW) || columnTypeName.equals(BLOB)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkDateType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(DATE)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkTimestampType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(TIMESTAMP)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkCharType(String columnTypeName) {
        boolean result = false;
        if (columnTypeName.equals(VARCHAR2) || columnTypeName.equals(CHAR) || columnTypeName.equals(NCHAR) || columnTypeName.equals(NVARCHAR2)) {
            result = true;
        }
        return result;
    }

    public Boolean checkRAWType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(RAW)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkCLOBType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(CLOB)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkBLOBType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(BLOB)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkNumberType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(NUMBER)) {
            flag = true;
        }
        return flag;
    }

    public Boolean checkFloatType(String columnTypeName) {
        boolean flag = false;
        if (columnTypeName.equals(FLOAT)) {
            flag = true;
        }
        return flag;
    }
}

