/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.permit.service.impl;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeptCommonServiceImpl {
    @Autowired
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Autowired
    private IHussarBaseUserBoService iHussarBaseUserBoService;

    public List<String> queryDeptCommonUser(String startUserId, String rolePermission) {
        if (StringUtils.isBlank((CharSequence)startUserId) || StringUtils.isBlank((CharSequence)rolePermission)) {
            return Lists.newArrayList();
        }
        List organIds = this.hussarBaseOrganizationBoService.getOrganIdsByUserIds(startUserId);
        AssertUtil.isNotEmpty((Collection)organIds, (String)"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        List sysStruUsers = this.iHussarBaseUserBoService.getStruUserByStruIds(organIds);
        AssertUtil.isNotEmpty((Collection)sysStruUsers, (String)"\u4eba\u5458\u7ec4\u7ec7\u5173\u7cfb\u4e0d\u5b58\u5728");
        List userIds = sysStruUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
        return this.iHussarBaseUserBoService.getUserIdsByUserIdsAndRolePermission(userIds, rolePermission);
    }

    public List<String> queryParentDeptUser(String startUserId, String rolePermission) {
        if (StringUtils.isBlank((CharSequence)startUserId) || StringUtils.isBlank((CharSequence)rolePermission)) {
            return Lists.newArrayList();
        }
        List organIds = this.hussarBaseOrganizationBoService.getOrganIdsByUserIds(startUserId);
        AssertUtil.isNotEmpty((Collection)organIds, (String)"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        List parentOrganIds = this.hussarBaseOrganizationBoService.getParentOrganIdsByOrganIds(organIds);
        AssertUtil.isNotEmpty((Collection)parentOrganIds, (String)"\u7236\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        List sysStruUsers = this.iHussarBaseUserBoService.getStruUserByStruIds(parentOrganIds);
        AssertUtil.isNotEmpty((Collection)sysStruUsers, (String)"\u4eba\u5458\u7ec4\u7ec7\u5173\u7cfb\u4e0d\u5b58\u5728");
        List userIds = sysStruUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
        return this.iHussarBaseUserBoService.getUserIdsByUserIdsAndRolePermission(userIds, rolePermission);
    }
}

