/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.permit.service.impl;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeptCommonServiceImpl {
    @Autowired
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Autowired
    private IHussarBaseUserBoService iHussarBaseUserBoService;

    public List<String> queryDeptCommonUser(String startUserId, String rolePermission) {
        if (StringUtils.isBlank((CharSequence)startUserId) || StringUtils.isBlank((CharSequence)rolePermission)) {
            return Lists.newArrayList();
        }
        List organIds = this.hussarBaseOrganizationBoService.getOrganIdsByUserIds(startUserId);
        if (HussarUtils.isEmpty((Object)organIds)) {
            return Lists.newArrayList();
        }
        List sysStruUsers = this.iHussarBaseUserBoService.getStruUserByStruIds(organIds);
        if (HussarUtils.isEmpty((Object)sysStruUsers)) {
            return Lists.newArrayList();
        }
        List userIds = sysStruUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
        return this.iHussarBaseUserBoService.getUserIdsByUserIdsAndRolePermission(userIds, rolePermission);
    }

    public List<String> queryParentDeptUser(String startUserId, String rolePermission) {
        if (StringUtils.isBlank((CharSequence)startUserId) || StringUtils.isBlank((CharSequence)rolePermission)) {
            return Lists.newArrayList();
        }
        List organIds = this.hussarBaseOrganizationBoService.getOrganIdsByUserIds(startUserId);
        if (HussarUtils.isEmpty((Object)organIds)) {
            return Lists.newArrayList();
        }
        List parentOrganIds = this.hussarBaseOrganizationBoService.getParentOrganIdsByOrganIds(organIds);
        if (HussarUtils.isEmpty((Object)parentOrganIds)) {
            return Lists.newArrayList();
        }
        List sysStruUsers = this.iHussarBaseUserBoService.getStruUserByStruIds(parentOrganIds);
        if (HussarUtils.isEmpty((Object)sysStruUsers)) {
            return Lists.newArrayList();
        }
        List userIds = sysStruUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
        return this.iHussarBaseUserBoService.getUserIdsByUserIdsAndRolePermission(userIds, rolePermission);
    }
}

