/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.operations.monitor.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class IpUtils {
    public static String CURRENT_IP;
    public static String CURRENT_HOSTNAME;

    public static String getHostIp() {
        return CURRENT_IP;
    }

    public static String getHostName() {
        return CURRENT_HOSTNAME;
    }

    public static InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                if (ifc.getIndex() < lowest || result == null) {
                    lowest = ifc.getIndex();
                } else if (result != null) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    result = address;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        InetAddress result = IpUtils.findFirstNonLoopbackAddress();
        if (result != null) {
            CURRENT_IP = result.getHostAddress();
            CURRENT_HOSTNAME = result.getHostName();
        } else {
            CURRENT_IP = "127.0.0.1";
            CURRENT_HOSTNAME = "localhost";
        }
    }
}

