/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ocr.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.hussar.ocr.dto.OcrDto;
import com.jxdinfo.hussar.ocr.service.OcrService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@HussarTokenDs
public class OcrServiceImpl
implements OcrService {
    private static Logger logger = LoggerFactory.getLogger(OcrServiceImpl.class);

    @Deprecated
    public ApiResponse<JSONObject> distinguish(MultipartFile multipartFile, String url, String paramName) {
        OcrDto ocrDto = new OcrDto();
        ocrDto.setParamName(paramName);
        ocrDto.setUrl(url);
        return this.distinguish(multipartFile, ocrDto);
    }

    public ApiResponse<JSONObject> distinguish(MultipartFile multipartFile, OcrDto ocrDto) {
        String result = "";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        JSONObject jsonObject = null;
        JSONObject convertedJson = new JSONObject();
        CloseableHttpResponse response = null;
        try {
            File file = new File("");
            File tempFile = new File(file.getCanonicalPath() + "\\" + multipartFile.getOriginalFilename());
            multipartFile.transferTo(tempFile);
            HttpPost httpPost = new HttpPost(ocrDto.getUrl());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
            builder.addBinaryBody(ocrDto.getParamName(), tempFile, ContentType.MULTIPART_FORM_DATA, multipartFile.getOriginalFilename());
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
            jsonObject = JSONObject.parseObject((String)result);
            for (Map.Entry kv : jsonObject.entrySet()) {
                convertedJson.put(OcrServiceImpl.getHumpStr((String)kv.getKey()), kv.getValue());
            }
            httpClient.close();
            response.close();
            if (tempFile != null && !FileUtils.deleteQuietly((File)tempFile)) {
                logger.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return ApiResponse.success((int)200, (Object)convertedJson, (String)"");
    }

    private static String getHumpStr(String source) {
        if (StringUtils.isNotBlank((CharSequence)source)) {
            if (source.contains("_")) {
                Optional<String> reduced = Stream.of(source.split("_")).reduce((s1, s2) -> OcrServiceImpl.firstLowerCase(s1) + OcrServiceImpl.firstUpperCase(s2));
                if (reduced.isPresent()) {
                    return reduced.get();
                }
                return "undefined";
            }
            return OcrServiceImpl.firstLowerCase(source);
        }
        return "undefined";
    }

    private static String firstUpperCase(String source) {
        if (StringUtils.isNotBlank((CharSequence)source)) {
            char[] cs = source.toCharArray();
            if (Character.isLowerCase(cs[0])) {
                cs[0] = Character.toUpperCase(cs[0]);
                return String.valueOf(cs);
            }
            return String.valueOf(cs);
        }
        return source;
    }

    private static String firstLowerCase(String source) {
        if (StringUtils.isNotBlank((CharSequence)source)) {
            char[] cs = source.toCharArray();
            if (Character.isUpperCase(cs[0])) {
                cs[0] = Character.toLowerCase(cs[0]);
                return String.valueOf(cs);
            }
            return String.valueOf(cs);
        }
        return source;
    }
}

