/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.notice.dao.MyMessageMapper;
import com.jxdinfo.hussar.notice.enums.NoticeTipEnum;
import com.jxdinfo.hussar.notice.model.SysMessageAttachment;
import com.jxdinfo.hussar.notice.model.SysMessageDetail;
import com.jxdinfo.hussar.notice.service.IMyMessageAttachmentService;
import com.jxdinfo.hussar.notice.service.IMyMessageService;
import com.jxdinfo.hussar.notice.vo.SysMessageNewVo;
import com.jxdinfo.hussar.notice.vo.SysMessageVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.notice.service.impl.myMessageServiceImpl")
public class MyMessageServiceImpl
extends HussarServiceImpl<MyMessageMapper, SysMessageDetail>
implements IMyMessageService {
    private static final String READ_FLAG = "0";
    @Autowired
    private IMyMessageAttachmentService myMessageAttachmentService;
    @Resource
    private MyMessageMapper myMessageMapper;
    @Resource
    private ISysDicRefService sysDicRefService;

    public IPage<SysMessageVo> listHomeMessage(Page page, String messageTitle, String releaseDate) {
        LocalDateTime releaseDateQueryStart = null;
        LocalDateTime releaseDateQueryEnd = null;
        if (HussarUtils.isNotEmpty((Object)releaseDate)) {
            releaseDate = releaseDate + " 00:00:00";
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            releaseDateQueryStart = LocalDateTime.parse(releaseDate, formatter);
            releaseDateQueryEnd = LocalDateTime.of(LocalDate.from(releaseDateQueryStart), LocalTime.MAX);
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long userId = securityUser.getUserId();
        List<SysMessageVo> list = this.myMessageMapper.queryHomeMessage(page, userId, messageTitle, releaseDateQueryStart, releaseDateQueryEnd);
        List dicLevelTreeVoList = this.sysDicRefService.getLevelDictByTypeName("message_type");
        Map<String, String> map = dicLevelTreeVoList.stream().collect(Collectors.toMap(DicLevelTreeVo::getValue, DicLevelTreeVo::getLabel));
        list.stream().forEach(a -> {
            if (HussarUtils.isNotEmpty((Object)a.getMessageTypeId())) {
                a.setMessageType((String)map.get(String.valueOf(a.getMessageTypeId())));
            }
        });
        page.setRecords(list);
        return page;
    }

    public ApiResponse countMessageNum() {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long userId = securityUser.getUserId();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysMessageDetail::getPeopleId, (Object)userId);
        queryWrapper.eq(SysMessageDetail::getReadFlag, (Object)READ_FLAG);
        return ApiResponse.success((Object)this.list((Wrapper)queryWrapper).size());
    }

    @HussarTransactional
    public ApiResponse<String> updateRead() {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long userId = securityUser.getUserId();
        List sysMessageDetails = this.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysMessageDetail::getPeopleId, (Object)userId)).eq(SysMessageDetail::getReadFlag, (Object)READ_FLAG));
        if (HussarUtils.isNotEmpty((Object)sysMessageDetails)) {
            List sysMessageDetailIds = sysMessageDetails.stream().map(SysMessageDetail::getId).collect(Collectors.toList());
            boolean update = super.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SysMessageDetail::getId, sysMessageDetailIds)).set(SysMessageDetail::getReadFlag, (Object)"1")).set(SysMessageDetail::getReadTime, (Object)LocalDateTime.now()));
            if (update) {
                return ApiResponse.success((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_ALL_READ_SET_SUCCESS.getMessage()));
            }
            return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_ALL_READ_SET_FAILED.getMessage()));
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_NO_UNREAD_MESSAGE.getMessage()));
    }

    public ApiResponse getMessage(Long id) {
        SysMessageVo sysMessageVo = this.myMessageMapper.getMessage(id);
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysMessageDetail::getId, (Object)id)).set(SysMessageDetail::getReadFlag, (Object)"1"));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysMessageAttachment::getMessageId, (Object)sysMessageVo.getMessageId());
        List list = this.myMessageAttachmentService.list((Wrapper)queryWrapper);
        sysMessageVo.setMessageAttachments(list);
        return ApiResponse.success((Object)sysMessageVo);
    }

    public ApiResponse deleteMessageById(List<Long> ids) {
        this.removeByIds(ids);
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)NoticeTipEnum.NOTICE_DELETE_SUCCESS.getMessage()));
    }

    public ApiResponse<Page<SysMessageNewVo>> listMessageDataByCondition(PageInfo pageInfo, String type, String messageContent, String releaseStartDate, String releaseEndDate, String messageTypeId) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        LocalDateTime releaseDateStart = null;
        LocalDateTime releaseDateEnd = null;
        String regularDateTime = "^(\\d{4})-([0-1]\\d)-([0-3]\\d)\\s([0-5]\\d):([0-5]\\d):([0-5]\\d)$";
        if (HussarUtils.isNotEmpty((Object)releaseStartDate)) {
            releaseDateStart = Pattern.matches(regularDateTime, releaseStartDate) ? LocalDateTime.parse(releaseStartDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : LocalDate.parse(releaseStartDate).atStartOfDay();
        }
        if (HussarUtils.isNotEmpty((Object)releaseEndDate)) {
            releaseDateEnd = Pattern.matches(regularDateTime, releaseEndDate) ? LocalDateTime.parse(releaseEndDate, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : LocalDate.parse(releaseEndDate).atTime(LocalTime.MAX);
        }
        Long userId = BaseSecurityUtil.getUser().getUserId();
        List<SysMessageNewVo> sysMessageNewVos = this.myMessageMapper.listMessageDataByCondition((Page<SysMessageNewVo>)page, type, userId, SqlQueryUtil.transferSpecialChar((String)messageContent), releaseDateStart, releaseDateEnd, HussarUtils.isNotEmpty((Object)messageTypeId) ? Long.valueOf(messageTypeId) : null);
        List dicLevelTreeVoList = this.sysDicRefService.getLevelDictByTypeName("message_type");
        Map<String, String> map = dicLevelTreeVoList.stream().collect(Collectors.toMap(DicLevelTreeVo::getValue, DicLevelTreeVo::getLabel));
        sysMessageNewVos.forEach(a -> {
            if (HussarUtils.isNotEmpty((Object)a.getMessageTypeId())) {
                a.setMessageType((String)map.get(String.valueOf(a.getMessageTypeId())));
            }
        });
        return ApiResponse.success((Object)page.setRecords(sysMessageNewVos));
    }

    @HussarTransactional
    public ApiResponse<Boolean> clickRead(Long id) {
        super.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysMessageDetail::getId, (Object)id)).set(SysMessageDetail::getReadFlag, (Object)"1")).set(SysMessageDetail::getReadTime, (Object)LocalDateTime.now()));
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    public ApiResponse<Long> getMessageNumByCondition(String type) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysMessageDetail::getPeopleId, (Object)userId);
        queryWrapper.eq(SysMessageDetail::getReadFlag, (Object)READ_FLAG);
        if ("unreadTodos".equals(type)) {
            queryWrapper.and(qw -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)qw.ne(SysMessageDetail::getBusinessAddress, (Object)"")).isNotNull(SysMessageDetail::getBusinessAddress);
            });
        }
        return ApiResponse.success((Object)this.count((Wrapper)queryWrapper));
    }
}

