/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.notice.bo.SysNoticeAttachmentBo;
import com.jxdinfo.hussar.notice.dao.MyNoticeMapper;
import com.jxdinfo.hussar.notice.dao.MyNoticeRoleDeptMapper;
import com.jxdinfo.hussar.notice.dto.AddSysNoticeDto;
import com.jxdinfo.hussar.notice.enums.NoticeEnums;
import com.jxdinfo.hussar.notice.model.SysNotice;
import com.jxdinfo.hussar.notice.model.SysNoticeAttachment;
import com.jxdinfo.hussar.notice.model.SysNoticeRoleDept;
import com.jxdinfo.hussar.notice.service.IMyNoticeAttachmentService;
import com.jxdinfo.hussar.notice.service.IMyNoticeRoleDeptService;
import com.jxdinfo.hussar.notice.service.IMyNoticeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.notice.service.impl.MyNoticeServiceImpl")
public class MyNoticeServiceImpl
extends HussarServiceImpl<MyNoticeMapper, SysNotice>
implements IMyNoticeService {
    @Resource
    private MyNoticeMapper myNoticeMapper;
    @Resource
    private IMyNoticeAttachmentService myNoticeAttachmentService;
    @Resource
    private MyNoticeRoleDeptMapper myNoticeRoleDeptMapper;
    @Autowired
    private IMyNoticeRoleDeptService myNoticeRoleDeptService;

    public IPage<SysNotice> listHomeNotice(Page page) {
        LocalDateTime nowTime = LocalDateTime.now();
        if (BaseSecurityUtil.isAdmin()) {
            page.setRecords(this.myNoticeMapper.listAllNotice(page, nowTime));
        } else {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            Long deptId = securityUser.getDeptId();
            List roleIds = securityUser.getRolesList();
            if (HussarUtils.isNotEmpty((Object)roleIds)) {
                page.setRecords(this.myNoticeMapper.listHomeNotice(page, deptId, nowTime, roleIds));
            }
        }
        return page;
    }

    @HussarTransactional
    public ApiResponse deleteNoticeById(List<Long> ids) {
        if (this.removeByIds(ids)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"notice_id", ids);
            if (this.myNoticeRoleDeptService.deleteNoticeRoleDept(ids) && this.myNoticeAttachmentService.deleteNoticeAtt(ids)) {
                return ApiResponse.success((String)NoticeEnums.NOTICE_DELETE_SUCCESS.getValue());
            }
            throw new HussarException(NoticeEnums.NOTICE_DELETE_FAIL.getValue());
        }
        return ApiResponse.success((String)NoticeEnums.NOTICE_DELETE_FAIL_2.getValue());
    }

    public IPage<SysNotice> listNotice(Page page, String noticeTitle, String releaseDate) {
        Long userId = BaseSecurityUtil.getUser().getId();
        Long deptId = BaseSecurityUtil.getUser().getDeptId();
        String position = this.myNoticeMapper.getUserPositionByUserId(userId);
        boolean isAdminFlag = BaseSecurityUtil.isAdmin();
        LocalDate releaseDateQueryStart = null;
        LocalDate releaseDateQueryEnd = null;
        if (HussarUtils.isNotEmpty((Object)releaseDate)) {
            releaseDateQueryStart = LocalDate.parse(releaseDate);
            releaseDateQueryEnd = releaseDateQueryStart.plusDays(1L);
        }
        if (!isAdminFlag) {
            if ("1".equals(position)) {
                page.setRecords(this.myNoticeMapper.listNotice(page, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, deptId, null));
            } else {
                page.setRecords(this.myNoticeMapper.listNotice(page, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, null, userId));
            }
        } else {
            page.setRecords(this.myNoticeMapper.listNotice(page, noticeTitle, releaseDateQueryStart, releaseDateQueryEnd, null, null));
        }
        return page;
    }

    public ApiResponse getNotice(Long id) {
        SysNotice sysNotice = (SysNotice)this.myNoticeMapper.selectById(id);
        return ApiResponse.success((Object)sysNotice);
    }

    public ApiResponse getNotice(String id) {
        return this.getNotice(Long.parseLong(id));
    }

    @HussarTransactional
    public ApiResponse insertOrUpdate(SysNotice sysNotice) {
        this.saveOrUpdate((BaseEntity)sysNotice);
        Long noticeId = sysNotice.getNoticeId();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysNoticeRoleDept::getNoticeId, (Object)noticeId);
        if (this.myNoticeRoleDeptMapper.delete((Wrapper)queryWrapper) >= 0) {
            SysNoticeRoleDept sysNoticeRoleDept = new SysNoticeRoleDept();
            sysNoticeRoleDept.setNoticeId(noticeId);
            sysNoticeRoleDept.setCreator(sysNotice.getCreator());
            sysNoticeRoleDept.setCreateTime(sysNotice.getCreateTime());
            sysNoticeRoleDept.setLastTime(sysNotice.getLastTime());
            sysNoticeRoleDept.setLastEditor(sysNotice.getLastEditor());
            if (ToolUtil.isNotEmpty((Object)sysNotice.getDepartmentId())) {
                sysNoticeRoleDept.setNoticeScopeType("department");
                String[] deptIds = sysNotice.getDepartmentId().split(",");
                ArrayList<SysNoticeRoleDept> saveList = new ArrayList<SysNoticeRoleDept>();
                for (String id : deptIds) {
                    SysNoticeRoleDept noticeRoleDept = new SysNoticeRoleDept();
                    CopyPropertieUtils.copyProperties((Object)noticeRoleDept, (Object)sysNoticeRoleDept);
                    Long deptId = new Long(id);
                    noticeRoleDept.setNoticeBusinessId(deptId);
                    noticeRoleDept.setId(null);
                    saveList.add(noticeRoleDept);
                }
                if (!this.myNoticeRoleDeptService.saveBatch(saveList)) {
                    throw new HussarException(NoticeEnums.NOTICE_SAVE_FAIL.getValue());
                }
            }
            if (ToolUtil.isNotEmpty((Object)sysNotice.getRoleId())) {
                sysNoticeRoleDept.setNoticeScopeType("role");
                String[] roleIds = sysNotice.getRoleId().split(",");
                ArrayList<SysNoticeRoleDept> sysNoticeRoleDeptList = new ArrayList<SysNoticeRoleDept>();
                for (String id : roleIds) {
                    SysNoticeRoleDept sysNoticeRole = new SysNoticeRoleDept();
                    CopyPropertieUtils.copyProperties((Object)sysNoticeRole, (Object)sysNoticeRoleDept);
                    Long roleId = new Long(id);
                    sysNoticeRole.setNoticeBusinessId(roleId);
                    sysNoticeRole.setId(null);
                    sysNoticeRoleDeptList.add(sysNoticeRole);
                }
                if (!this.myNoticeRoleDeptService.saveBatch(sysNoticeRoleDeptList)) {
                    throw new HussarException(NoticeEnums.NOTICE_SAVE_FAIL.getValue());
                }
            }
        }
        return ApiResponse.success((Object)noticeId);
    }

    public ApiResponse listNoticeAtt(Long id) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysNoticeAttachment::getNoticeId, (Object)id);
        List list = this.myNoticeAttachmentService.list((Wrapper)queryWrapper);
        return ApiResponse.success((Object)list);
    }

    public ApiResponse listNoticeAtt(String id) {
        return this.listNoticeAtt(Long.parseLong(id));
    }

    public ApiResponse saveSysNotice(AddSysNoticeDto addSysNoticeDto) {
        if (HussarUtils.isNotEmpty((Object)addSysNoticeDto)) {
            SysNotice sysNotice = new SysNotice();
            BeanUtils.copyProperties((Object)addSysNoticeDto, (Object)sysNotice);
            this.insertOrUpdate(sysNotice);
            SysNoticeAttachmentBo sysNoticeAttachmentBo = new SysNoticeAttachmentBo();
            sysNoticeAttachmentBo.setNoticeAttachmentId(addSysNoticeDto.getNoticeAttachmentId());
            sysNoticeAttachmentBo.setNoticeId(sysNotice.getNoticeId());
            this.myNoticeAttachmentService.insertOrUpdate(sysNoticeAttachmentBo);
            return ApiResponse.success((String)NoticeEnums.NOTICE_SAVE_SUCCESS.getValue());
        }
        return ApiResponse.fail((String)NoticeEnums.NOTICE_INFO_IS_EMPTY.getValue());
    }
}

