/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.nocode.upgrade.v191pretov191.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.FilterField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowField;
import com.jxdinfo.hussar.formdesign.no.code.business.dao.CustomViewMapper;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.CustomView;
import com.jxdinfo.hussar.nocode.upgrade.v191pretov191.service.IUpgradeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.nocode.upgrade.v191pretov191.service.impl.UpgradeServiceImpl")
public class UpgradeServiceImpl
implements IUpgradeService {
    private Logger LOGGER = LoggerFactory.getLogger(UpgradeServiceImpl.class);
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private CustomViewMapper customViewMapper;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ISysFormService sysFormService;
    @Autowired
    private FormDesignProperties formDesignProperties;
    public static final String CANVAS_PATH = "canvas";
    public static final String CANVAS_SUFFIX = ".fd";

    private String getRoot() {
        return FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), this.formDesignProperties.getBackProjectPath(), this.formDesignProperties.getNoCodeStore()});
    }

    @Override
    @HussarTokenDs
    public ApiResponse<String> rePublishForm(String formIds) {
        List sysForms = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)formIds)) {
            String[] split = formIds.split(",");
            List _formIds = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
            sysForms = this.sysFormMapper.selectBatchIds(_formIds);
        } else {
            sysForms = this.sysFormMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysForm::getFormStatus, (Object)"0")).ne(SysForm::getFormType, (Object)"3"));
        }
        ArrayList retrySysForms = new ArrayList();
        int total = sysForms.size();
        this.LOGGER.info("\u5c06\u8981\u8fdb\u884c\u5237\u65b0\u7684\u6240\u6709\u8868\u5355\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)sysForms));
        AtomicInteger deal = new AtomicInteger();
        AtomicInteger fail = new AtomicInteger();
        AtomicInteger success = new AtomicInteger();
        CountDownLatch countDownLatch = new CountDownLatch(total);
        sysForms.forEach(sysForm -> {
            deal.getAndIncrement();
            if (!this.republish((SysForm)sysForm)) {
                retrySysForms.add(sysForm);
                fail.incrementAndGet();
            } else {
                success.incrementAndGet();
            }
            countDownLatch.countDown();
            this.LOGGER.info("\u603b\u5171\uff1a{}, \u5df2\u5904\u7406\uff1a{}, \u6210\u529f: {}, \u5931\u8d25\uff1a{}", new Object[]{total, deal.get(), success.get(), fail.get()});
        });
        HussarCacheUtil.evictKeysLike((String)"workflow_bpmn_model_cache.master", (String)"bpm");
        HussarCacheUtil.evictKeysLike((String)"workflow_file", (String)"bpm");
        HussarCacheUtil.evictKeysLike((String)"workflow_process_def_id", (String)"bpm");
        HussarCacheUtil.evictKeysLike((String)"workflow_process_definition_cache.master", (String)"bpm");
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.LOGGER.error("\u5237\u65b0\u8868\u5355\u5f02\u5e38", (Throwable)e);
        }
        int retryTimes = 0;
        while (retrySysForms.size() > 0 && retryTimes <= 2) {
            this.LOGGER.info("\u5237\u65b0\u8868\u5355\uff0c\u91cd\u8bd5\u7b2c{}\u6b21\uff0c\u6570\u91cf\uff1a{}", (Object)(++retryTimes), (Object)retrySysForms.size());
            Iterator iterator = retrySysForms.iterator();
            while (iterator.hasNext()) {
                SysForm next = (SysForm)iterator.next();
                if (!this.republish(next)) continue;
                success.incrementAndGet();
                fail.decrementAndGet();
                iterator.remove();
            }
        }
        if (retrySysForms.size() > 0) {
            List failedFormIds = retrySysForms.stream().map(SysForm::getId).collect(Collectors.toList());
            this.LOGGER.info("\u5237\u65b0\u8868\u5355\u91cd\u8bd5{}\u6b21\u540e\uff0c\u5931\u8d25\u8868\u5355\u6570\u91cf\uff1a{}, formIds: {}", new Object[]{retryTimes, retrySysForms.size(), StringUtil.join(failedFormIds, (String)",")});
        }
        List customViews = this.customViewMapper.selectList((Wrapper)new LambdaQueryWrapper());
        for (CustomView customView : customViews) {
            if (HussarUtils.isEmpty((Object)customView.getFilterFields())) {
                List showFields = JSONObject.parseArray((String)customView.getShowFields(), ShowField.class);
                List filterFields = showFields.stream().map(showField -> {
                    FilterField filterField = new FilterField();
                    filterField.setName(showField.getName());
                    filterField.setTitle(showField.getTitle());
                    return filterField;
                }).collect(Collectors.toList());
                customView.setFilterFields(JSONObject.toJSONString(filterFields));
            }
            Map<String, Integer> styles = new HashMap();
            styles = (Map)JSON.parseObject((String)customView.getStyles(), HashMap.class);
            if (HussarUtils.isEmpty(styles.get("clickDataTitle"))) {
                styles.put("clickDataTitle", 1);
            }
            if (HussarUtils.isEmpty(styles.get("clickRow"))) {
                styles.put("clickRow", 0);
            }
            if (HussarUtils.isEmpty(styles.get("triggerModeType"))) {
                styles.put("triggerModeType", 0);
            }
            if (HussarUtils.isEmpty(styles.get("drawerOrientations"))) {
                styles.put("drawerOrientations", 0);
            }
            if (HussarUtils.isEmpty(styles.get("showOperationColumn"))) {
                styles.put("showOperationColumn", 1);
            }
            customView.setStyles(JSON.toJSONString(styles));
            this.customViewMapper.update((Object)customView, (Wrapper)new LambdaQueryWrapper().eq(CustomView::getViewId, (Object)customView.getViewId()));
        }
        return ApiResponse.success((String)StringUtils.format((String)"\u603b\u5171\u8868\u5355\u6570\uff1a%s, \u5904\u7406\u8868\u5355\u6570\uff1a%s, \u6210\u529f\u6570\uff1a%s, \u5931\u8d25\u6570\uff1a%s", (Object[])new Object[]{total, deal, success, fail}));
    }

    @Override
    @HussarTokenDs
    public void updateFormFilePath(String appIdsStr, String formIdsStr) throws IOException {
        String root = this.getRoot();
        List formList = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)appIdsStr) || HussarUtils.isNotEmpty((Object)formIdsStr)) {
            String[] split;
            List appIds = null;
            List formIds = null;
            if (HussarUtils.isNotEmpty((Object)appIdsStr)) {
                split = appIdsStr.split(",");
                appIds = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
            }
            if (HussarUtils.isNotEmpty((Object)formIdsStr)) {
                split = formIdsStr.split(",");
                formIds = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
            }
            if (HussarUtils.isNotEmpty(appIds)) {
                queryWrapper.in(SysForm::getAppId, appIds);
            }
            if (HussarUtils.isNotEmpty(appIds) && HussarUtils.isNotEmpty(formIds)) {
                queryWrapper.or();
            }
            if (HussarUtils.isNotEmpty(formIds)) {
                queryWrapper.in(SysForm::getId, formIds);
            }
        }
        if (HussarUtils.isEmpty(formList = this.sysFormService.list((Wrapper)queryWrapper))) {
            return;
        }
        for (SysForm sysForm : formList) {
            String id;
            File metaFile;
            JSONObject data;
            String meta;
            Path metaPath;
            Long appId = sysForm.getAppId();
            Long formId = sysForm.getId();
            String tableName = sysForm.getTableName();
            String formPathStr = FileUtil.posixPath((String[])new String[]{root, String.valueOf(appId), tableName});
            Path formPath = Paths.get(formPathStr, new String[0]);
            if (!Files.exists(formPath, new LinkOption[0]) || !Files.exists(metaPath = Paths.get(meta = FileUtil.posixPath((String[])new String[]{formPathStr, CANVAS_PATH, tableName + CANVAS_SUFFIX + ".meta"}), new String[0]), new LinkOption[0]) || HussarUtils.isEmpty((Object)(data = JSONObject.parseObject((String)FileUtils.readFileToString((File)(metaFile = new File(meta)), (Charset)StandardCharsets.UTF_8)))) || HussarUtils.isBlank((CharSequence)(id = (String)data.get((Object)"id"))) || !HussarUtils.equals((Object)id, (Object)String.valueOf(formId))) continue;
            Path newFormPath = Paths.get(FileUtil.posixPath((String[])new String[]{root, String.valueOf(appId), id}), new String[0]);
            if (Files.exists(newFormPath, new LinkOption[0])) {
                String rollBackParam = FileUtil.posixPath((String[])new String[]{root, "rollback", String.valueOf(appId)});
                Path rollBackParamPath = Paths.get(rollBackParam, new String[0]);
                File rollBackParamFile = rollBackParamPath.toFile();
                if (!rollBackParamFile.exists()) {
                    rollBackParamFile.mkdirs();
                }
                Files.move(newFormPath, Paths.get(FileUtil.posixPath((String[])new String[]{rollBackParam, id}), new String[0]), new CopyOption[0]);
            }
            Files.move(formPath, newFormPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private boolean republish(SysForm sysForm) {
        if ("3".equals(sysForm.getFormType()) || "2".equals(sysForm.getFormType()) || "0".equals(sysForm.getFormType())) {
            return true;
        }
        try {
            FormCanvasSchema oldCanvas = (FormCanvasSchema)this.canvasService.get(sysForm.getId().toString()).getData();
            FormCanvasSchema newCanvas = new FormCanvasSchema();
            BeanUtils.copyProperties((Object)oldCanvas, (Object)newCanvas);
            newCanvas.setVersion(oldCanvas.getVersion() + 1);
            FormDesignResponse saveCanvasResponse = this.canvasService.saveCanvas(newCanvas);
            if (!((Boolean)saveCanvasResponse.getData()).booleanValue()) {
                AppContextUtil.setAppId(null);
                return false;
            }
            AppContextUtil.setAppId(null);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.error("\u8868\u5355[{} - {}]\u66f4\u65b0\u5931\u8d25, \u5931\u8d25\u539f\u56e0: {}", new Object[]{sysForm.getId(), sysForm.getTableName(), e, e});
            return false;
        }
    }
}

