/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.nocode.upgrade.v191tov192.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.dao.CustomViewMapper;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.nocode.upgrade.v191tov192.service.IUpgradeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.util.TenantCommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.nocode.upgrade.v191tov192.service.impl.UpgradeServiceImpl")
public class UpgradeServiceImpl
implements IUpgradeService {
    private final Logger LOGGER = LoggerFactory.getLogger(UpgradeServiceImpl.class);
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private CustomViewMapper customViewMapper;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private CanvasService canvasService;

    @Override
    @HussarTokenDs
    public ApiResponse<String> rePublishForm(String formIds) {
        String tCode = TenantCommonUtil.getTenantCodeByUrl();
        if (HussarUtils.isBlank((CharSequence)tCode)) {
            tCode = "master";
        }
        return this.rePublishFormExecutor(formIds, tCode);
    }

    @Override
    @HussarTokenDs
    public void updateFormIdValue(String formIds) {
        List sysForms;
        if (HussarUtils.isNotEmpty((Object)formIds)) {
            String[] split = formIds.split(",");
            List longFormIds = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
            sysForms = this.sysFormMapper.selectBatchIds(longFormIds);
        } else {
            sysForms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().ne(SysForm::getFormType, (Object)"3"));
        }
        if (CollectionUtil.isEmpty((Collection)sysForms)) {
            return;
        }
        for (SysForm currentForm : sysForms) {
            try {
                this.sysFormMapper.updateFormIdValue(currentForm.getTableName(), currentForm.getId());
                this.LOGGER.info("\u8868\u5355\u3010{}\u3011\u66f4\u65b0FORM_ID\u6210\u529f", (Object)currentForm.getId());
            }
            catch (Exception e) {
                this.LOGGER.error("\u66f4\u65b0\u8868\u5355\u3010{}\u3011,\u7269\u7406\u8868\u3010{}\u3011,\u5931\u8d25\uff1a{}", new Object[]{currentForm.getId(), currentForm.getTableName(), e.getMessage()});
            }
        }
    }

    private ApiResponse<String> rePublishFormExecutor(String formIds, String tCode) {
        List sysForms = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)formIds)) {
            String[] split = formIds.split(",");
            List _formIds = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
            sysForms = this.sysFormMapper.selectBatchIds(_formIds);
        } else {
            sysForms = this.sysFormMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysForm::getFormStatus, (Object)"0")).ne(SysForm::getFormType, (Object)"3"));
        }
        ArrayList retrySysForms = new ArrayList();
        int total = sysForms.size();
        this.LOGGER.info("tCode:{}, \u5c06\u8981\u8fdb\u884c\u5237\u65b0\u7684\u6240\u6709\u8868\u5355\u4fe1\u606f:{}", (Object)tCode, (Object)JSONObject.toJSONString((Object)sysForms));
        AtomicInteger deal = new AtomicInteger();
        AtomicInteger fail = new AtomicInteger();
        AtomicInteger success = new AtomicInteger();
        CountDownLatch countDownLatch = new CountDownLatch(total);
        sysForms.forEach(sysForm -> {
            deal.getAndIncrement();
            if (!this.republish((SysForm)sysForm)) {
                retrySysForms.add(sysForm);
                fail.incrementAndGet();
            } else {
                success.incrementAndGet();
            }
            countDownLatch.countDown();
            this.LOGGER.info("tCode: {}, \u603b\u5171\uff1a{}, \u5df2\u5904\u7406\uff1a{}, \u6210\u529f: {}, \u5931\u8d25\uff1a{}", new Object[]{tCode, total, deal.get(), success.get(), fail.get()});
        });
        HussarCacheUtil.evictKeysLike((String)"workflow_bpmn_model_cache.master", (String)"bpm");
        HussarCacheUtil.evictKeysLike((String)"workflow_file", (String)"bpm");
        HussarCacheUtil.evictKeysLike((String)"workflow_process_def_id", (String)"bpm");
        HussarCacheUtil.evictKeysLike((String)"workflow_process_definition_cache.master", (String)"bpm");
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            this.LOGGER.error("tCode:{}, \u5237\u65b0\u8868\u5355\u5f02\u5e38", (Object)tCode, (Object)e);
        }
        int retryTimes = 0;
        while (retrySysForms.size() > 0 && retryTimes <= 2) {
            this.LOGGER.info("tCode:{}, \u5237\u65b0\u8868\u5355\uff0c\u91cd\u8bd5\u7b2c{}\u6b21\uff0c\u6570\u91cf\uff1a{}", new Object[]{tCode, ++retryTimes, retrySysForms.size()});
            Iterator iterator = retrySysForms.iterator();
            while (iterator.hasNext()) {
                SysForm next = (SysForm)iterator.next();
                if (!this.republish(next)) continue;
                success.incrementAndGet();
                fail.decrementAndGet();
                iterator.remove();
            }
        }
        if (retrySysForms.size() > 0) {
            List failedFormIds = retrySysForms.stream().map(SysForm::getId).collect(Collectors.toList());
            this.LOGGER.info("tCode:{}, \u5237\u65b0\u8868\u5355\u91cd\u8bd5{}\u6b21\u540e\uff0c\u5931\u8d25\u8868\u5355\u6570\u91cf\uff1a{}, formIds: {}", new Object[]{tCode, retryTimes, retrySysForms.size(), StringUtil.join(failedFormIds, (String)",")});
        }
        return ApiResponse.success((String)StringUtils.format((String)"\u603b\u5171\u8868\u5355\u6570\uff1a%s, \u5904\u7406\u8868\u5355\u6570\uff1a%s, \u6210\u529f\u6570\uff1a%s, \u5931\u8d25\u6570\uff1a%s", (Object[])new Object[]{total, deal, success, fail}));
    }

    private boolean republish(SysForm sysForm) {
        if ("3".equals(sysForm.getFormType()) || "2".equals(sysForm.getFormType())) {
            return true;
        }
        try {
            FormCanvasSchema oldCanvas = (FormCanvasSchema)this.canvasService.get(sysForm.getId().toString()).getData();
            FormCanvasSchema newCanvas = new FormCanvasSchema();
            BeanUtils.copyProperties((Object)oldCanvas, (Object)newCanvas);
            newCanvas.setVersion(oldCanvas.getVersion() + 1);
            FormDesignResponse saveCanvasResponse = this.canvasService.saveCanvas(newCanvas);
            if (!((Boolean)saveCanvasResponse.getData()).booleanValue()) {
                AppContextUtil.setAppId(null);
                return false;
            }
            AppContextUtil.setAppId(null);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.error("\u8868\u5355[{} - {}]\u66f4\u65b0\u5931\u8d25, \u5931\u8d25\u539f\u56e0: {}", new Object[]{sysForm.getId(), sysForm.getTableName(), e, e});
            return false;
        }
    }
}

