/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.nocode.upgrade.v929tov930.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.button.dao.SysCustomButtonMapper;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.TableButton;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.TableButtonProps;
import com.jxdinfo.hussar.formdesign.no.code.business.dao.CustomViewMapper;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.CustomView;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.nocode.upgrade.v929tov930.service.IUpgradeService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.nocode.upgrade.v929tov930.service.impl.UpgradeServiceImpl")
public class UpgradeServiceImpl
implements IUpgradeService {
    private final Logger LOGGER = LoggerFactory.getLogger(UpgradeServiceImpl.class);
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private CanvasService canvasService;
    @Resource
    private CustomViewMapper customViewMapper;
    @Resource
    private CustomViewService customViewService;
    @Resource
    private SysCustomButtonMapper sysCustomButtonMapper;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private PageBuilderFactory pageBuilderFactory;
    @Resource
    private ViewSchemaService viewSchemaService;

    @Override
    @HussarTokenDs
    public void subAddSysColumn(String formIds) {
        List formIdList;
        if (HussarUtils.isEmpty((Object)formIds)) {
            List sysForms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysForm::getFormType, Arrays.asList("0", "1")));
            formIdList = sysForms.stream().map(SysForm::getId).collect(Collectors.toList());
        } else {
            String[] split = formIds.split(",");
            formIdList = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
        }
        if (HussarUtils.isEmpty(formIdList)) {
            return;
        }
        for (Long formId : formIdList) {
            FormCanvasSchema canvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
            List widgetList = canvasSchema.childTables();
            if (HussarUtils.isEmpty((Object)widgetList)) continue;
            try {
                this.rePublish(String.valueOf(formId));
            }
            catch (Exception e) {
                this.LOGGER.error("\u8868\u5355ID:" + formId + ",\u8868\u5355\u6709\u5b50\u8868,\u9700\u8981\u91cd\u65b0\u53d1\u5e03,\u53d1\u5e03\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    @Override
    public void splitViewButtonPosition() throws Exception {
        List forms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper());
        List<Long> formIds = forms.stream().map(SysForm::getId).collect(Collectors.toList());
        this.dealOperations(formIds);
    }

    private void dealOperations(List<Long> formIds) throws Exception {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysCustomButton::getFormId, formIds);
        List sysCustomButtons = this.sysCustomButtonMapper.selectList((Wrapper)queryWrapper);
        Map<Object, Object> listMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)sysCustomButtons)) {
            listMap = sysCustomButtons.stream().collect(Collectors.groupingBy(SysCustomButton::getFormId));
        }
        LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper1.in(CustomView::getFormId, formIds)).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.eq(CustomView::getCategory, (Object)"public");
        });
        List customViews = this.customViewMapper.selectList((Wrapper)queryWrapper1);
        UpgradeServiceImpl upgradeServiceImpl = this;
        List defaultOperations = ((DataView)upgradeServiceImpl.pageBuilderFactory.getDefaultViewSchema().getViews().get(0)).getOperations();
        for (Long id : formIds) {
            DataView view;
            FormViewSchema viewData = (FormViewSchema)this.viewSchemaService.get(String.valueOf(id)).getData();
            if (HussarUtils.isEmpty((Object)viewData)) continue;
            List buttons = (List)listMap.get(id);
            ArrayList<TableButton> customButtons = new ArrayList<TableButton>(defaultOperations);
            if (HussarUtils.isNotEmpty((Object)buttons)) {
                for (SysCustomButton button : buttons) {
                    boolean isDisplayDetailPage = Arrays.asList(button.getButtonPosition()).contains(1);
                    if (!isDisplayDetailPage) continue;
                    TableButton customTableButton = new TableButton();
                    customTableButton.setId(String.valueOf(button.getId()));
                    customTableButton.setName(button.getName());
                    customTableButton.setAlias(button.getAlias());
                    customTableButton.setIcon(button.getIcon());
                    customTableButton.setI18nKeys(button.getI18nKeys());
                    customTableButton.setProps(new TableButtonProps());
                    customTableButton.setType(button.getType());
                    customTableButton.setAction(button.getAction());
                    customTableButton.setChecked(true);
                    customButtons.add(customTableButton);
                }
            }
            if (HussarUtils.isEmpty((Object)(view = viewData.getViews().stream().filter(v -> HussarUtils.equals((Object)v.getName(), (Object)"\u5168\u90e8")).findAny().get()).getOperations())) {
                view.setOperations(customButtons);
            }
            this.viewSchemaService.saveOrUpdate(viewData);
            List currentCustomViews = customViews.stream().filter(c -> HussarUtils.equals((Object)c.getFormId(), (Object)id)).collect(Collectors.toList());
            if (!HussarUtils.isNotEmpty(currentCustomViews)) continue;
            for (CustomView customView : currentCustomViews) {
                if (!HussarUtils.isEmpty((Object)customView.getOperations())) continue;
                customView.setOperations(JSONObject.toJSONString(customButtons));
                this.customViewService.saveOrUpdate((Object)customView);
            }
        }
    }

    private void rePublish(String formId) throws Exception {
        FormCanvasSchema oldCanvas = (FormCanvasSchema)this.canvasService.get(formId).getData();
        FormCanvasSchema newCanvas = new FormCanvasSchema();
        BeanUtils.copyProperties((Object)oldCanvas, (Object)newCanvas);
        newCanvas.setVersion(oldCanvas.getVersion() + 1);
        this.canvasService.saveCanvas(newCanvas);
        AppContextUtil.setAppId(null);
    }
}

