/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.nocode.upgrade.v194alphatov194alpha2.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.nocode.upgrade.v194alphatov194alpha2.service.IUpgradeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.api.entity.ModelRelationship;
import com.jxdinfo.hussar.support.engine.plugin.model.service.ModelRelationshipService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.nocode.upgrade.v194alphatov194alpha2.service.impl.UpgradeServiceImpl")
public class UpgradeServiceImpl
implements IUpgradeService {
    private final Logger LOGGER = LoggerFactory.getLogger(UpgradeServiceImpl.class);
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private CanvasService canvasService;
    @Resource
    private FormOperateService operateService;
    @Resource
    private ModelRelationshipService modelRelationshipService;

    @Override
    @HussarTokenDs
    public void subAddExtraInfoColumn(String formIds) {
        List formIdList;
        if (HussarUtils.isEmpty((Object)formIds)) {
            List sysForms = this.sysFormMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysForm::getFormType, Arrays.asList("0", "1")));
            formIdList = sysForms.stream().map(SysForm::getId).collect(Collectors.toList());
        } else {
            String[] split = formIds.split(",");
            formIdList = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
        }
        if (HussarUtils.isEmpty(formIdList)) {
            return;
        }
        for (Long formId : formIdList) {
            FormCanvasSchema canvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
            List widgetList = canvasSchema.childTables();
            if (HussarUtils.isEmpty((Object)widgetList)) continue;
            for (Widget sub : widgetList) {
                String subName = sub.getName();
                try {
                    this.sysFormMapper.subAddExtraInfoColumn(subName.toUpperCase());
                }
                catch (Exception e) {
                    this.LOGGER.error("\u8868\u5355ID:" + formId + ",\u5b50\u8868\u8868\u540d:" + subName + ",\u589e\u52a0\u989d\u5916\u4fe1\u606f\u5b57\u6bb5\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
                    continue;
                }
                try {
                    this.operateService.publish(String.valueOf(formId));
                }
                catch (Exception e) {
                    this.LOGGER.error("\u8868\u5355ID:" + formId + ",\u8868\u5355\u6709\u5b50\u8868,\u9700\u8981\u91cd\u65b0\u53d1\u5e03,\u53d1\u5e03\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    @Override
    public ApiResponse<String> addIndex() {
        long start = System.currentTimeMillis();
        List modelRelationships = this.modelRelationshipService.list();
        String useTime = ToolUtil.logTime((long)start);
        this.LOGGER.info("\u67e5\u8be2\u8868\u8017\u65f6({})", (Object)useTime);
        ArrayList<String> lowTableNames = new ArrayList<String>();
        ArrayList<String> uplist = new ArrayList<String>();
        if (modelRelationships.size() > 0) {
            for (ModelRelationship m : modelRelationships) {
                if (m.getTfmodelName().startsWith("PROCESS_TASK_INFO_")) {
                    uplist.add(m.getTfmodelName());
                }
                if (!m.getTfmodelName().startsWith("process_task_info")) continue;
                lowTableNames.add(m.getTfmodelName());
            }
        }
        long start1 = System.currentTimeMillis();
        for (String s : uplist) {
            try {
                this.sysFormMapper.addIndex(s);
            }
            catch (Exception e) {
                this.LOGGER.info("\u8be5\u8868\u5df2\u6709\u7d22\u5f15", (Throwable)e);
            }
            try {
                this.sysFormMapper.addTaskIndex(s);
            }
            catch (Exception e) {
                this.LOGGER.info("\u8be5\u8868\u5df2\u6709\u7d22\u5f15", (Throwable)e);
            }
        }
        for (String s : lowTableNames) {
            try {
                this.sysFormMapper.addIndex(s);
            }
            catch (Exception e) {
                this.LOGGER.info("\u8be5\u8868\u5df2\u6709\u7d22\u5f15", (Throwable)e);
            }
            try {
                this.sysFormMapper.addIndex(s.toUpperCase());
            }
            catch (Exception e) {
                this.LOGGER.info("\u8be5\u8868\u5df2\u6709\u7d22\u5f15", (Throwable)e);
            }
            try {
                this.sysFormMapper.addTaskIndex(s);
            }
            catch (Exception e) {
                this.LOGGER.info("\u8be5\u8868\u5df2\u6709\u7d22\u5f15", (Throwable)e);
            }
            try {
                this.sysFormMapper.addTaskIndex(s.toUpperCase());
            }
            catch (Exception e) {
                this.LOGGER.info("\u8be5\u8868\u5df2\u6709\u7d22\u5f15", (Throwable)e);
            }
        }
        String useTime1 = ToolUtil.logTime((long)start1);
        this.LOGGER.info("\u6dfb\u52a0\u7d22\u5f15\u8017\u65f6({})", (Object)useTime1);
        return ApiResponse.success((String)"\u5347\u7ea7\u6210\u529f");
    }
}

