/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.no.code.message.util;

import com.jxdinfo.hussar.no.code.message.util.UUID;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.concurrent.ThreadLocalRandom;

public class IdUtil {
    public static String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static String randomUuid() {
        return UUID.randomUuid().toString();
    }

    public static String simpleUuid() {
        return UUID.randomUuid().toString(true);
    }

    public static String fastUuid() {
        return UUID.fastUuid().toString();
    }

    public static String fastSimpleUuid() {
        return UUID.fastUuid().toString(true);
    }

    public static String uuid() {
        return UUID.randomUuid().toString().replaceAll("-", "");
    }

    public static String generateShortUuid(int length) {
        StringBuffer shortBuffer = new StringBuffer();
        String uuid = IdUtil.uuid();
        for (int i = 0; i < length; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 62]);
        }
        return shortBuffer.toString();
    }

    public static String randomNumbers(int length) {
        return IdUtil.randomString("0123456789", length);
    }

    public static String randomString(String baseString, int length) {
        if (HussarUtils.isEmpty((Object)baseString)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = IdUtil.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static int randomInt(int limit) {
        return IdUtil.getRandom().nextInt(limit);
    }

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static String getAppId() {
        return IdUtil.generateShortUuid(8);
    }
}

