/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.no.code.message.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.no.code.message.dao.MsgStationTemplateMapper;
import com.jxdinfo.hussar.no.code.message.dto.MsgAppStationTemplateDto;
import com.jxdinfo.hussar.no.code.message.dto.MsgStationTemplateQueryDto;
import com.jxdinfo.hussar.no.code.message.enums.BizCodeEnum;
import com.jxdinfo.hussar.no.code.message.model.MsgStationTemplate;
import com.jxdinfo.hussar.no.code.message.service.IMsgStationTemplateService;
import com.jxdinfo.hussar.no.code.message.util.BizCodeUtils;
import com.jxdinfo.hussar.no.code.message.util.TemplateUtils;
import com.jxdinfo.hussar.no.code.message.util.UUID;
import com.jxdinfo.hussar.no.code.message.vo.MsgAppStationTemplateVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.no.code.message.service.impl.msgStationTemplateServiceImpl")
public class MsgStationTemplateServiceImpl
extends HussarServiceImpl<MsgStationTemplateMapper, MsgStationTemplate>
implements IMsgStationTemplateService {
    private static final Integer ENABLE = 1;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public ApiResponse<Page<MsgAppStationTemplateVo>> getList(PageInfo pageInfo, MsgStationTemplateQueryDto msgStationTemplateQueryDto) {
        Page msgCpTemplateVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        msgStationTemplateQueryDto.setTemplateNo(SqlQueryUtil.transferSpecialChar((String)msgStationTemplateQueryDto.getTemplateNo()));
        msgStationTemplateQueryDto.setTemplateName(SqlQueryUtil.transferSpecialChar((String)msgStationTemplateQueryDto.getTemplateName()));
        msgStationTemplateQueryDto.setContent(SqlQueryUtil.transferSpecialChar((String)msgStationTemplateQueryDto.getContent()));
        msgStationTemplateQueryDto.setTitle(SqlQueryUtil.transferSpecialChar((String)msgStationTemplateQueryDto.getTitle()));
        return ApiResponse.success(((MsgStationTemplateMapper)this.getBaseMapper()).getListPage((Page<MsgAppStationTemplateVo>)msgCpTemplateVoPage, msgStationTemplateQueryDto));
    }

    public ApiResponse<MsgAppStationTemplateVo> listById(Long id) {
        return ApiResponse.success((Object)HussarUtils.copy((Object)super.getById((Serializable)id), MsgAppStationTemplateVo.class));
    }

    public ApiResponse<List<MsgAppStationTemplateVo>> getTemplateList() {
        List msgAppStationTemplateVos = HussarUtils.copy((Collection)super.list((Wrapper)new LambdaQueryWrapper().eq(MsgStationTemplate::getOpenStatus, (Object)ENABLE)), MsgAppStationTemplateVo.class);
        for (MsgAppStationTemplateVo msgAppStationTemplateVo : msgAppStationTemplateVos) {
            String templateParams = msgAppStationTemplateVo.getTemplateParams();
            if (!HussarUtils.isNotEmpty((Object)templateParams)) continue;
            msgAppStationTemplateVo.setTemplateParamsList(Arrays.asList(templateParams.split(",")));
        }
        return ApiResponse.success((Object)msgAppStationTemplateVos);
    }

    @HussarTransactional
    public ApiResponse<Boolean> addTemplate(MsgAppStationTemplateDto msgAppStationTemplateDto) {
        String templateName = msgAppStationTemplateDto.getTemplateName();
        long count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgStationTemplate::getTemplateName, (Object)templateName));
        if (count > 0L) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0" + templateName + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
        MsgStationTemplate msgAppStationTemplate = (MsgStationTemplate)HussarUtils.copy((Object)msgAppStationTemplateDto, MsgStationTemplate.class);
        msgAppStationTemplate.setTemplateNo(BizCodeUtils.generalBizCode(BizCodeEnum.APP_Station_TEMPLATE, null));
        msgAppStationTemplate.setTemplateParams(TemplateUtils.getTemplateParams(msgAppStationTemplateDto.getContent() + msgAppStationTemplateDto.getTitle() + msgAppStationTemplateDto.getUrl()));
        String messageType = msgAppStationTemplateDto.getMessageType();
        if (StringUtils.isBlank((CharSequence)messageType)) {
            msgAppStationTemplate.setMessageType("text");
        }
        return ApiResponse.success((Object)super.save((BaseEntity)msgAppStationTemplate));
    }

    public static String uuid() {
        return UUID.randomUuid().toString().replaceAll("-", "");
    }

    @HussarTransactional
    public ApiResponse<Boolean> updateTemplate(MsgAppStationTemplateDto msgAppStationTemplateDto) {
        long count;
        String templateName = msgAppStationTemplateDto.getTemplateName();
        MsgStationTemplate msgAppStationTemplate = (MsgStationTemplate)super.getById((Serializable)msgAppStationTemplateDto.getId());
        if (!HussarUtils.equals((Object)msgAppStationTemplate.getTemplateName(), (Object)templateName) && (count = super.count((Wrapper)new LambdaQueryWrapper().eq(MsgStationTemplate::getTemplateName, (Object)templateName))) > 0L) {
            throw new HussarException("\u6a21\u677f\u540d\u79f0" + templateName + "\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
        }
        if (!HussarUtils.equals((Object)msgAppStationTemplate.getOpenStatus(), (Object)msgAppStationTemplateDto.getOpenStatus()) && this.appSceneConfigService.isExistSceneInBatch(new ArrayList<String>(Collections.singletonList(msgAppStationTemplate.getTemplateNo())))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u65e0\u6cd5\u4fee\u6539\u542f\u52a8\u72b6\u6001\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        HussarUtils.copy((Object)msgAppStationTemplateDto, (Object)msgAppStationTemplate);
        msgAppStationTemplate.setTemplateParams(TemplateUtils.getTemplateParams(msgAppStationTemplateDto.getContent() + msgAppStationTemplateDto.getTitle() + msgAppStationTemplateDto.getUrl()));
        return ApiResponse.success((Object)super.updateById((BaseEntity)msgAppStationTemplate));
    }

    @HussarTransactional
    public ApiResponse<Boolean> delTemplate(List<String> ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(ids).stream().map(MsgStationTemplate::getTemplateNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f");
        }
        List idsLong = ids.stream().map(Long::valueOf).collect(Collectors.toList());
        return ApiResponse.success((Object)super.removeByIds(idsLong));
    }
}

