/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.no.code.message.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.formdesign.nocode.message.nocodeStationRabbitMqReceiver")
public class NocodeStationRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(NocodeStationRabbitMqReceiver.class);
    @Resource(name="com.jxdinfo.hussar.no.code.message.service.impl.StationMsgUnitySendFrameServiceImpl")
    private MsgUnitySendFrameService msgUnitySendFrameService;

    @RabbitHandler
    @RabbitListener(queues={"#{nocodeStationQueue.name}"})
    public void handlePay(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg Station json:{}", (Object)json);
            HussarContextHolder.setTenant((String)"1", (String)Optional.ofNullable(JSON.parseObject((String)json).get((Object)"tenantCode")).orElse("0").toString());
            MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSONObject.parseObject((String)json, MsgUnitySendDto.class);
            this.msgUnitySendFrameService.msgUnitySendBefore(msgUnitySendDto);
        }
        catch (Exception e) {
            logger.error("\u7ad9\u5185\u4fe1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

