/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.no.code.message.config;

import com.jxdinfo.hussar.msg.common.properties.UnifiedMessageProperties;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NocodeStationRabbitMqConfig {
    @Autowired
    private UnifiedMessageProperties unifiedMessageProperties;

    private String wrap(String key) {
        String queuePrefix = this.unifiedMessageProperties.getQueuePrefix();
        if (StringUtils.isNotBlank((CharSequence)queuePrefix)) {
            return queuePrefix.trim() + key;
        }
        return key;
    }

    @Bean
    DirectExchange nocodeStationDirect() {
        return (DirectExchange)ExchangeBuilder.directExchange((String)this.wrap("msg.station_message.direct")).durable(true).build();
    }

    @Bean
    public Queue nocodeStationQueue() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-queue-type", "classic");
        return new Queue(this.wrap("msg.station_message"), true, false, false, args);
    }

    @Bean
    Binding nocodeStationBinding() {
        return BindingBuilder.bind((Queue)this.nocodeStationQueue()).to(this.nocodeStationDirect()).with(this.wrap("msg.station_message"));
    }
}

