/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.example.sso;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.example.sso.SSOLoginProperties;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.example.sso.sSOLoginServiceImpl")
public class SSOLoginServiceImpl
implements HussarLoginValidateService {
    private static OkHttpClient client;
    @Resource
    private SSOLoginProperties ssoLoginProperties;
    private static final Logger logger;
    private static final TrustManager[] trustAllCerts;

    public String getLoginType() {
        return "thirdSso";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        HashMap<String, String> bodyData = new HashMap<String, String>();
        bodyData.put("ssoToken", loginCode);
        String bodyJsonStr = JSON.toJSONString(bodyData);
        RequestBody requestBody = RequestBody.create((String)bodyJsonStr, (MediaType)MediaType.parse((String)"application/json;charset=UTF-8"));
        Request ssoRequest = new Request.Builder().url(this.ssoLoginProperties.getTokenUrl()).addHeader("Content-Type", "application/json;charset=UTF-8").post(requestBody).build();
        logger.info("\u5355\u70b9\u767b\u5f55 => token \u8ba4\u8bc1\u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)ssoRequest));
        try {
            Response response = SSOLoginServiceImpl.client().newCall(ssoRequest).execute();
            if (!response.isSuccessful()) {
                throw new HussarException("\u5355\u70b9\u767b\u5f55 => token \u8ba4\u8bc1\u5f02\u5e38" + response.message());
            }
            String responseStr = Objects.requireNonNull(response.body()).string();
            JSONObject responseJsonObject = JSONObject.parseObject((String)responseStr);
            return responseJsonObject.getJSONObject("data").getString("userAccount");
        }
        catch (Exception e) {
            throw new HussarException("\u5355\u70b9\u767b\u5f55 => token \u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
        }
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    private static OkHttpClient client() {
        if (client != null) {
            return client;
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            client = new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            }).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
            return client;
        }
        catch (Exception e) {
            logger.error("\u5355\u70b9\u767b\u5f55 => \u521d\u59cb\u5316 HttpClient \u5931\u8d25", (Throwable)e);
            throw new HussarException("\u5355\u70b9\u767b\u5f55 => \u521d\u59cb\u5316 HttpClient \u5931\u8d25");
        }
    }

    static {
        logger = LoggerFactory.getLogger(SSOLoginServiceImpl.class);
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }
}

