/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.example.customizefile.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.example.customizefile.properties.OssCustomizeFileProperties;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IoUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.dao.AttachmentManagerMapper;
import com.jxdinfo.hussar.support.oss.core.support.dto.AttachInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.dto.FileInfoDto;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.util.CheckUploadFileUtils;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class CustomizeAttachmentManagerServiceImpl
extends HussarServiceImpl<AttachmentManagerMapper, AttachmentManagerModel>
implements AttachmentManagerService {
    private final OssCustomizeFileProperties ossFileProperties;
    private final GetLoginUserService getLoginUserService;
    @Resource
    private OssProperties ossProperties;
    private static Logger logger = LogManager.getLogger(CustomizeAttachmentManagerServiceImpl.class);

    public CustomizeAttachmentManagerServiceImpl(OssCustomizeFileProperties ossFileProperties, GetLoginUserService getLoginUserService) {
        this.ossFileProperties = ossFileProperties;
        this.getLoginUserService = getLoginUserService;
    }

    public Long saveAttachment(AttachmentManagerModel attachmentManagerModel) {
        this.save((BaseEntity)attachmentManagerModel);
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u64cd\u4f5c\u65b9\u6cd5{} \u6587\u4ef6\u540d:{}", (Object)"saveAttachment", (Object)(ToolUtil.isNotEmpty((Object)attachmentManagerModel.getAttachmentName()) ? attachmentManagerModel.getAttachmentName() : ""));
        return attachmentManagerModel.getId();
    }

    public String findDirById(Long id) {
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentManagerModel)) {
            return "";
        }
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u64cd\u4f5c\u65b9\u6cd5{} \u6587\u4ef6\u540d:{}", (Object)"findDirById", (Object)attachmentManagerModel.getAttachmentName());
        return attachmentManagerModel.getAttachmentDir();
    }

    public AttachmentManagerModelVo getByFileId(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u64cd\u4f5c\u65b9\u6cd5{} \u6587\u4ef6\u540d:{}", (Object)"getByFileId", (Object)((AttachmentManagerModel)this.getById(fileId)).getAttachmentName());
        return this.getAttachmentVoById(fileId);
    }

    public List<AttachmentManagerModelVo> getByFileIds(String[] fileIds) {
        ArrayList<AttachmentManagerModelVo> attachmentManagerModelVos = new ArrayList<AttachmentManagerModelVo>();
        if (HussarUtils.isEmpty((Object[])fileIds)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        for (String fileId : fileIds) {
            if (!HussarUtils.isNotEmpty((Object)fileId)) continue;
            attachmentManagerModelVos.add(this.getAttachmentVoById(Long.parseLong(fileId)));
        }
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u64cd\u4f5c\u65b9\u6cd5{} \u6587\u4ef6\u540d:{}", (Object)"getByFileIds", (Object)attachmentManagerModelVos.stream().map(AttachmentManagerModelVo::getFileName).collect(Collectors.joining(",")));
        return attachmentManagerModelVos;
    }

    public ApiResponse<String> upload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file) || HussarUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties);
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fName = IdWorker.get32UUID() + suffix;
        try {
            String fileSavePath = this.ossFileProperties.getFileUploadPath();
            file.transferTo(new File(fileSavePath + fName));
        }
        catch (IOException e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FILE_UPLOAD_ERROR.getExceptionCode(), OssExceptionEnum.FILE_UPLOAD_ERROR.getMessage());
        }
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5{} \u6587\u4ef6\u540d:{}", (Object)"upload", (Object)fileName);
        return ApiResponse.success((String)fName);
    }

    public ApiResponse<AttachmentManagerModelVo> uploadFileWithDrag(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5 {} \u8868\u5355id:{} \u5e94\u7528id:{} \u6587\u4ef6\u540d:{}", (Object)"uploadfilewithdrag", (Object)(ToolUtil.isNotEmpty((Object)multipartRequest.getParameter("formId")) ? multipartRequest.getParameter("formId") : "\u65e0"), (Object)(ToolUtil.isNotEmpty((Object)multipartRequest.getParameter("appId")) ? multipartRequest.getParameter("appId") : "\u65e0"), (Object)multipartRequest.getFileMap().values().stream().map(MultipartFile::getOriginalFilename).collect(Collectors.joining(",")));
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        multipartRequest.setCharacterEncoding("UTF-8");
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MultipartFile value;
            multipartFile = value = (MultipartFile)iterator.next();
        }
        if (HussarUtils.isNotEmpty(multipartFile)) {
            CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
            attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId);
        }
        return ApiResponse.success((Object)attachmentManagerModelVo);
    }

    public List<AttachmentManagerModelVo> uploadMultipleFile(MultipartHttpServletRequest multipartRequest, Long businessId) throws Exception {
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5 {} \u8868\u5355id:{} \u5e94\u7528id:{} \u6587\u4ef6\u540d:{}", (Object)"uploadMultipleFile", (Object)(ToolUtil.isNotEmpty((Object)multipartRequest.getParameter("formId")) ? multipartRequest.getParameter("formId") : "\u65e0"), (Object)(ToolUtil.isNotEmpty((Object)multipartRequest.getParameter("appId")) ? multipartRequest.getParameter("appId") : "\u65e0"), (Object)multipartRequest.getFileMap().values().stream().map(MultipartFile::getOriginalFilename).collect(Collectors.joining(",")));
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        ArrayList<AttachmentManagerModelVo> voList = new ArrayList<AttachmentManagerModelVo>();
        multipartRequest.setCharacterEncoding("UTF-8");
        Map map = multipartRequest.getFileMap();
        if (HussarUtils.isNotEmpty((Object)map)) {
            map.values().forEach(file -> CheckUploadFileUtils.checkFileType((MultipartFile)file, (OssProperties)this.ossProperties));
        }
        for (MultipartFile file2 : map.values()) {
            MultipartFile multipartFile = file2;
            if (!HussarUtils.isNotEmpty((Object)multipartFile)) continue;
            AttachmentManagerModelVo attachmentManagerModelVo = this.packageAttachmentVo(multipartFile, businessId);
            voList.add(attachmentManagerModelVo);
        }
        return voList;
    }

    public void fileDownload(HttpServletResponse response, Long fileId) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            return;
        }
        String fileName = attachmentModel.getAttachmentName();
        String suffix = this.getSuffix(fileName);
        String path = attachmentModel.getAttachmentDir() + fileId + suffix;
        File file = new File(path);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(path)), 10240);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            response.setContentLengthLong(file.length());
            int len = 0;
            int i = ((InputStream)bis).available();
            byte[] buff = new byte[i];
            while ((len = ((InputStream)bis).read(buff)) > 0) {
                out.write(buff, 0, len);
                out.flush();
            }
        }
        catch (FileNotFoundException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)fileName.toString(), (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)"\u7f16\u7801\u5f02\u5e38\uff1a", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
        catch (IOException e) {
            logger.error("inputParams:{} and errorMessage:{}", (Object)"IO\u5f02\u5e38\uff1a", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u4e0b\u8f7d\u65b9\u6cd5 {}, \u6587\u4ef6\u540d {}", (Object)"fileDownload", (Object)attachmentModel.getAttachmentName());
    }

    public void batchDownload(String ids, HttpServletResponse response) throws ServletException, IOException {
        if (HussarUtils.isEmpty((Object)ids) || HussarUtils.isEmpty((Object)response)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        ArrayList fileIdList = new ArrayList();
        Arrays.stream(ids.split(",")).forEach(s -> {
            if (HussarUtils.isNotEmpty((Object)s) && HussarUtils.isNotEmpty((Object)s.trim())) {
                fileIdList.add(Long.parseLong(s));
            }
        });
        List attachList = this.listByIds(fileIdList);
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u4e0b\u8f7d\u65b9\u6cd5{}, \u6587\u4ef6\u540d{}", (Object)"batchDownload", (Object)attachList.stream().map(AttachmentManagerModel::getAttachmentName).collect(Collectors.joining(",")));
        try (ServletOutputStream os = response.getOutputStream();
             ZipOutputStream zos = new ZipOutputStream((OutputStream)os);){
            String sourceFilePath = "\u6279\u91cf\u4e0b\u8f7d.zip";
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(sourceFilePath, "UTF-8"));
            int count = 0;
            for (AttachmentManagerModel attach : attachList) {
                ++count;
                Long id = attach.getId();
                String fileName = attach.getAttachmentName();
                String suffix = this.getSuffix(fileName);
                String path = attach.getAttachmentDir() + id + suffix;
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
                Throwable throwable = null;
                try {
                    BufferedInputStream bis = new BufferedInputStream(inputStream, 10240);
                    Throwable throwable2 = null;
                    try {
                        byte[] buf = new byte[((InputStream)inputStream).available()];
                        int len = 0;
                        ZipEntry zipEntry = new ZipEntry(count + "-" + fileName);
                        zos.putNextEntry(zipEntry);
                        while ((len = bis.read(buf)) > 0) {
                            zos.write(buf, 0, len);
                            zos.flush();
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bis == null) continue;
                        if (throwable2 != null) {
                            try {
                                bis.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bis.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ((InputStream)inputStream).close();
                }
            }
        }
        catch (Exception e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
    }

    public ApiResponse<Object> deleteFile(Long fileId) {
        if (HussarUtils.isEmpty((Object)fileId)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.getById(fileId);
        if (HussarUtils.isNotEmpty((Object)attachmentManagerModel)) {
            String fileName = attachmentManagerModel.getAttachmentName();
            Long id = attachmentManagerModel.getId();
            String fileSavePath = this.findDirById(id);
            String suffix = this.getSuffix(fileName);
            File file = new File(fileSavePath + id + suffix);
            FileUtil.deleteQuietly((File)file);
            this.removeById(id);
        }
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u5220\u9664\u65b9\u6cd5{}, \u6587\u4ef6\u540d{}", (Object)"deleteFile", (Object)attachmentManagerModel.getAttachmentName());
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public void showImage(HttpServletResponse response, Long id) {
        if (HussarUtils.isEmpty((Object)response) || HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setContentType("image/jpeg");
        AttachmentManagerModel image = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)image)) {
            return;
        }
        String fileName = image.getAttachmentName();
        String fileSavePath = image.getAttachmentDir();
        String suffix = this.getSuffix(fileName);
        String absolutePath = fileSavePath + id + suffix;
        try (FileInputStream fis = new FileInputStream(absolutePath);
             ServletOutputStream os = response.getOutputStream();){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = fis.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            os.flush();
        }
        catch (IOException e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            response.setContentType("application/json");
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u56fe\u7247\u56de\u663e\u65b9\u6cd5{}, \u6587\u4ef6\u540d{}", (Object)"showImage", (Object)image.getAttachmentName());
    }

    public Page<AttachmentManagerModel> getAttachmentList(Page<AttachmentManagerModel> page, AttachInfoDto info) {
        if (HussarUtils.isEmpty(page)) {
            throw new HussarException(OssExceptionEnum.PAGEINFO_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.PAGEINFO_NOT_EMPTY.getMessage());
        }
        String attachmentName = info.getAttachmentName();
        LocalDateTime startDate = info.getStartDate();
        LocalDateTime endDate = info.getEndDate();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)attachmentName)) {
            queryWrapper.like(AttachmentManagerModel::getAttachmentName, (Object)attachmentName);
        }
        if (HussarUtils.isNotEmpty((Object)startDate)) {
            queryWrapper.ge(AttachmentManagerModel::getUploadDate, (Object)startDate);
        }
        if (HussarUtils.isNotEmpty((Object)endDate)) {
            queryWrapper.le(AttachmentManagerModel::getUploadDate, (Object)endDate);
        }
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u83b7\u53d6\u65b9\u6cd5{}, \u6a21\u7cca\u5339\u914d\u6587\u4ef6\u540d{} \u5f00\u59cb\u65f6\u95f4{} \u7ed3\u675f\u65f6\u95f4{}", (Object)"getAttachmentList", (Object)attachmentName, (Object)startDate, (Object)endDate);
        return (Page)this.page((IPage)page, (Wrapper)queryWrapper);
    }

    public ApiResponse<Boolean> isExist(Long id) {
        String absolutePath = this.getAbsolutePath(id);
        File file = new File(absolutePath);
        if (!file.exists()) {
            return ApiResponse.success((Object)Boolean.FALSE);
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    public ApiResponse<Long> backgroundUpload(MultipartFile file) {
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_NOT_EMPTY.getMessage());
        }
        String fileName = file.getOriginalFilename();
        String suffix = this.getSuffix(fileName);
        String fileSavePath = this.ossFileProperties.getFileUploadPath();
        FileInfoDto fileInfoDto = new FileInfoDto();
        fileInfoDto.setFileName(fileName);
        fileInfoDto.setFileSavePath(fileSavePath);
        fileInfoDto.setSuffix(suffix);
        AttachmentManagerModel attachmentManagerModel = this.saveFileManager(null, fileInfoDto);
        Long id = attachmentManagerModel.getId();
        String path = fileSavePath + attachmentManagerModel.getId() + suffix;
        File upload = new File(path);
        try {
            file.transferTo(upload);
        }
        catch (IOException e) {
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u64cd\u4f5c\u65b9\u6cd5{}, \u6587\u4ef6\u540d{} ", (Object)"backgroundUpload", (Object)fileName);
        return ApiResponse.success((Object)id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<byte[]> backgroundDownload(Long id) {
        String absolutePath = this.getAbsolutePath(id);
        logger.info("\u9644\u4ef6\u7ec4\u4ef6\u4e8c\u6b21\u6269\u5c55\uff1a\u6587\u4ef6\u64cd\u4f5c\u65b9\u6cd5{}, \u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84{} ", (Object)"backgroundDownload", (Object)absolutePath);
        try (FileInputStream fis = new FileInputStream(absolutePath);){
            ApiResponse apiResponse = ApiResponse.success((Object)IoUtil.readToByteArray((InputStream)fis));
            return apiResponse;
        }
        catch (IOException e) {
            logger.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
        }
    }

    private AttachmentManagerModel saveFileManager(Long businessId, FileInfoDto fileInfoDto) {
        AttachmentManagerModel attachment = new AttachmentManagerModel();
        attachment.setBusinessId(businessId);
        attachment.setAttachmentName(fileInfoDto.getFileName());
        attachment.setAttachmentType(fileInfoDto.getSuffix().replace(".", ""));
        UserDetails user = this.getLoginUserService.getCurrentUserDetail();
        if (user != null) {
            attachment.setUploadPer(user.getUserId());
        }
        attachment.setAttachmentDir(fileInfoDto.getFileSavePath());
        attachment.setUploadDate(LocalDateTime.now());
        this.save((BaseEntity)attachment);
        return attachment;
    }

    private AttachmentManagerModelVo getAttachmentVoById(Long id) {
        AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)attachmentModel)) {
            return null;
        }
        String fileName = attachmentModel.getAttachmentName();
        String suffix = this.getSuffix(fileName);
        String path = attachmentModel.getAttachmentDir() + id + suffix;
        File file = new File(path);
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        BeanUtil.copy((Object)attachmentModel, (Object)attachmentManagerModelVo);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        attachmentManagerModelVo.setBytes(String.valueOf(file.length()));
        return attachmentManagerModelVo;
    }

    private AttachmentManagerModelVo packageAttachmentVo(MultipartFile multipartFile, Long businessId) throws IOException {
        String fileName = multipartFile.getOriginalFilename();
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        String suffix = this.getSuffix(fileName);
        String fileSavePath = this.ossFileProperties.getFileUploadPath();
        FileInfoDto fileInfoDto = new FileInfoDto();
        fileInfoDto.setFileName(fileName);
        fileInfoDto.setFileSavePath(fileSavePath);
        fileInfoDto.setSuffix(suffix);
        AttachmentManagerModel attachmentManagerModel = this.saveFileManager(businessId, fileInfoDto);
        String path = fileSavePath + attachmentManagerModel.getId() + suffix;
        File file = new File(path);
        multipartFile.transferTo(file);
        BeanUtil.copy((Object)attachmentManagerModel, (Object)attachmentManagerModelVo);
        attachmentManagerModelVo.setFileName(fileName);
        attachmentManagerModelVo.setPath(path);
        attachmentManagerModelVo.setBytes(String.valueOf(file.length()));
        return attachmentManagerModelVo;
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    private String getAbsolutePath(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
        AttachmentManagerModel file = (AttachmentManagerModel)this.getById(id);
        if (HussarUtils.isEmpty((Object)file)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
        }
        String fileName = file.getAttachmentName();
        String fileSavePath = file.getAttachmentDir();
        String suffix = this.getSuffix(fileName);
        return fileSavePath + id + suffix;
    }
}

