/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.newapp.sevice.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.DevCloudUtil;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.newapp.dao.NewAppMapper;
import com.jxdinfo.hussar.newapp.model.GitServerDto;
import com.jxdinfo.hussar.newapp.model.NewSysAppInfo;
import com.jxdinfo.hussar.newapp.service.INewAppService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.newapp.service.impl.newAppServiceImpl")
public class NewAppServiceImpl
implements INewAppService {
    private static final Logger logger = LoggerFactory.getLogger(NewAppServiceImpl.class);
    @Resource
    NewAppMapper newAppMapper;
    @Resource
    ISysUserRoleService sysUserRoleService;
    @Resource
    ISysEmployeeService sysEmployeeService;
    @Resource
    ISysOrganService sysOrganService;
    @Resource
    ISysStruService sysStruService;
    @Resource
    ISysStruAssistOrganService sysStruAssistOrganService;
    @Resource
    ISysStaffService sysStaffService;
    @Resource
    ISysUsersService sysUsersService;
    public static final Long PUBLIC_ROLE = 1450785135866925064L;
    public static final Long DEV_ROLE = 690264237607755776L;
    @Value(value="${hussar-formdesign.workspace}")
    private String localPath;
    @Value(value="${hussar-formdesign.back-project-path:hussar-web}")
    private String backPath;
    @Value(value="${gitlab.uri.git-uri:default}")
    private String gitUri;
    @Value(value="${gitlab.uri.git-group:default}")
    private String gitGroup;

    public boolean getAppStatus() {
        if (this.newAppMapper.getAppStatus().size() == 0) {
            return true;
        }
        return !"0".equals(((NewSysAppInfo)this.newAppMapper.getAppStatus().get(0)).getAppStatus());
    }

    public boolean saveOrUpdateNewSysApplication(NewSysAppInfo sysApplication) {
        if (this.newAppMapper.getOne(sysApplication) == null) {
            return this.newAppMapper.saveNewApplication(sysApplication);
        }
        return this.newAppMapper.updateNewApplication(sysApplication);
    }

    public String importData(JSONObject data) {
        try {
            logger.info("\u65b0\u5e94\u7528\u56de\u8c03\u65b9\u6cd5\u63a5\u6536\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u53c2\u6570\uff1a---->{}", (Object)data);
            List strus = JSONArray.parseArray((String)IdempotentJsonUtils.toString((Object)data.get((Object)"strus")), SysStru.class);
            List organs = JSONArray.parseArray((String)IdempotentJsonUtils.toString((Object)data.get((Object)"organs")), SysOrgan.class);
            List staffs = JSONArray.parseArray((String)IdempotentJsonUtils.toString((Object)data.get((Object)"staffs")), SysStaff.class);
            List users = JSONArray.parseArray((String)IdempotentJsonUtils.toString((Object)data.get((Object)"users")), SysUsers.class);
            List sysStruAssistOrgan = JSONArray.parseArray((String)IdempotentJsonUtils.toString((Object)data.get((Object)"sysStruAssistOrgan")), SysStruAssistOrgan.class);
            logger.info("\u65b0\u5e94\u7528\u56de\u8c03\u65b9\u6cd5\u63a5\u6536\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u53c2\u6570strusList\uff1a---->{}", (Object)strus);
            logger.info("\u65b0\u5e94\u7528\u56de\u8c03\u65b9\u6cd5\u63a5\u6536\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u53c2\u6570organsList\uff1a---->{}", (Object)organs);
            logger.info("\u65b0\u5e94\u7528\u56de\u8c03\u65b9\u6cd5\u63a5\u6536\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u53c2\u6570staffsList\uff1a---->{}", (Object)staffs);
            logger.info("\u65b0\u5e94\u7528\u56de\u8c03\u65b9\u6cd5\u63a5\u6536\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u53c2\u6570usersList\uff1a---->{}", (Object)users);
            logger.info("\u65b0\u5e94\u7528\u56de\u8c03\u65b9\u6cd5\u63a5\u6536\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u53c2\u6570sysStruAssistOrganList\uff1a---->{}", (Object)sysStruAssistOrgan);
            this.insertOrUpdateList(strus);
            this.insertOrUpdateList(organs);
            this.insertOrUpdateList(staffs);
            this.insertOrUpdateList(users);
            this.insertOrUpdateList(sysStruAssistOrgan);
            for (int i = 0; i < users.size(); ++i) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(((SysUsers)users.get(i)).getId());
                sysUserRole.setGrantedRole(DEV_ROLE);
                sysUserRole.setAdminOption("1");
                if (this.sysUserRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUserRole.getUserId())).eq((Object)"GRANTED_ROLE", (Object)DEV_ROLE)).size() == 0) {
                    this.sysUserRoleService.save((Object)sysUserRole);
                }
                sysUserRole.setGrantedRole(PUBLIC_ROLE);
                if (this.sysUserRoleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID", (Object)sysUserRole.getUserId())).eq((Object)"GRANTED_ROLE", (Object)PUBLIC_ROLE)).size() != 0) continue;
                this.sysUserRoleService.save((Object)sysUserRole);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "fail";
        }
        return "success";
    }

    public ApiResponse abutmentGitlab(Map<String, Object> dataMap) {
        logger.info("\u65b0\u5e94\u7528\uff1a\u63d0\u4ea4\u53d8\u66f4\u63a5\u6536\u53c2\u6570\uff1adataMap===================={}", dataMap);
        Long time = System.currentTimeMillis();
        try {
            if (dataMap != null) {
                NewSysAppInfo sysApplication = (NewSysAppInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataMap.get("sysApplication")), NewSysAppInfo.class);
                JSONObject sysAppDeploy = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataMap.get("sysAppDeploy")));
                String accessToken = (String)dataMap.get("accessToken");
                String type = (String)dataMap.get("type");
                if (HussarUtils.isEmpty((Object)accessToken)) {
                    logger.info("\u65b0\u5e94\u7528\u63d0\u4ea4\u53d8\u66f4\uff1a\u4e2a\u4eba\u7528\u6237\u4ee4\u724c\u4e3a\u7a7a==================================");
                    ApiResponse apiResponse = ApiResponse.fail((String)"\u4e2a\u4eba\u7528\u6237\u4ee4\u724c\u4e3a\u7a7a");
                    return apiResponse;
                }
                GitServerDto gitServerDto = new GitServerDto();
                gitServerDto.setToken(accessToken);
                gitServerDto.setBranch(sysAppDeploy.getString("branchName"));
                gitServerDto.setAppCode(sysApplication.getAppCode());
                gitServerDto.setPersonalBrance(sysApplication.getPersonalBrance());
                if ("1".equals(type)) {
                    this.pull2local(gitServerDto);
                } else if ("2".equals(type)) {
                    this.push2remote(gitServerDto);
                }
            } else {
                logger.info("\u65b0\u5e94\u7528\u63d0\u4ea4\u53d8\u66f4\uff1a\u4e2a\u4eba\u7528\u6237\u4ee4\u724c\u4e3a\u7a7a==================================");
                ApiResponse.fail((String)"\u53c2\u6570\u4f20\u8f93\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            this.deleteFile(new File(this.getTempPath() + File.separator + time));
        }
        return ApiResponse.success();
    }

    private String getTempPath() {
        return NewAppServiceImpl.convert(this.localPath) + NewAppServiceImpl.convert(this.backPath) + "temp";
    }

    private String pull2local(GitServerDto gitServerDto) {
        String branch = gitServerDto.getBranch();
        String accessToken = gitServerDto.getToken();
        DevCloudUtil.pull((String)(this.gitUri + this.gitGroup + gitServerDto.getAppCode()), (String)NewAppServiceImpl.convert(this.localPath), (String)branch, (String)accessToken);
        return "\u66f4\u65b0\u6210\u529f";
    }

    private String push2remote(GitServerDto gitServerDto) throws Exception {
        String branch = gitServerDto.getBranch();
        String accessToken = gitServerDto.getToken();
        if ("dev".equals(gitServerDto.getBranch()) && "1".equals(gitServerDto.getPersonalBrance())) {
            logger.info("\u83b7\u53d6git\u670d\u52a1\u5668\u9879\u76eeid\uff1a==============");
            String id = DevCloudUtil.getGroupOrProjectId((String)this.gitUri, (String)gitServerDto.getAppCode(), (String)accessToken, (String)"projects");
            logger.info("\u63d0\u4ea4\u4ee3\u7801\u5230\u8fdc\u7a0b:\u72ec\u7acb\u5206\u652f\u53d6\u6d88dev\u4fdd\u62a4\u5206\u652f\uff1a==============");
            DevCloudUtil.unProtectBranch((String)this.gitUri, (String)id, (String)"dev", (String)accessToken);
            logger.info("\u63d0\u4ea4\u4ee3\u7801\u5230\u8fdc\u7a0b:\u63d0\u4ea4\u4ee3\u7801===================");
            DevCloudUtil.pushChangeToGit((String)(this.gitUri + this.gitGroup + gitServerDto.getAppCode()), (String)NewAppServiceImpl.convert(this.localPath), (String)"\u7ebf\u4e0a\u5f00\u53d1\u5f3a\u5236\u63d0\u4ea4", (String)branch, (String)accessToken);
            logger.info("\u63d0\u4ea4\u4ee3\u7801\u5230\u8fdc\u7a0b:dev\u8bbe\u7f6e\u4fdd\u62a4\u5206\u652f\uff1a==================");
            DevCloudUtil.setProtectBranch((String)this.gitUri, (String)id, (String)"dev", (String)accessToken);
        } else {
            DevCloudUtil.pushChangeToGit((String)(this.gitUri + this.gitGroup + gitServerDto.getAppCode()), (String)NewAppServiceImpl.convert(this.localPath), (String)"\u7ebf\u4e0a\u5f00\u53d1\u5f3a\u5236\u63d0\u4ea4", (String)branch, (String)accessToken);
        }
        return "\u63d0\u4ea4\u6210\u529f";
    }

    private static String convert(String str) {
        StringBuilder stringBuilder = new StringBuilder(str.replace("//", File.separator));
        if (!str.endsWith(File.separator)) {
            stringBuilder.append(File.separator);
        }
        return stringBuilder.toString();
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer updateStaff = 0;
        Integer insertStaff = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            Integer n;
            Integer n2;
            Object object = objects.get(i);
            if (object instanceof SysStru) {
                SysStru stru = (SysStru)object;
                if (this.sysEmployeeService.updateById((Object)stru)) {
                    if ("9".equals(stru.getStruType())) {
                        n2 = updateStaff;
                        n = updateStaff = Integer.valueOf(updateStaff + 1);
                    }
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    this.sysEmployeeService.save((Object)stru);
                    if ("9".equals(stru.getStruType())) {
                        n2 = insertStaff;
                        n = insertStaff = Integer.valueOf(insertStaff + 1);
                    }
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
            }
            if (object instanceof SysOrgan) {
                SysOrgan organ = (SysOrgan)object;
                if (this.sysOrganService.updateById((Object)organ)) {
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    this.sysOrganService.save((Object)organ);
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
            }
            if (object instanceof SysStaff) {
                SysStaff sysStaff = (SysStaff)object;
                if (this.sysStaffService.updateById((Object)sysStaff)) {
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    this.sysStaffService.save((Object)sysStaff);
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
            }
            if (object instanceof SysUsers) {
                SysUsers sysUsers = (SysUsers)object;
                if (this.sysUsersService.updateById((Object)sysUsers)) {
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    this.sysUsersService.save((Object)sysUsers);
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
            }
            if (!(object instanceof SysStruAssistOrgan)) continue;
            SysStruAssistOrgan sysStruAssistOrgan = (SysStruAssistOrgan)object;
            if (this.sysStruAssistOrganService.updateById((Object)sysStruAssistOrgan)) {
                n2 = update;
                n = update = Integer.valueOf(update + 1);
                continue;
            }
            this.sysStruAssistOrganService.save((Object)sysStruAssistOrgan);
            n2 = insert;
            n = insert = Integer.valueOf(insert + 1);
        }
        result.put("update", update);
        result.put("updateStaff", updateStaff);
        result.put("insertStaff", insertStaff);
        result.put("insert", insert);
        return result;
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }
}

