layui.use('form', function() {
	var form = layui.form;
	// 加载服务器下拉框数据
	$.ajax({
		type : "GET",
		url : getRootPath() + "?action=serverList.json",
		dataType : "json",
		success : function(data) {
			var thisSelect = $("#server");
			for (var i = 0; i < data.length; i++) {
				if (data[i].desc == "true") {
					thisSelect.append("<option value='" + data[i].value
							+ "' selected='selected' >" + data[i].name
							+ "</option>");
				} else {
					thisSelect.append("<option value='" + data[i].value + "'>"
							+ data[i].name + "</option>");
				}

			}
			form.render("select");
		}
	});
	// 下拉菜单监听--服务器下拉菜单监听
	form.on('select(server)', function(data) {
		server = data.value;
		var sec = $("#cycle").siblings('.layui-form-select')
				.find('.layui-this').attr('lay-value');
		if (sec == undefined) {
			sec = refSec;
		}

		clearInterval(interval);// 清除定时器??方法无效？？
		loadPage(server, sec);
	});
	// 下拉菜单监听--周期下拉菜单监听
	form.on('select(cycle)', function(data) {
		refSec = data.value;
		if (refSec == "") {
			refSec = "5000";
		}
		host = $("#server").siblings('.layui-form-select').find('.layui-this')
				.attr('lay-value');
		clearInterval(interval);// 清除定时器??方法无效？？
		loadPage(host, refSec);
	});
});

// 获取当前应用路径
function getRootPath() {
	var curPath = window.document.location.href;
	var pathName = window.document.location.pathname;
	var pos = curPath.indexOf(pathName);
	return (curPath.substring(0, pos) + pathName);
}
// 表格加载
function getTable(url, host) {
	layui.use('table', function() {
		var table = layui.table;
		table.render({
			elem : '#table',
			height : 650,// 可自行计算
			url : url, // 'json/detectorInfo.json' 数据接口
			contentType : 'application/json; charset=UTF-8',
			where : "",
			page : false,// 开启分页
			loading : true,// 开启分页
			cols : [ [ // 表头
			{
				type : 'numbers',
				title : '序号',
				width : 50,
				align : 'center'
			}, {
				field : 'name',
				title : '检测项',
				width : 150,
				align : 'center'
			}, {
				field : 'desc',
				title : '检测名称',
				width : 150,
				align : 'center'
			}, {
				field : 'value',
				title : '监测信息',
				templet : function(d) {
					var txt = d.value;
					var html = "";
					var con = txt.split(';');
					for (var i = 0; i < con.length; i++) {
						if (i != con.length - 1) {
							html = html + con[i] + "</br>"
						}
					}
					return html;
				}
			} ] ]
		});

	});
}
var first = true;
// 动态添加仪表盘
function getGauge(url, host) {
	$.ajax({
		type : "GET",
		url : url, // "json/chartList.json",
		data : {
			'host' : host
		},
		dataType : "json",
		success : function(data) {
			var thisBox = $("#data-in");
			if (first) {
				thisBox.html(" ");
			}

			for (var i = 0; i < data.length; i++) {
				if (first) {
					thisBox.append("<div id='" + data[i].name
							+ "' class='layui-col-md3'></div>");
				}
				gauge(data[i].name, data[i].value, data[i].desc, first);
			}
			if (first) {
				first = false;
			}
		}
	});
}

// 仪表盘方法
function gauge(id, data, name, first) {
	if (first) {
		window["myChart_" + id] = echarts.init(document.getElementById(id));
	}
	var option = {
		backgroundColor : "#ffffff",
		color : [ "#37A2DA", "#32C5E9", "#67E0E3" ],
		tooltip : {
			formatter : "<center><strong>{a}</strong></center> {b} : {c}%"
		},
		series : [ {
			name : name,
			type : 'gauge',
            title:{
                show:true,
                offsetCenter :[0,'70%']
            },
            detail: {
                formatter: '{value}%',
                fontSize :18
            },
			axisLine : {
				show : true,
				lineStyle : {
					width : 20,
					shadowBlur : 0,
					color : [ [ 0.3, '#67e0e3' ], [ 0.7, '#37a2da' ],
							[ 1, '#fd666d' ] ]
				}
			},
			data : [ {
				value : data,
				name : name
			} ]

		} ]
	};
	window["myChart_" + id].setOption(option);
}

var host = "";
var refSec = "1000";
var interval = setInterval(function() {
}, refSec);
// 定时加载页面
function loadPage(host, sec) {// url为服务器地址；sec为刷新秒数
	clearInterval(interval);
	if (sec < 5000) {
		sec = "5000";
	}
	getGauge(getRootPath() + "?action=chartList.json", host);// json/chartList.json
	// 仪表盘数据
	getTable(getRootPath() + "?action=detectorInfo.json", host);// 表格数据

	/*
	 * 应该可以根据url（服务器地址）获取表格数据与仪表盘数据，将获取的数据传到对应方法中即可
	 */
	interval = setInterval(function() {
		getGauge(getRootPath() + "?action=chartList.json", host);// json/chartList.json
		// 仪表盘数据
	}, sec);
}
$("#refresh").bind().click(function() {
	loadPage(host, refSec);
});
$(function() {
	loadPage(host, refSec);

});