/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtil {
    private CookieUtil() {
    }

    public static void setCookie(HttpServletResponse response, String name, String value) {
        CookieUtil.setCookie(response, name, value, null, "/", 604800, false);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, String domain) {
        CookieUtil.setCookie(response, name, value, domain, "/", 604800, false);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, String domain, String path, int expiry, boolean secure) {
        String data = null;
        try {
            data = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (data != null) {
            Cookie cookie = new Cookie(name, data);
            if (domain != null) {
                cookie.setDomain(domain);
            }
            if (path != null) {
                cookie.setPath(path);
            }
            if (expiry > 0) {
                cookie.setMaxAge(expiry);
            }
            cookie.setSecure(secure);
            response.addCookie(cookie);
        }
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String getValue(HttpServletRequest request, String name) {
        String result = null;
        Cookie cookie = CookieUtil.getCookie(request, name);
        if (cookie != null) {
            try {
                result = URLDecoder.decode(cookie.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static void remove(HttpServletResponse response, String name) {
        CookieUtil.remove(response, name, null);
    }

    public static void remove(HttpServletResponse response, String name, String domain) {
        Cookie cookie = new Cookie(name, "");
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setPath("/");
        cookie.setSecure(false);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public static String getScript(String name, String value, String domain, String path, int expiry, boolean secure) {
        long timeMillis = System.currentTimeMillis();
        StringBuilder buffer = new StringBuilder();
        buffer.append("\"");
        buffer.append(name);
        buffer.append("=\" + encodeURIComponent(\"");
        buffer.append(value);
        buffer.append("\") + \"; expires=\" + (new Date(");
        buffer.append(timeMillis + (long)expiry);
        buffer.append(")).toUTCString()");
        if (domain != null && domain.trim().length() > 0) {
            buffer.append(" + \"; domain=");
            buffer.append(domain.trim()).append("\"");
        }
        if (path != null && path.trim().length() > 0) {
            buffer.append(" + \"; path=");
            buffer.append(path.trim()).append("\"");
        }
        if (secure) {
            buffer.append(" + \"; secure\"");
        }
        return buffer.toString();
    }
}

