/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web.servlet;

import com.jxdinfo.hussar.monitor.util.HtmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServlet;

public class JspServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final byte[] TRUE = "true".getBytes();
    private static final byte[] FALSE = "false".getBytes();
    private static final Charset UTF8 = Charset.forName("utf-8");

    protected void print(PrintWriter out, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Number || value instanceof Boolean) {
            out.write(value.toString());
            return;
        }
        out.write(HtmlUtil.encode(value.toString()));
    }

    protected void write(OutputStream out, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof Number) {
            byte[] bytes = value.toString().getBytes();
            out.write(bytes, 0, bytes.length);
            return;
        }
        if (value instanceof Boolean) {
            if (value.equals(Boolean.TRUE)) {
                out.write(TRUE, 0, 4);
            } else {
                out.write(FALSE, 0, 5);
            }
            return;
        }
        String content = HtmlUtil.encode(value.toString());
        byte[] bytes = content.getBytes(UTF8);
        out.write(bytes, 0, bytes.length);
    }

    protected static byte[] b(String text) {
        return text.getBytes(UTF8);
    }
}

