/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web.servlet;

import com.jxdinfo.hussar.monitor.util.GMTUtil;
import com.jxdinfo.hussar.monitor.util.IO;
import com.jxdinfo.hussar.monitor.web.FileType;
import com.jxdinfo.hussar.monitor.web.MimeType;
import com.jxdinfo.hussar.monitor.web.Range;
import com.jxdinfo.hussar.monitor.web.servlet.BaseServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FileServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void service(HttpServletRequest request, HttpServletResponse response, File file, boolean download) throws IOException {
        block13: {
            String contentType;
            Range range;
            long length;
            block11: {
                long lastModified;
                length = file.length();
                String eTag = this.getETag(length, lastModified = file.lastModified());
                if (!FileServlet.checkIfHeaders(request, response, eTag, lastModified)) {
                    return;
                }
                range = Range.parse(request, length);
                String httpDate = GMTUtil.format(lastModified);
                contentType = MimeType.getMimeType(file.getName());
                logger.debug("[{}], {}", (Object)length, (Object)file.getName());
                response.setHeader("Accept-Ranges", "bytes");
                response.setHeader("ETag", eTag);
                response.setHeader("Last-Modified", GMTUtil.format(lastModified));
                response.setHeader("Date", httpDate);
                response.setDateHeader("Expires", System.currentTimeMillis() + 3600000L);
                response.setContentType(contentType);
                if (range != null) break block11;
                response.setHeader("Content-Length", String.valueOf(length));
                if (download || contentType.equals("application/octet-stream")) {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + this.urlEncode(FileType.getName(file.getName()), "UTF-8") + "\"");
                }
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(file);
                    IO.copy(inputStream, (OutputStream)response.getOutputStream(), 8192, length);
                }
                catch (IOException iOException) {
                    IO.close(inputStream);
                    catch (Throwable throwable) {
                        IO.close(inputStream);
                        throw throwable;
                    }
                }
                IO.close(inputStream);
                logger.debug("download end: {}", (Object)file.getName());
                break block13;
            }
            RandomAccessFile raf = null;
            long maxBodySize = 0x500000L;
            long size = range.getSize();
            String contentRange = range.getContentRange();
            response.setStatus(206);
            response.setHeader("Content-Range", contentRange);
            response.setHeader("Content-Length", String.valueOf(size));
            response.setHeader("Part-Size", String.valueOf(maxBodySize));
            response.setHeader("Content-Type", contentType);
            try {
                raf = new RandomAccessFile(file, "r");
                if (range.start > 0L && range.start < length) {
                    raf.seek(range.start);
                }
                logger.debug("response.size: {}, response.range: {}", (Object)size, (Object)contentRange);
                long t1 = System.currentTimeMillis();
                this.copy(raf, (OutputStream)response.getOutputStream(), 8192, size);
                long t2 = System.currentTimeMillis();
                logger.debug("response.times: {}", (Object)(t2 - t1));
            }
            catch (IOException e) {
                try {
                    logger.debug(e.getMessage());
                }
                catch (Throwable throwable) {
                    IO.close(raf);
                    throw throwable;
                }
                IO.close(raf);
            }
            IO.close(raf);
        }
    }

    protected String getETag(long length, long lastModified) {
        return "W/\"" + length + "-" + lastModified + "\"";
    }

    public static boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, String eTag, long lastModified) throws IOException {
        if (!FileServlet.checkIfMatch(request, response, eTag, lastModified)) {
            return false;
        }
        if (!FileServlet.checkIfModifiedSince(request, response, eTag, lastModified)) {
            return false;
        }
        if (!FileServlet.checkIfNoneMatch(request, response, eTag, lastModified)) {
            return false;
        }
        return FileServlet.checkIfUnmodifiedSince(request, response, eTag, lastModified);
    }

    protected static boolean checkIfMatch(HttpServletRequest request, HttpServletResponse response, String eTag, long lastModified) throws IOException {
        String ifMatch = request.getHeader("If-Match");
        if (ifMatch != null && ifMatch.indexOf(42) < 0) {
            if (FileServlet.contains(ifMatch, eTag)) {
                return true;
            }
            response.sendError(412);
            return false;
        }
        return true;
    }

    protected static boolean checkIfModifiedSince(HttpServletRequest request, HttpServletResponse response, String eTag, long lastModified) throws IOException {
        try {
            long ifModifiedSince = request.getDateHeader("If-Modified-Since");
            if (ifModifiedSince != -1L && request.getHeader("If-None-Match") == null && lastModified < ifModifiedSince + 1000L) {
                response.setStatus(304);
                response.setHeader("ETag", eTag);
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        return true;
    }

    protected static boolean checkIfNoneMatch(HttpServletRequest request, HttpServletResponse response, String eTag, long lastModified) throws IOException {
        String ifNoneMatch = request.getHeader("If-None-Match");
        if (ifNoneMatch != null) {
            boolean flag = false;
            flag = ifNoneMatch.equals("*") ? true : FileServlet.contains(ifNoneMatch, eTag);
            if (flag) {
                String method = request.getMethod();
                if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
                    response.setStatus(304);
                    response.setHeader("ETag", eTag);
                    return false;
                }
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected static boolean checkIfUnmodifiedSince(HttpServletRequest request, HttpServletResponse response, String eTag, long lastModified) throws IOException {
        try {
            long ifUnmodifiedSince = request.getDateHeader("If-Unmodified-Since");
            if (ifUnmodifiedSince != -1L && lastModified >= ifUnmodifiedSince + 1000L) {
                response.sendError(412);
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        return true;
    }

    private String urlEncode(String text, String encoding) {
        try {
            return URLEncoder.encode(text, encoding);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private static boolean contains(String content, String value) {
        if (content != null) {
            StringTokenizer tokenizer = new StringTokenizer(content, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.trim().equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    protected void copy(RandomAccessFile raf, OutputStream outputStream, int bufferSize, long size) throws IOException {
        long count;
        int readBytes = 0;
        int length = Math.min(bufferSize, (int)size);
        byte[] buffer = new byte[length];
        for (count = size; count > 0L && (readBytes = count > (long)length ? raf.read(buffer, 0, length) : raf.read(buffer, 0, (int)count)) > 0; count -= (long)readBytes) {
            outputStream.write(buffer, 0, readBytes);
        }
        logger.debug("write.size: {}", (Object)(size - count));
        outputStream.flush();
    }
}

