/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web.servlet;

import com.jxdinfo.hussar.monitor.cache.Cache;
import com.jxdinfo.hussar.monitor.cache.CacheFactory;
import com.jxdinfo.hussar.monitor.util.StringUtil;
import com.jxdinfo.hussar.monitor.web.ActionDispatcher;
import com.jxdinfo.hussar.monitor.web.servlet.BaseServlet;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DispatchServlet
extends BaseServlet {
    private static final long serialVersionUID = 5223399743645123446L;
    private ActionDispatcher dispatcher = new ActionDispatcher();

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String[] packages = this.getArray(servletConfig, "packages");
        if (packages.length == 0) {
            packages = new String[]{"com.jxdinfo.hussar.monitor.web.servlet", "com.jxdinfo.hussar.monitor.servlet"};
        }
        String[] hosts = this.getArray(servletConfig, "hosts");
        String local = servletConfig.getInitParameter("local");
        String htmlPath = servletConfig.getInitParameter("htmlPath");
        Cache cache = CacheFactory.getInstance();
        cache.put("hosts", -1, hosts);
        cache.put("local", -1, local);
        cache.put("htmlPath", -1, StringUtil.notBlank(htmlPath) ? htmlPath : "/smon/index.html");
        this.dispatcher.setPackages(packages);
        this.dispatcher.init(this.getServletContext());
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.dispatcher.service(request, response);
    }

    private String[] getArray(ServletConfig servletConfig, String name) {
        String content = servletConfig.getInitParameter(name);
        if (content == null) {
            return new String[0];
        }
        return StringUtil.split(content, ",", true, true);
    }

    public void destroy() {
        if (this.dispatcher != null) {
            this.dispatcher.destroy();
            this.dispatcher = null;
        }
    }
}

