/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BaseServlet
extends HttpServlet {
    private static final long serialVersionUID = 1508316928849911097L;
    protected ServletContext servletContext;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletContext = servletConfig.getServletContext();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new ServletException("unsupported operation.");
    }

    public void forward(HttpServletRequest request, HttpServletResponse response, String page) throws ServletException, IOException {
        request.getRequestDispatcher(page).forward((ServletRequest)request, (ServletResponse)response);
    }

    public ServletContext getServletContext() {
        if (this.servletContext != null) {
            return this.servletContext;
        }
        return super.getServletContext();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.length() <= 1) {
            return "";
        }
        return contextPath;
    }

    protected void setStatus(HttpServletRequest request, HttpServletResponse response, int status, String message) throws ServletException, IOException {
        request.setAttribute("javax_servlet_error", (Object)message);
        response.sendError(status);
    }

    protected boolean getBoolean(HttpServletRequest request, String name, boolean defaultValue) {
        String value = request.getParameter(name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    protected String getTrimString(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        return value != null ? value.trim() : "";
    }

    protected String getInputValue(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        if (value == null) {
            return "";
        }
        int k = value.indexOf(10);
        if (k > -1) {
            return value.substring(0, k).trim();
        }
        return value.trim();
    }

    protected int getInteger(HttpServletRequest request, String name, int defaultValue) {
        String value = request.getParameter(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected long getLong(HttpServletRequest request, String name, long defaultValue) {
        String value = request.getParameter(name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

