/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web.filter;

import com.jxdinfo.hussar.monitor.web.Request;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterEncodingFilter
implements Filter {
    private String encoding;
    private static final Logger logger = LoggerFactory.getLogger((String)"accessLogger");

    public void init(FilterConfig filterConfig) throws ServletException {
        this.encoding = filterConfig.getInitParameter("encoding");
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("CharacterEncodingFilter just supports HTTP requests");
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String ip = Request.getRemoteAddress(request);
        String method = request.getMethod();
        String requestURI = request.getRequestURI();
        String queryString = request.getQueryString();
        String userAgent = request.getHeader("User-Agent");
        String referer = request.getHeader("Referer");
        if (queryString != null) {
            logger.info("{},{},{}?{},\"{}\",\"{}\"", new Object[]{ip, method, requestURI, queryString, referer, userAgent});
        } else {
            logger.info("{},{},{},\"{}\",\"{}\"", new Object[]{ip, method, requestURI, referer, userAgent});
        }
        request.setAttribute("FILTER_REQUEST_URI", (Object)request.getRequestURI());
        request.setAttribute("FILTER_REQUEST_URL", (Object)request.getRequestURL());
        this.doFilterInternal(request, response, filterChain);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.encoding != null && request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(this.encoding);
            response.setCharacterEncoding(this.encoding);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

