/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.web;

import com.jxdinfo.hussar.monitor.web.MimeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Response {
    public static void error(HttpServletRequest request, HttpServletResponse response, String page, int status, String message, String redirect) throws ServletException, IOException {
        request.setAttribute("status", (Object)status);
        request.setAttribute("message", (Object)message);
        request.setAttribute("redirect", (Object)redirect);
        request.getRequestDispatcher(page).forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void setCache(HttpServletResponse response, int minutes) {
        if (minutes < 1) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache, must-revalidate");
            response.setHeader("Expires", "0");
        } else {
            long currentTimeMillis = System.currentTimeMillis();
            response.setHeader("Cache-Control", "public");
            response.addHeader("Cache-Control", "max-age=" + minutes * 60);
            response.setDateHeader("Expires", currentTimeMillis + (long)(minutes * 60 * 1000));
        }
    }

    public static void write(HttpServletRequest request, HttpServletResponse response, String content) throws IOException {
        Response.write(request, response, "text/html; charset=UTF-8", content);
    }

    public static void write(HttpServletRequest request, HttpServletResponse response, String contentType, String content) throws IOException {
        byte[] buffer = content.getBytes("UTF-8");
        response.setContentType(contentType);
        response.setContentLength(buffer.length);
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(buffer);
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(HttpServletRequest request, HttpServletResponse response, String fileName, File file) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Response.download(request, response, fileName, inputStream, file.length());
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void download(HttpServletRequest request, HttpServletResponse response, String fileName, InputStream inputStream, long contentLength) throws IOException {
        String contentType = MimeType.getMimeType(fileName);
        response.setContentType(contentType);
        response.setContentLength((int)contentLength);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(fileName, "utf-8") + "\"");
        int length = 0;
        byte[] buffer = new byte[4096];
        ServletOutputStream outputStream = response.getOutputStream();
        while ((length = inputStream.read(buffer, 0, 4096)) > -1) {
            outputStream.write(buffer, 0, length);
        }
        outputStream.flush();
    }
}

